/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.data;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.Module;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.data.FakeBiome;
import org.blockartistry.mod.DynSurround.data.SoundRegistry;
import org.blockartistry.mod.DynSurround.data.config.BiomeConfig;
import org.blockartistry.mod.DynSurround.data.config.SoundConfig;
import org.blockartistry.mod.DynSurround.event.RegistryReloadEvent;
import org.blockartistry.mod.DynSurround.util.Color;
import org.blockartistry.mod.DynSurround.util.MyUtils;

public final class BiomeRegistry {
    public static final Map<String, BiomeRegistryEntry> registry = new HashMap<String, BiomeRegistryEntry>();
    private static final Map<String, String> biomeAliases = new HashMap<String, String>();
    public static final BiomeGenBase UNDERGROUND = new FakeBiome(-1, "Underground");
    public static final BiomeGenBase PLAYER = new FakeBiome(-2, "Player");
    public static final BiomeGenBase UNDERWATER = new FakeBiome(-3, "Underwater");
    public static final BiomeGenBase UNDEROCEAN = new FakeBiome(-4, "UnderOCN");
    public static final BiomeGenBase UNDERDEEPOCEAN = new FakeBiome(-5, "UnderDOCN");
    public static final BiomeGenBase UNDERRIVER = new FakeBiome(-6, "UnderRVR");
    public static final BiomeGenBase OUTERSPACE = new FakeBiome(-7, "OuterSpace");
    public static final BiomeGenBase CLOUDS = new FakeBiome(-8, "Clouds");
    public static final SoundEffect WATER_DRIP = new SoundEffect("dsurround:waterdrops");
    private static final BiomeGenBase WTF = new FakeBiome(-256, "(FooBar)");

    public static String resolveName(BiomeGenBase biome) {
        if (biome == null) {
            return "(Bad Biome)";
        }
        if (StringUtils.isEmpty((CharSequence)biome.field_76791_y)) {
            return "#" + biome.field_76756_M;
        }
        return biome.field_76791_y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Map<String, BiomeRegistryEntry> map = registry;
        synchronized (map) {
            biomeAliases.clear();
            for (String string : ModOptions.biomeAliases) {
                String[] parts = StringUtils.split((String)string, (String)"=");
                if (parts.length != 2) continue;
                biomeAliases.put(parts[0], parts[1]);
            }
            registry.clear();
            if (Module.LOTR && ModOptions.useLotrReflection) {
                try {
                    Field[] declaredFields;
                    Class<?> lotrBiome = Class.forName("lotr.common.world.biome.LOTRBiome");
                    for (Field field : declaredFields = lotrBiome.getDeclaredFields()) {
                        if (!Modifier.isStatic(field.getModifiers())) continue;
                        field.setAccessible(true);
                        Object object = field.get(null);
                        if (!(object instanceof BiomeGenBase)) continue;
                        BiomeGenBase biome = (BiomeGenBase)object;
                        registry.put(biome.field_76791_y, new BiomeRegistryEntry(biome));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {}
            } else {
                Module.LOTR_PROXY.registerLOTRBiomes();
            }
            for (String string : BiomeGenBase.func_150565_n()) {
                if (string == null) continue;
                registry.put(((BiomeGenBase)string).field_76791_y, new BiomeRegistryEntry((BiomeGenBase)string));
            }
            registry.put(BiomeRegistry.UNDERGROUND.field_76791_y, new BiomeRegistryEntry(UNDERGROUND));
            registry.put(BiomeRegistry.UNDERWATER.field_76791_y, new BiomeRegistryEntry(UNDERWATER));
            registry.put(BiomeRegistry.UNDEROCEAN.field_76791_y, new BiomeRegistryEntry(UNDEROCEAN));
            registry.put(BiomeRegistry.UNDERDEEPOCEAN.field_76791_y, new BiomeRegistryEntry(UNDERDEEPOCEAN));
            registry.put(BiomeRegistry.UNDERRIVER.field_76791_y, new BiomeRegistryEntry(UNDERRIVER));
            registry.put(BiomeRegistry.OUTERSPACE.field_76791_y, new BiomeRegistryEntry(OUTERSPACE));
            registry.put(BiomeRegistry.CLOUDS.field_76791_y, new BiomeRegistryEntry(CLOUDS));
            registry.put(BiomeRegistry.PLAYER.field_76791_y, new BiomeRegistryEntry(PLAYER));
            registry.put(BiomeRegistry.WTF.field_76791_y, new BiomeRegistryEntry(WTF));
            BiomeRegistry.processConfig();
            if (ModOptions.enableDebugLogging) {
                ModLog.info("*** BIOME REGISTRY ***", new Object[0]);
                registry.values().stream().sorted().forEach(entry -> ModLog.info(entry.toString(), new Object[0]));
            }
            biomeAliases.clear();
        }
        MinecraftForge.EVENT_BUS.post((Event)new RegistryReloadEvent.Biome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BiomeRegistryEntry get(BiomeGenBase biome) {
        Map<String, BiomeRegistryEntry> map = registry;
        synchronized (map) {
            BiomeRegistryEntry entry = registry.get(biome == null ? BiomeRegistry.WTF.field_76791_y : biome.field_76791_y);
            if (entry == null) {
                ModLog.warn("Biome [%s] was not detected during initial scan! Reloading config...", BiomeRegistry.resolveName(biome));
                BiomeRegistry.initialize();
                entry = registry.get(biome.field_76791_y);
                if (entry == null) {
                    ModLog.warn("Still can't find biome [%s]! Explicitly adding at defaults", BiomeRegistry.resolveName(biome));
                    entry = new BiomeRegistryEntry(biome);
                    registry.put(biome.field_76791_y, entry);
                }
            }
            return entry;
        }
    }

    public static boolean hasDust(BiomeGenBase biome) {
        return BiomeRegistry.get((BiomeGenBase)biome).hasDust;
    }

    public static boolean hasPrecipitation(BiomeGenBase biome) {
        return BiomeRegistry.get((BiomeGenBase)biome).hasPrecipitation;
    }

    public static boolean hasAurora(BiomeGenBase biome) {
        return BiomeRegistry.get((BiomeGenBase)biome).hasAurora;
    }

    public static boolean hasFog(BiomeGenBase biome) {
        return BiomeRegistry.get((BiomeGenBase)biome).hasFog;
    }

    public static Color getDustColor(BiomeGenBase biome) {
        return BiomeRegistry.get((BiomeGenBase)biome).dustColor;
    }

    public static Color getFogColor(BiomeGenBase biome) {
        return BiomeRegistry.get((BiomeGenBase)biome).fogColor;
    }

    public static float getFogDensity(BiomeGenBase biome) {
        return BiomeRegistry.get((BiomeGenBase)biome).fogDensity;
    }

    public static SoundEffect getSound(BiomeGenBase biome, String conditions) {
        return BiomeRegistry.get(biome).findSoundMatch(conditions);
    }

    public static List<SoundEffect> getSounds(BiomeGenBase biome, String conditions) {
        return BiomeRegistry.get(biome).findSoundMatches(conditions);
    }

    public static SoundEffect getSpotSound(BiomeGenBase biome, String conditions, Random random) {
        BiomeRegistryEntry e = BiomeRegistry.get(biome);
        if (e.spotSounds.isEmpty() || random.nextInt(e.spotSoundChance) != 0) {
            return null;
        }
        int totalWeight = 0;
        ArrayList<SoundEffect> candidates = new ArrayList<SoundEffect>();
        for (SoundEffect s : e.spotSounds) {
            if (!s.matches(conditions)) continue;
            candidates.add(s);
            totalWeight += s.weight;
        }
        if (totalWeight <= 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (SoundEffect)candidates.get(0);
        }
        int targetWeight = random.nextInt(totalWeight);
        int i = candidates.size();
        while ((targetWeight -= ((SoundEffect)candidates.get((int)(i - 1))).weight) >= 0) {
            --i;
        }
        return (SoundEffect)candidates.get(i - 1);
    }

    private static void processConfig() {
        String[] configFiles;
        try {
            BiomeRegistry.process(BiomeConfig.load("dsurround"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String file : configFiles = ModOptions.biomeConfigFiles) {
            File theFile = new File(Module.dataDirectory(), file);
            if (theFile.exists()) {
                try {
                    BiomeConfig config = BiomeConfig.load(theFile);
                    if (config != null) {
                        BiomeRegistry.process(config);
                        continue;
                    }
                    ModLog.warn("Unable to process biome config file " + file, new Object[0]);
                }
                catch (Exception ex) {
                    ModLog.error("Unable to process biome config file " + file, ex);
                }
                continue;
            }
            ModLog.warn("Could not locate biome config file [%s]", file);
        }
    }

    static boolean isBiomeMatch(BiomeConfig.Entry entry, String biomeName) {
        if (Pattern.matches(entry.biomeName, biomeName)) {
            return true;
        }
        String alias = biomeAliases.get(biomeName);
        return alias != null && Pattern.matches(entry.biomeName, alias);
    }

    private static void process(BiomeConfig config) {
        for (BiomeConfig.Entry entry : config.entries) {
            for (BiomeRegistryEntry biomeEntry : registry.values()) {
                int[] rgb;
                if (!BiomeRegistry.isBiomeMatch(entry, BiomeRegistry.resolveName(biomeEntry.biome))) continue;
                if (entry.hasPrecipitation != null) {
                    biomeEntry.hasPrecipitation = entry.hasPrecipitation;
                }
                if (entry.hasAurora != null) {
                    biomeEntry.hasAurora = entry.hasAurora;
                }
                if (entry.hasDust != null) {
                    biomeEntry.hasDust = entry.hasDust;
                }
                if (entry.hasFog != null) {
                    biomeEntry.hasFog = entry.hasFog;
                }
                if (entry.fogDensity != null) {
                    biomeEntry.fogDensity = entry.fogDensity.floatValue();
                }
                if (entry.fogColor != null && (rgb = MyUtils.splitToInts(entry.fogColor, ',')).length == 3) {
                    biomeEntry.fogColor = new Color(rgb[0], rgb[1], rgb[2]);
                }
                if (entry.dustColor != null && (rgb = MyUtils.splitToInts(entry.dustColor, ',')).length == 3) {
                    biomeEntry.dustColor = new Color(rgb[0], rgb[1], rgb[2]);
                }
                if (entry.soundReset != null && entry.soundReset.booleanValue()) {
                    biomeEntry.sounds = new ArrayList<SoundEffect>();
                    biomeEntry.spotSounds = new ArrayList<SoundEffect>();
                }
                if (entry.spotSoundChance != null) {
                    biomeEntry.spotSoundChance = entry.spotSoundChance;
                }
                for (SoundConfig sr : entry.sounds) {
                    if (SoundRegistry.isSoundBlocked(sr.sound)) continue;
                    SoundEffect s = new SoundEffect(sr);
                    if (s.type == SoundEffect.SoundType.SPOT) {
                        biomeEntry.spotSounds.add(s);
                        continue;
                    }
                    biomeEntry.sounds.add(s);
                }
            }
        }
    }

    public static class BiomeRegistryEntry
    implements Comparable<BiomeRegistryEntry> {
        private static Class<?> bopBiome;
        private static Field bopBiomeFogDensity;
        private static Field bopBiomeFogColor;
        public final BiomeGenBase biome;
        public boolean hasPrecipitation;
        public boolean hasDust;
        public boolean hasAurora;
        public boolean hasFog;
        public Color dustColor;
        public Color fogColor;
        public float fogDensity;
        public List<SoundEffect> sounds;
        public int spotSoundChance;
        public List<SoundEffect> spotSounds;

        public BiomeRegistryEntry(BiomeGenBase biome) {
            this.biome = biome;
            this.hasPrecipitation = biome.func_76738_d() || biome.func_76746_c();
            this.sounds = new ArrayList<SoundEffect>();
            this.spotSounds = new ArrayList<SoundEffect>();
            this.spotSoundChance = 1200;
            if (bopBiome != null && bopBiome.isInstance(biome)) {
                try {
                    int color = bopBiomeFogColor.getInt(biome);
                    if (color > 0) {
                        this.hasFog = true;
                        this.fogColor = new Color(color);
                        this.fogDensity = bopBiomeFogDensity.getFloat(biome);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public SoundEffect findSoundMatch(String conditions) {
            for (SoundEffect sound : this.sounds) {
                if (!sound.matches(conditions)) continue;
                return sound;
            }
            return null;
        }

        public List<SoundEffect> findSoundMatches(String conditions) {
            ArrayList<SoundEffect> results = new ArrayList<SoundEffect>();
            for (SoundEffect sound : this.sounds) {
                if (!sound.matches(conditions)) continue;
                results.add(sound);
            }
            return results;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Biome %d [%s]:", this.biome.field_76756_M, BiomeRegistry.resolveName(this.biome)));
            if (this.hasPrecipitation) {
                builder.append(" PRECIPITATION");
            }
            if (this.hasDust) {
                builder.append(" DUST");
            }
            if (this.hasAurora) {
                builder.append(" AURORA");
            }
            if (this.hasFog) {
                builder.append(" FOG");
            }
            if (!(this.hasPrecipitation || this.hasDust || this.hasAurora || this.hasFog)) {
                builder.append(" NONE");
            }
            if (this.dustColor != null) {
                builder.append(" dustColor:").append(this.dustColor);
            }
            if (this.fogColor != null) {
                builder.append(" fogColor:").append(this.fogColor);
                builder.append(" fogDensity:").append(this.fogDensity);
            }
            if (!this.sounds.isEmpty()) {
                builder.append("; sounds [");
                for (SoundEffect sound : this.sounds) {
                    builder.append(sound.toString()).append(',');
                }
                builder.append(']');
            }
            if (!this.spotSounds.isEmpty()) {
                builder.append("; spot sound chance:").append(this.spotSoundChance);
                builder.append(" spot sounds [");
                for (SoundEffect sound : this.spotSounds) {
                    builder.append(sound.toString()).append(',');
                }
                builder.append(']');
            }
            return builder.toString();
        }

        @Override
        public int compareTo(BiomeRegistryEntry e) {
            return this.biome.field_76791_y.compareToIgnoreCase(e.biome.field_76791_y);
        }

        static {
            try {
                bopBiome = Class.forName("biomesoplenty.common.biome.BOPBiome");
                bopBiomeFogDensity = ReflectionHelper.findField(bopBiome, (String[])new String[]{"fogDensity"});
                bopBiomeFogColor = ReflectionHelper.findField(bopBiome, (String[])new String[]{"fogColor"});
            }
            catch (Throwable t) {
                bopBiome = null;
                bopBiomeFogDensity = null;
                bopBiomeFogColor = null;
            }
        }
    }
}

