/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.commands;

import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.data.BlockRegistry;
import org.blockartistry.mod.DynSurround.data.DimensionEffectData;

public final class CommandRain
extends CommandBase {
    private static final List<String> ALIAS = ImmutableList.builder().add((Object[])new String[]{"r", "br"}).build();
    private static final DecimalFormat FORMATTER = new DecimalFormat("0.0");

    public static String statusOutput(World world, DimensionEffectData data) {
        StringBuilder builder = new StringBuilder();
        float minutes = (float)world.func_72912_H().func_76083_p() / 20.0f / 60.0f;
        builder.append(data.toString());
        builder.append("; isRaining: ").append(world.func_72896_J());
        builder.append("; isSurface: ").append(world.field_73011_w.func_76569_d());
        builder.append("; strength: ").append(FORMATTER.format(world.func_72867_j(1.0f) * 100.0f));
        builder.append("; timer: ").append(FORMATTER.format(minutes)).append(" minutes");
        return builder.toString();
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "rain";
    }

    public List<String> func_71514_a() {
        return ALIAS;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rain <status | reset | reload | 1-100 | <<setmax|setmin> 0-100>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] parms) {
        EntityPlayerMP player = CommandRain.func_71521_c((ICommandSender)sender);
        World world = player.field_70170_p;
        DimensionEffectData data = DimensionEffectData.get(world);
        if (parms.length == 1) {
            if ("status".compareToIgnoreCase(parms[0]) == 0) {
                player.func_145747_a((IChatComponent)new ChatComponentText(CommandRain.statusOutput(world, data)));
                return;
            } else if ("reset".compareToIgnoreCase(parms[0]) == 0) {
                world.field_73011_w.resetRainAndThunder();
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"msg.RainReset")));
                return;
            } else if ("reload".compareToIgnoreCase(parms[0]) == 0) {
                BiomeRegistry.initialize();
                BlockRegistry.initialize();
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"msg.BiomeReload")));
                return;
            } else {
                double d = CommandRain.func_110661_a((ICommandSender)sender, (String)parms[0], (double)0.0, (double)100.0) / 100.0;
                data.setRainIntensity((float)d);
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"msg.RainIntensitySet", (Object[])new Object[]{FORMATTER.format(data.getRainIntensity() * 100.0f)})));
            }
            return;
        } else if (parms.length == 2) {
            if ("setmin".compareToIgnoreCase(parms[0]) == 0) {
                double d = CommandRain.func_110661_a((ICommandSender)sender, (String)parms[1], (double)0.0, (double)100.0) / 100.0;
                data.setMinRainIntensity((float)d);
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"msg.MinRainIntensitySet", (Object[])new Object[]{FORMATTER.format(data.getMinRainIntensity() * 100.0f)})));
                return;
            } else {
                if ("setmax".compareToIgnoreCase(parms[0]) != 0) throw new CommandException(this.func_71518_a(sender), new Object[0]);
                double d = CommandRain.func_110661_a((ICommandSender)sender, (String)parms[1], (double)0.0, (double)100.0) / 100.0;
                data.setMaxRainIntensity((float)d);
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"msg.MaxRainIntensitySet", (Object[])new Object[]{FORMATTER.format(data.getMaxRainIntensity() * 100.0f)})));
            }
            return;
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText(this.func_71518_a(sender)));
        }
    }
}

