/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.sound.cache;

import com.google.common.io.ByteStreams;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.sound.cache.MemoryStreamHandler;
import org.blockartistry.mod.DynSurround.client.sound.cache.SoundStreamHandler;

@SideOnly(value=Side.CLIENT)
public final class SoundCache {
    private static final int BUFFER_SIZE = 65536;
    private static final byte[] BUFFER = new byte[65536];
    private static final IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
    private static final Map<ResourceLocation, URL> cache = new HashMap<ResourceLocation, URL>(256);
    private static final byte[] SILENCE = SoundCache.getBuffer(new ResourceLocation("dsurround:sounds/ambient/silence.ogg"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] getBuffer(@Nonnull ResourceLocation resource) {
        block27: {
            InputStream stream;
            block23: {
                byte[] byArray;
                block26: {
                    int bytesRead;
                    block24: {
                        byte[] byArray2;
                        block25: {
                            block21: {
                                byte[] byArray3;
                                block22: {
                                    stream = null;
                                    stream = manager.func_110536_a(resource).func_110527_b();
                                    if (stream != null) break block21;
                                    ModLog.warn("No stream returned for [%s]", resource.toString());
                                    byArray3 = SILENCE;
                                    if (stream == null) break block22;
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                return byArray3;
                            }
                            if (stream.available() >= 65536) break block23;
                            bytesRead = ByteStreams.read((InputStream)stream, (byte[])BUFFER, (int)0, (int)65536);
                            if (bytesRead != 0 && bytesRead != 65536) break block24;
                            byArray2 = null;
                            if (stream == null) break block25;
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return byArray2;
                    }
                    byArray = Arrays.copyOf(BUFFER, bytesRead);
                    if (stream == null) break block26;
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return byArray;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable bytesRead) {}
            }
            break block27;
            catch (Throwable t) {
                try {
                    ModLog.warn("Error reading stream [%s]", resource.toString());
                    byte[] byArray = SILENCE;
                    return byArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
        return null;
    }

    private static URL load(@Nonnull ResourceLocation key) throws Exception {
        byte[] buffer = SoundCache.getBuffer(key);
        SoundStreamHandler handler = buffer == null ? new SoundStreamHandler(key) : new MemoryStreamHandler(key, buffer);
        return new URL(null, handler.getSpec(), handler);
    }

    private SoundCache() {
    }

    public static URL getURLForSoundResource(@Nonnull ResourceLocation soundResource) {
        URL result = cache.get(soundResource);
        if (result == null) {
            try {
                result = SoundCache.load(soundResource);
                cache.put(soundResource, result);
            }
            catch (Throwable t) {
                throw new Error("Unable to load sound from cache!");
            }
        }
        return result;
    }
}

