/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.util.MyUtils;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
class PlayerSound
extends MovingSound {
    private static final float DONE_VOLUME_THRESHOLD = 0.001f;
    private static final float FADE_AMOUNT = 0.015f;
    private static final Random RANDOM = new XorShiftRandom();
    private final SoundEffect sound;
    private boolean isFading;
    private float maxVolume;
    private boolean isDonePlaying;
    private long lastTick;

    public PlayerSound(SoundEffect sound) {
        super(new ResourceLocation(sound.sound));
        this.sound = sound;
        this.field_147662_b = sound.volume;
        this.maxVolume = sound.getVolume();
        this.field_147662_b = 0.002f;
        this.field_147663_c = sound.getPitch(RANDOM);
        this.field_147659_g = sound.repeatDelay == 0;
        this.field_147665_h = 0;
        this.lastTick = EnvironStateHandler.EnvironState.getTickCounter() - 1;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.updateLocation();
    }

    public void fadeAway() {
        this.isFading = true;
    }

    public boolean isFading() {
        return this.isFading;
    }

    public boolean func_147667_k() {
        return this.isDonePlaying;
    }

    public boolean sameSound(SoundEffect snd) {
        return this.sound.equals(snd);
    }

    public void updateLocation() {
        AxisAlignedBB box = EnvironStateHandler.EnvironState.getPlayer().field_70121_D;
        Vec3 point = MyUtils.getCenter(box);
        this.field_147660_d = (float)point.field_72450_a;
        this.field_147661_e = (float)box.field_72338_b + 32.0f;
        this.field_147658_f = (float)point.field_72449_c;
    }

    public void func_73660_a() {
        if (this.func_147667_k()) {
            return;
        }
        if (!EnvironStateHandler.EnvironState.getPlayer().func_70089_S()) {
            this.isDonePlaying = true;
            return;
        }
        long tickDelta = (long)EnvironStateHandler.EnvironState.getTickCounter() - this.lastTick;
        if (tickDelta == 0L) {
            return;
        }
        this.lastTick = EnvironStateHandler.EnvironState.getTickCounter();
        if (this.isFading()) {
            this.field_147662_b -= 0.015f * (float)tickDelta;
        } else if (this.field_147662_b < this.maxVolume) {
            this.field_147662_b += 0.015f * (float)tickDelta;
        }
        if (this.field_147662_b > this.maxVolume) {
            this.field_147662_b = this.maxVolume;
        }
        if (this.field_147662_b <= 0.001f) {
            this.isDonePlaying = true;
            this.field_147662_b = 0.0f;
        } else {
            this.updateLocation();
        }
    }

    public float func_147653_e() {
        return super.func_147653_e() * ModOptions.masterSoundScaleFactor;
    }

    public void setVolume(float volume) {
        if (volume < this.maxVolume || !this.isFading) {
            this.maxVolume = volume;
        }
    }

    public String toString() {
        return this.sound.toString();
    }

    public boolean equals(Object anObj) {
        if (this == anObj) {
            return true;
        }
        if (anObj instanceof PlayerSound) {
            return this.sameSound(((PlayerSound)((Object)anObj)).sound);
        }
        if (anObj instanceof SoundEffect) {
            return this.sameSound((SoundEffect)anObj);
        }
        return false;
    }
}

