/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.BlockInfo;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.Substrate;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IBlockMap;
import org.blockartistry.mod.DynSurround.compat.MCHelper;

@SideOnly(value=Side.CLIENT)
public class BasicBlockMap
implements IBlockMap {
    private static final Pattern pattern = Pattern.compile("([^:]+:[^^+]+)\\^?(\\d+)?\\+?(\\w+)?");
    private final BlockInfo.BlockInfoMutable mutable = new BlockInfo.BlockInfoMutable();
    private final Map<BlockInfo, String> metaMap = new HashMap<BlockInfo, String>();
    private final Map<Substrate, Map<BlockInfo, String>> substrateMap = new EnumMap<Substrate, Map<BlockInfo, String>>(Substrate.class);
    private static final Map<String, List<MacroEntry>> macros = new LinkedHashMap<String, List<MacroEntry>>();

    public BasicBlockMap() {
        this.put(Blocks.field_150350_a, -1, null, "NOT_EMITTER");
    }

    @Override
    public String getBlockMap(Block block, int meta) {
        this.mutable.setBlock(block).setMeta(meta);
        String acoustic = this.metaMap.get(this.mutable);
        if (acoustic == null) {
            acoustic = this.metaMap.get(this.mutable.asGeneric());
        }
        return acoustic;
    }

    @Override
    public String getBlockMapSubstrate(Block block, int meta, Substrate substrate) {
        Map<BlockInfo, String> sub = this.substrateMap.get((Object)substrate);
        if (sub != null) {
            this.mutable.setBlock(block).setMeta(meta);
            String result = sub.get(this.mutable);
            if (result == null) {
                result = sub.get(this.mutable.asGeneric());
            }
            return result;
        }
        return null;
    }

    private void put(Block block, int meta, String substrate, String value) {
        BlockInfo info = new BlockInfo(block, meta);
        if (StringUtils.isEmpty((CharSequence)substrate)) {
            this.metaMap.put(info, value);
        } else {
            Substrate s = Substrate.get(substrate);
            Map sub = this.substrateMap.computeIfAbsent(s, k -> new HashMap());
            sub.put(info, value);
        }
    }

    private void expand(Block block, String value) {
        List<MacroEntry> macro = macros.get(value);
        if (macro != null) {
            for (MacroEntry entry : macro) {
                this.put(block, entry.meta, entry.substrate, entry.value);
            }
        } else {
            ModLog.debug("Unknown macro '%s'", value);
        }
    }

    @Override
    public void register(String key, String value) {
        Matcher matcher = pattern.matcher(key);
        if (matcher.matches()) {
            String blockName = matcher.group(1);
            Block block = MCHelper.getBlockNameRaw(blockName);
            if (block != null && block != Blocks.field_150350_a) {
                int meta = matcher.group(2) == null ? -1 : Integer.parseInt(matcher.group(2));
                String substrate = matcher.group(3);
                if (value.startsWith("#")) {
                    this.expand(block, value);
                } else {
                    this.put(block, meta, substrate, value);
                }
            } else {
                ModLog.debug("Unable to locate block for blockmap '%s'", blockName);
            }
        } else {
            ModLog.debug("Malformed key in blockmap '%s'", key);
        }
    }

    @Override
    public void collectData(Block block, int meta, List<String> data) {
    }

    static {
        ArrayList<MacroEntry> entries = new ArrayList<MacroEntry>();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put("#sapling", entries);
        macros.put("#reed", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry(0, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(1, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(2, "foliage", "brush"));
        entries.add(new MacroEntry(3, "foliage", "brush"));
        entries.add(new MacroEntry(4, "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry(5, "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry(6, "foliage", "straw"));
        entries.add(new MacroEntry(7, "foliage", "straw"));
        macros.put("#wheat", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry(0, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(1, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(2, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(3, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(4, "foliage", "brush"));
        entries.add(new MacroEntry(5, "foliage", "brush"));
        entries.add(new MacroEntry(6, "foliage", "brush"));
        entries.add(new MacroEntry(7, "foliage", "brush"));
        macros.put("#crop", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry("bigger", "bluntwood"));
        macros.put("#fence", entries);
    }

    private static class MacroEntry {
        public final int meta;
        public final String substrate;
        public final String value;

        public MacroEntry(String substrate, String value) {
            this(-1, substrate, value);
        }

        public MacroEntry(int meta, String substrate, String value) {
            this.meta = meta;
            this.substrate = substrate;
            this.value = value;
        }
    }
}

