/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.potion.Potion;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityCriticalPopOffFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityDamagePopOffFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityHealPopOffFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityTextPopOffFX;
import org.blockartistry.mod.DynSurround.network.Network;

public final class DamageEffectHandler {
    private static final double DISTANCE_THRESHOLD_SQ = 1024.0;

    private DamageEffectHandler() {
    }

    public static void initialize() {
        if (ModOptions.enableDamagePopoffs) {
            MinecraftForge.EVENT_BUS.register((Object)new DamageEffectHandler());
        }
    }

    private static boolean isCritical(EntityPlayer player, Entity target) {
        return player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && target instanceof EntityLivingBase;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurt(LivingHurtEvent event) {
        Entity entity;
        EntityDamageSourceIndirect dmgSource;
        if (event == null || event.entity == null || event.entity.field_70170_p == null || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (event.ammount <= 0.0f || event.entityLiving == null) {
            return;
        }
        boolean isCrit = false;
        if (event.source instanceof EntityDamageSourceIndirect) {
            dmgSource = (EntityDamageSourceIndirect)event.source;
            Entity entity2 = dmgSource.func_76364_f();
            if (entity2 instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)entity2;
                isCrit = arrow.func_70241_g();
            }
        } else if (event.source instanceof EntityDamageSource && (entity = (dmgSource = (EntityDamageSource)event.source).func_76364_f()) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            isCrit = DamageEffectHandler.isCritical(player, (Entity)event.entityLiving);
        }
        HealthData data = new HealthData((Entity)event.entityLiving, isCrit, (int)event.ammount);
        Network.sendHealthUpdate(data, event.entity.field_70170_p.field_73011_w.field_76574_g);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHeal(LivingHealEvent event) {
        if (event == null || event.entity == null || event.entity.field_70170_p == null || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (event.amount <= 0.0f || event.entityLiving == null || event.entityLiving.func_110143_aJ() == event.entityLiving.func_110138_aP()) {
            return;
        }
        HealthData data = new HealthData((Entity)event.entityLiving, false, -((int)event.amount));
        Network.sendHealthUpdate(data, event.entity.field_70170_p.field_73011_w.field_76574_g);
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleEvent(HealthData data) {
        EntityTextPopOffFX fx;
        if (!ModOptions.enableDamagePopoffs) {
            return;
        }
        if (EnvironStateHandler.EnvironState.isPlayer(data.entityId)) {
            return;
        }
        double distance = EnvironStateHandler.EnvironState.distanceToPlayer(data.posX, data.posY, data.posZ);
        if (distance >= 1024.0) {
            return;
        }
        World world = EnvironStateHandler.EnvironState.getWorld();
        EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
        if (data.isCritical) {
            fx = new EntityCriticalPopOffFX(world, data.posX, data.posY, data.posZ);
            renderer.func_78873_a((EntityFX)fx);
        }
        fx = data.amount > 0 ? new EntityDamagePopOffFX(world, data.posX, data.posY, data.posZ, data.amount) : new EntityHealPopOffFX(world, data.posX, data.posY, data.posZ, MathHelper.func_76130_a((int)data.amount));
        renderer.func_78873_a((EntityFX)fx);
    }

    public static class HealthData {
        public final UUID entityId;
        public final float posX;
        public final float posY;
        public final float posZ;
        public final boolean isCritical;
        public final int amount;

        public HealthData(Entity entity, boolean isCritical, int amount) {
            this.entityId = entity.func_110124_au();
            this.posX = (float)entity.field_70165_t;
            this.posY = (float)entity.field_70163_u + entity.field_70131_O;
            this.posZ = (float)entity.field_70161_v;
            this.isCritical = isCritical;
            this.amount = amount;
        }

        public HealthData(UUID id, float x, float y, float z, boolean isCritical, int amount) {
            this.entityId = id;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.isCritical = isCritical;
            this.amount = amount;
        }
    }
}

