/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.AuroraEffectHandler;
import org.blockartistry.mod.DynSurround.client.BiomeSurveyHandler;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.FogEffectHandler;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.client.PlayerSoundEffectHandler;
import org.blockartistry.mod.DynSurround.client.PotionParticleScrubHandler;
import org.blockartistry.mod.DynSurround.client.SoundBlockHandler;
import org.blockartistry.mod.DynSurround.client.footsteps.Footsteps;
import org.blockartistry.mod.DynSurround.client.fx.BlockEffectHandler;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;

@SideOnly(value=Side.CLIENT)
public class ClientEffectHandler {
    private static final List<IClientEffectHandler> effectHandlers = new ArrayList<IClientEffectHandler>();

    public static void register(IClientEffectHandler handler) {
        effectHandlers.add(handler);
        if (handler.hasEvents()) {
            MinecraftForge.EVENT_BUS.register((Object)handler);
            FMLCommonHandler.instance().bus().register((Object)handler);
        }
    }

    private ClientEffectHandler() {
    }

    public static void initialize() {
        ClientEffectHandler handler = new ClientEffectHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        FMLCommonHandler.instance().bus().register((Object)handler);
        ClientEffectHandler.register(new EnvironStateHandler());
        ClientEffectHandler.register(new BiomeSurveyHandler());
        ClientEffectHandler.register(new FogEffectHandler());
        ClientEffectHandler.register(new BlockEffectHandler());
        if (ModOptions.blockedSounds.length > 0 || ModOptions.culledSounds.length > 0) {
            ClientEffectHandler.register(new SoundBlockHandler());
        }
        if (ModOptions.enableFootstepSounds) {
            ClientEffectHandler.register(new Footsteps());
        }
        if (ModOptions.auroraEnable) {
            ClientEffectHandler.register(new AuroraEffectHandler());
        }
        if (ModOptions.enableBiomeSounds) {
            ClientEffectHandler.register(new PlayerSoundEffectHandler());
        }
        if (ModOptions.suppressPotionParticles) {
            ClientEffectHandler.register(new PotionParticleScrubHandler());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        if (world == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
            for (IClientEffectHandler handler : effectHandlers) {
                handler.process((World)world, (EntityPlayer)player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.world.field_72995_K) {
            return;
        }
        DimensionRegistry.loading(e.world);
    }
}

