/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.data.FakeBiome;

@SideOnly(value=Side.CLIENT)
public final class BiomeSurveyHandler
implements IClientEffectHandler {
    private static final int BIOME_SURVEY_RANGE = 6;
    private static int area;
    private static final TObjectIntHashMap<BiomeGenBase> weights;
    private static BiomeGenBase lastPlayerBiome;
    private static int lastDimension;
    private static int lastPlayerX;
    private static int lastPlayerY;
    private static int lastPlayerZ;

    public static int getArea() {
        return area;
    }

    public static TObjectIntHashMap<BiomeGenBase> getBiomes() {
        return weights;
    }

    private static void doSurvey(EntityPlayer player, int range) {
        area = 0;
        weights.clear();
        if (EnvironStateHandler.EnvironState.getPlayerBiome() instanceof FakeBiome) {
            area = 1;
            weights.put((Object)EnvironStateHandler.EnvironState.getPlayerBiome(), 1);
        } else {
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            for (int dX = -range; dX <= range; ++dX) {
                for (int dZ = -range; dZ <= range; ++dZ) {
                    ++area;
                    BiomeGenBase biome = player.field_70170_p.func_72807_a(x + dX, z + dZ);
                    weights.adjustOrPutValue((Object)biome, 1, 1);
                }
            }
        }
    }

    @Override
    public void process(World world, EntityPlayer player) {
        int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)player.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
        if (lastDimension != EnvironStateHandler.EnvironState.getDimensionId() || playerX != lastPlayerX || playerY != lastPlayerY || playerZ != lastPlayerZ || lastPlayerBiome != EnvironStateHandler.EnvironState.getPlayerBiome()) {
            lastPlayerBiome = EnvironStateHandler.EnvironState.getPlayerBiome();
            lastDimension = EnvironStateHandler.EnvironState.getDimensionId();
            lastPlayerX = playerX;
            lastPlayerY = playerY;
            lastPlayerZ = playerZ;
            BiomeSurveyHandler.doSurvey(player, 6);
        }
    }

    @Override
    public boolean hasEvents() {
        return false;
    }

    static {
        weights = new TObjectIntHashMap();
        lastPlayerBiome = null;
        lastDimension = 0;
        lastPlayerX = 0;
        lastPlayerY = 0;
        lastPlayerZ = 0;
    }
}

