/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest.quests;

import CoroUtil.quest.EnumQuestState;
import CoroUtil.quest.quests.ActiveQuest;
import CoroUtil.util.CoroUtilItem;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class ItemQuest
extends ActiveQuest {
    public String neededItemID;
    public int neededItemCount;
    public boolean returnToQuestGiver;
    public int curItemCount;

    public ItemQuest() {
        this.questType = "getItem";
    }

    public void initCustomData(String itemID, int count, boolean parReturnToQuestGiver) {
        super.initCustomData();
        this.neededItemID = itemID;
        this.neededItemCount = count;
        this.returnToQuestGiver = parReturnToQuestGiver;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.curState == EnumQuestState.ASSIGNED) {
            if (this.curItemCount >= this.neededItemCount) {
                if (this.returnToQuestGiver) {
                    this.setState(EnumQuestState.CONCLUDING);
                } else {
                    this.setState(EnumQuestState.COMPLETE);
                }
            }
        } else if (this.curState == EnumQuestState.CONCLUDING) {
            // empty if block
        }
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof EntityItemPickupEvent) {
            this.pickupEvent((EntityItemPickupEvent)event);
        }
    }

    public void pickupEvent(EntityItemPickupEvent event) {
        if (event.entityPlayer.equals((Object)this.playerQuests.getPlayer()) && CoroUtilItem.getNameByItem(event.item.func_92059_d().func_77973_b()).equals(this.neededItemID)) {
            ++this.curItemCount;
            this.saveAndSync();
            System.out.println("quest item inc");
        }
    }

    @Override
    public void eventComplete() {
        super.eventComplete();
    }

    @Override
    public void load(NBTTagCompound parNBT) {
        super.load(parNBT);
        this.neededItemID = parNBT.func_74779_i("neededItemID");
        this.neededItemCount = parNBT.func_74762_e("neededItemCount");
    }

    @Override
    public void save(NBTTagCompound parNBT) {
        super.save(parNBT);
        parNBT.func_74778_a("neededItemID", this.neededItemID);
        parNBT.func_74768_a("neededItemCount", this.neededItemCount);
    }

    @Override
    public String getTitle() {
        return "Collect Item";
    }

    @Override
    public List<String> getInstructions(List<String> parList) {
        if (parList == null) {
            parList = new ArrayList<String>();
        }
        String itemName = this.neededItemID;
        Item item = CoroUtilItem.getItemByName(this.neededItemID);
        if (item != null) {
            ItemStack is = new ItemStack(item);
            itemName = is.func_82833_r();
        }
        String str = "Collect a total of " + this.neededItemCount + " " + itemName;
        parList.add(str);
        return parList;
    }

    @Override
    public List<String> getInfoProgress(List<String> parList) {
        if (parList == null) {
            parList = new ArrayList<String>();
        }
        String str = this.curItemCount + " of " + this.neededItemCount + " collected";
        parList.add(str);
        return parList;
    }
}

