/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.config.ConfigCoroAI;
import CoroUtil.forge.CoroAI;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import CoroUtil.world.player.DynamicDifficulty;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandlerForge {
    public static HashMap<Integer, ChunkDataEntry> lookupChunkUpdateCount = new HashMap();

    @SubscribeEvent
    public void deathEvent(LivingDeathEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void pickupEvent(EntityItemPickupEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && ((WorldServer)event.world).field_73011_w.field_76574_g == 0) {
            CoroAI.writeOutData(false);
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && ((WorldServer)event.world).field_73011_w.field_76574_g == 0 && WorldDirectorManager.instance().getWorldDirector(CoroAI.modID, event.world) == null) {
            WorldDirectorManager.instance().registerWorldDirector(new WorldDirector(true), CoroAI.modID, event.world);
        }
    }

    @SubscribeEvent
    public void breakBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
        DynamicDifficulty.handleHarvest(event);
    }

    @SubscribeEvent
    public void breakBlockPlayer(BlockEvent.BreakEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void blockPlayerInteract(PlayerInteractEvent event) {
        if (!event.world.field_72995_K) {
            try {
                if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                    return;
                }
                if (ConfigCoroAI.trackPlayerData) {
                    ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(event.world).getChunkData(event.x / 16, event.z / 16);
                    cdp.addToPlayerActivityInteract(event.entityPlayer.func_146103_bH().getId(), 1L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        DynamicDifficulty.logDamage(event);
    }

    @SubscribeEvent
    public void entityKilled(LivingDeathEvent event) {
        DynamicDifficulty.logDeath(event);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderWorldPre(RenderWorldEvent.Pre event) {
        if (ConfigCoroAI.debugChunkRenderUpdates || ConfigCoroAI.debugChunkRenderUpdatesPoll) {
            ChunkCache cache = event.chunkCache;
            int chunkX = (Integer)ObfuscationReflectionHelper.getPrivateValue(ChunkCache.class, (Object)cache, (String[])new String[]{"field_72818_a", "chunkX"});
            int chunkZ = (Integer)ObfuscationReflectionHelper.getPrivateValue(ChunkCache.class, (Object)cache, (String[])new String[]{"field_72816_b", "chunkZ"});
            long time = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            if (ConfigCoroAI.debugChunkRenderUpdates) {
                System.out.println(time + " - render update for chunk: " + chunkX + ", " + chunkZ + " - pos: " + (chunkX * 16 + 8) + ", " + (chunkZ * 16 + 8));
            }
            if (ConfigCoroAI.debugChunkRenderUpdatesPoll) {
                int hash = PathPoint.func_75830_a((int)chunkZ, (int)0, (int)chunkX);
                if (!lookupChunkUpdateCount.containsKey(hash)) {
                    lookupChunkUpdateCount.put(hash, new ChunkDataEntry(chunkX, chunkZ));
                }
                ChunkDataEntry entry = lookupChunkUpdateCount.get(hash);
                ++entry.count;
            }
        }
    }

    static class ChunkDataEntry {
        public int x = 0;
        public int z = 0;
        public int count = 0;
        public int hash = 0;

        public ChunkDataEntry(int x, int z) {
            this.x = x;
            this.z = z;
            this.hash = PathPoint.func_75830_a((int)x, (int)0, (int)z);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

