/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public enum CommandBlockProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        if (accessor.getTileEntity() instanceof TileEntityCommandBlock) {
            String command = accessor.getServerData().func_74779_i("command");
            if (StringUtils.isBlank((CharSequence)command)) {
                return;
            }
            tooltip.text("> " + command);
        }
    }

    @Override
    public void appendServerData(NBTTagCompound data, BlockAccessor accessor) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileEntityCommandBlock) {
            TileEntityCommandBlock commandBlock = (TileEntityCommandBlock)tileEntity;
            if (MinecraftServer.func_71276_C().func_82356_Z() && accessor.getPlayer().func_70003_b(2, "")) {
                String command = commandBlock.func_145993_a().func_145753_i();
                int maxLength = PluginsConfig.vanilla.commandBlock.maxCommandLength;
                if (command.length() > maxLength) {
                    command = command.substring(0, maxLength - 3) + "...";
                }
                data.func_74778_a("command", command);
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.COMMAND_BLOCK;
    }
}

