/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.core;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.MessageType;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.EntityComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.TextStyle;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;

public enum DefaultEntityInfoProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public ResourceLocation getUid() {
        return Identifiers.DEFAULT_ENTITY;
    }

    @Override
    public int getDefaultPriority() {
        return -10000;
    }

    @Override
    public boolean isPriorityFixed() {
        return true;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        ITooltip row = tooltip.horizontal();
        if (PluginsConfig.core.defaultEntity.showEntity) {
            if (!PluginsConfig.core.defaultEntity.fancyRenderer && !(accessor.getEntity() instanceof EntityLiving)) {
                row.child(new HPanelComponent().tag(Identifiers.ENTITY));
            } else {
                row.child(new EntityComponent(accessor.getEntity()).padding(new Padding(6, 0, 10, 0)).size(new Size(12, 12)).tag(Identifiers.ENTITY));
            }
        }
        ITooltip row_vertical = row.vertical();
        if (PluginsConfig.core.defaultEntity.showEntityName) {
            EntityLiving living;
            Entity entity = accessor.getEntity();
            String name = entity instanceof EntityLiving && (living = (EntityLiving)entity).func_94056_bM() && General.customNameOverride ? FormatUtil.formatNameByPixelCount(living.func_94057_bL()) : FormatUtil.formatNameByPixelCount(accessor.getEntity().func_70005_c_());
            row_vertical.child(ThemeHelper.INSTANCE.title(name).tag(Identifiers.ENTITY_NAME));
        }
        if (PluginsConfig.core.defaultEntity.showModName) {
            row_vertical.child(new TextComponent(SpecialChars.ITALIC + ModIdentification.nameFromEntity(accessor.getEntity())).style(new TextStyle().color(General.currentTheme.get().textColor(MessageType.MOD_NAME))).tag(Identifiers.MOD_NAME));
        }
    }
}

