/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.drawable;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.IFilledProgress;
import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.api.ui.style.IProgressStyle;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import com.gtnewhorizons.wdmla.impl.ui.style.ProgressStyle;
import com.gtnewhorizons.wdmla.overlay.GuiDraw;
import com.gtnewhorizons.wdmla.util.Color;
import org.jetbrains.annotations.NotNull;

public class ProgressDrawable
implements IDrawable {
    @NotNull
    private final IFilledProgress progress;
    @NotNull
    private IProgressStyle style;

    public ProgressDrawable(@NotNull IFilledProgress progress) {
        this.progress = progress;
        this.style = new ProgressStyle();
    }

    public ProgressDrawable style(IProgressStyle style) {
        this.style = style;
        return this;
    }

    @Override
    public void draw(IArea area) {
        long current = this.progress.getCurrent();
        long max = this.progress.getMax();
        if (current <= 0L || max <= 0L) {
            return;
        }
        float dx = Math.min((float)current * area.getW() / (float)max, area.getW());
        if (dx > 0.0f) {
            if (this.style.getOverlay() != null) {
                this.style.getOverlay().draw(new Area(area.getX(), area.getY(), dx, area.getH()));
            } else {
                this.fillWithGradient(area, dx);
            }
        }
        if (this.style.getFilledColor() != this.style.getAlternateFilledColor()) {
            int xx = (int)area.getX();
            while ((float)xx <= area.getX() + dx) {
                if ((xx & 1) != 0) {
                    GuiDraw.drawVerticalLine(xx, area.getY(), area.getH(), this.style.getAlternateFilledColor());
                }
                ++xx;
            }
        }
    }

    private void fillWithGradient(IArea area, float dx) {
        int darker = Color.setLightness(this.style.getFilledColor(), 0.7f);
        float half = area.getH() / 2.0f;
        GuiDraw.drawStraightGradientRect(new Area(area.getX(), area.getY(), dx, half), darker, this.style.getFilledColor(), false);
        GuiDraw.drawStraightGradientRect(new Area(area.getX(), area.getY() + half, dx, area.getH() - half), this.style.getFilledColor(), darker, false);
    }
}

