/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.drawable;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.impl.ui.drawable.IconDrawable;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import com.gtnewhorizons.wdmla.overlay.VanillaUIIcons;
import net.minecraft.util.MathHelper;

public class HealthDrawable
implements IDrawable {
    private final int maxHeartsPerLine;
    private final float health;
    private final float maxHealth;
    private final IconDrawable heartBG;
    private final IconDrawable heart;
    private final IconDrawable hHeart;
    private final IconDrawable eHeart;

    public HealthDrawable(int maxHeartsPerLine, float health, float maxHealth) {
        this.maxHeartsPerLine = maxHeartsPerLine;
        this.health = health;
        this.maxHealth = maxHealth;
        this.heartBG = new IconDrawable(VanillaUIIcons.HEART_BG, VanillaUIIcons.PATH);
        this.heart = new IconDrawable(VanillaUIIcons.HEART, VanillaUIIcons.PATH);
        this.hHeart = new IconDrawable(VanillaUIIcons.HHEART, VanillaUIIcons.PATH);
        this.eHeart = new IconDrawable(VanillaUIIcons.EHEART, VanillaUIIcons.PATH);
    }

    @Override
    public void draw(IArea area) {
        int nHearts = MathHelper.func_76123_f((float)this.maxHealth);
        int heartsPerLine = (int)Math.min((double)this.maxHeartsPerLine, Math.ceil(this.maxHealth));
        float offsetX = area.getX();
        float offsetY = area.getY();
        for (int iheart = 1; iheart <= nHearts; ++iheart) {
            if (iheart <= MathHelper.func_76141_d((float)this.health)) {
                this.heartBG.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                this.heart.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                offsetX += 8.0f;
            }
            if ((float)iheart > this.health && (float)iheart <= this.health + 0.5f) {
                this.heartBG.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                this.hHeart.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                offsetX += 8.0f;
            }
            if ((float)iheart > this.health + 0.5f) {
                this.eHeart.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                offsetX += 8.0f;
            }
            if (iheart % heartsPerLine != 0) continue;
            offsetY += 10.0f;
            offsetX = area.getX();
        }
    }
}

