/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.sizer.ISize;
import com.gtnewhorizons.wdmla.impl.ui.component.TooltipComponent;
import com.gtnewhorizons.wdmla.impl.ui.drawable.ArmorDrawable;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ArmorComponent
extends TooltipComponent {
    private static final int DEFAULT_MAX_ARMORS_PER_LINE = 10;

    public ArmorComponent(float armor) {
        this(10, armor, armor);
    }

    public ArmorComponent(float armor, float maxArmor) {
        this(10, armor, maxArmor);
    }

    public ArmorComponent(int maxArmorsPerLine, float armor, float maxArmor) {
        super(new ArrayList<IComponent>(), new Padding(), new Size(0, 0), new ArmorDrawable(maxArmorsPerLine, armor, maxArmor));
        super.size(this.getSize(maxArmorsPerLine, maxArmor));
    }

    public Size getSize(int maxArmorsPerLine, float maxArmor) {
        int armorsPerLine = (int)Math.min((double)maxArmorsPerLine, Math.ceil(maxArmor));
        int nLines = (int)Math.ceil(maxArmor / (float)maxArmorsPerLine);
        return new Size(8 * armorsPerLine, 10 * nLines - 2);
    }

    @Override
    public TooltipComponent size(@NotNull ISize size) {
        throw new IllegalArgumentException("You can't set the size of this component!");
    }
}

