/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.format;

import com.gtnewhorizons.wdmla.api.Ticks;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import net.minecraft.util.StatCollector;

public enum TimeFormattingPattern {
    ALWAYS_TICK(tick -> FormatUtil.STANDARD.format(tick) + StatCollector.func_74838_a((String)"hud.msg.wdmla.ticks")),
    ALWAYS_SECOND(tick -> FormatUtil.STANDARD.format(Duration.of(tick.intValue(), Ticks.INSTANCE).get(ChronoUnit.SECONDS)) + StatCollector.func_74838_a((String)"hud.msg.wdmla.seconds")),
    HOUR_MIN_SEC(tick -> {
        Duration duration = Duration.of(tick.intValue(), Ticks.INSTANCE);
        if (duration.toMinutes() < 1L) {
            return FormatUtil.STANDARD.format(duration.get(ChronoUnit.SECONDS)) + StatCollector.func_74838_a((String)"hud.msg.wdmla.seconds");
        }
        if (duration.toHours() < 1L) {
            return FormatUtil.STANDARD.format(duration.toMinutes()) + StatCollector.func_74838_a((String)"hud.msg.wdmla.minutes") + FormatUtil.TIME_PART.format(duration.minusMinutes(duration.toMinutes()).get(ChronoUnit.SECONDS)) + StatCollector.func_74838_a((String)"hud.msg.wdmla.seconds");
        }
        return FormatUtil.STANDARD.format(duration.toHours()) + StatCollector.func_74838_a((String)"hud.msg.wdmla.hours") + FormatUtil.TIME_PART.format(duration.minusHours(duration.toHours()).toMinutes()) + StatCollector.func_74838_a((String)"hud.msg.wdmla.minutes") + FormatUtil.TIME_PART.format(duration.minusMinutes(duration.toMinutes()).get(ChronoUnit.SECONDS)) + StatCollector.func_74838_a((String)"hud.msg.wdmla.seconds");
    });

    public final Function<Integer, String> tickFormatter;

    private TimeFormattingPattern(Function<Integer, String> tickFormatter) {
        this.tickFormatter = tickFormatter;
    }
}

