/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import com.google.common.base.Preconditions;
import com.gtnewhorizons.wdmla.api.IWDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerExtensionProvider;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.api.view.FluidView;
import com.gtnewhorizons.wdmla.api.view.ProgressView;
import com.gtnewhorizons.wdmla.impl.CommonRegistrationSession;
import com.gtnewhorizons.wdmla.impl.PriorityStore;
import com.gtnewhorizons.wdmla.impl.lookup.HierarchyLookup;
import com.gtnewhorizons.wdmla.impl.lookup.PairHierarchyLookup;
import com.gtnewhorizons.wdmla.impl.lookup.WrappedHierarchyLookup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class WDMlaCommonRegistration
implements IWDMlaCommonRegistration {
    private static final WDMlaCommonRegistration INSTANCE = new WDMlaCommonRegistration();
    public final PairHierarchyLookup<IServerDataProvider<BlockAccessor>> blockDataProviders = new PairHierarchyLookup(new HierarchyLookup(Block.class), new HierarchyLookup(TileEntity.class));
    public final HierarchyLookup<IServerDataProvider<EntityAccessor>> entityDataProviders = new HierarchyLookup(Entity.class);
    public final PriorityStore<ResourceLocation, IWDMlaProvider> priorities = new PriorityStore<ResourceLocation, IWDMlaProvider>(IWDMlaProvider::getDefaultPriority, IWDMlaProvider::getUid);
    public final WrappedHierarchyLookup<IServerExtensionProvider<ItemStack>> itemStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<FluidView.Data>> fluidStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<ProgressView.Data>> progressProviders;
    private CommonRegistrationSession session;

    public static WDMlaCommonRegistration instance() {
        return INSTANCE;
    }

    WDMlaCommonRegistration() {
        this.priorities.setSortingFunction((store, allKeys) -> {
            List keys = allKeys.stream().sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.toCollection(ArrayList::new));
            return keys;
        });
        this.itemStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.fluidStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.progressProviders = WrappedHierarchyLookup.forAccessor();
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<?> blockOrTileEntityClass) {
        if (this.isSessionActive()) {
            this.session.registerBlockDataProvider(dataProvider, blockOrTileEntityClass);
        } else {
            this.blockDataProviders.register(blockOrTileEntityClass, dataProvider);
        }
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends Entity> entityClass) {
        if (this.isSessionActive()) {
            this.session.registerEntityDataProvider(dataProvider, entityClass);
        } else {
            this.entityDataProviders.register(entityClass, dataProvider);
        }
    }

    public List<IServerDataProvider<BlockAccessor>> getBlockNBTProviders(Block block, @Nullable TileEntity tileEntity) {
        if (tileEntity == null) {
            return this.blockDataProviders.first.get(block);
        }
        return this.blockDataProviders.getMerged(block, tileEntity);
    }

    public List<IServerDataProvider<EntityAccessor>> getEntityNBTProviders(Entity entity) {
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.invalidate();
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.invalidate();
        this.entityDataProviders.loadComplete(this.priorities);
        this.itemStorageProviders.invalidate();
        this.itemStorageProviders.loadComplete(this.priorities);
        this.fluidStorageProviders.invalidate();
        this.fluidStorageProviders.loadComplete(this.priorities);
        this.session = null;
    }

    public void startSession() {
        if (this.session == null) {
            this.session = new CommonRegistrationSession(this);
        }
        this.session.reset();
    }

    public void endSession() {
        Preconditions.checkState((this.session != null ? 1 : 0) != 0, (Object)"Session not started");
        this.session.end();
    }

    public boolean isSessionActive() {
        return this.session != null && this.session.isActive();
    }

    @Override
    public <T> void registerItemStorage(IServerExtensionProvider<ItemStack> provider, Class<? extends T> clazz) {
        this.itemStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerFluidStorage(IServerExtensionProvider<FluidView.Data> provider, Class<? extends T> clazz) {
        this.fluidStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerProgress(IServerExtensionProvider<ProgressView.Data> provider, Class<? extends T> clazz) {
        this.progressProviders.register(clazz, provider);
    }
}

