/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gtnewhorizons.wdmla.api.IWDMlaClientRegistration;
import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.accessor.AccessorClientHandler;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessorImpl;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessorImpl;
import com.gtnewhorizons.wdmla.api.provider.HarvestHandler;
import com.gtnewhorizons.wdmla.api.provider.IClientExtensionProvider;
import com.gtnewhorizons.wdmla.api.provider.IComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.api.view.FluidView;
import com.gtnewhorizons.wdmla.api.view.ItemView;
import com.gtnewhorizons.wdmla.api.view.ProgressView;
import com.gtnewhorizons.wdmla.impl.ClientRegistrationSession;
import com.gtnewhorizons.wdmla.impl.ObjectDataCenter;
import com.gtnewhorizons.wdmla.impl.PriorityStore;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.lookup.HierarchyLookup;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.client.KeyEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class WDMlaClientRegistration
implements IWDMlaClientRegistration {
    private static final WDMlaClientRegistration INSTANCE = new WDMlaClientRegistration();
    public final HierarchyLookup<IComponentProvider<BlockAccessor>> blockComponentProviders;
    public final HierarchyLookup<IComponentProvider<EntityAccessor>> entityComponentProviders;
    private final Set<IComponentProvider<?>> allProviders;
    public final Set<Class<? extends Block>> hideBlocks = Sets.newHashSet();
    public final Set<Class<? extends Entity>> hideEntities = Sets.newHashSet();
    public final Map<ResourceLocation, IClientExtensionProvider<ItemStack, ItemView>> itemStorageProviders = Maps.newHashMap();
    public final Map<ResourceLocation, IClientExtensionProvider<FluidView.Data, FluidView>> fluidStorageProviders = Maps.newHashMap();
    public final Map<ResourceLocation, IClientExtensionProvider<ProgressView.Data, ProgressView>> progressProviders = Maps.newHashMap();
    public final HierarchyLookup<HarvestHandler> harvestHandlers;
    public final Map<Class<Accessor>, AccessorClientHandler<Accessor>> accessorHandlers = Maps.newIdentityHashMap();
    private ClientRegistrationSession session;

    WDMlaClientRegistration() {
        this.blockComponentProviders = new HierarchyLookup(Block.class);
        this.entityComponentProviders = new HierarchyLookup(Entity.class);
        this.harvestHandlers = new HierarchyLookup(Block.class);
        this.allProviders = new HashSet();
    }

    public static WDMlaClientRegistration instance() {
        return INSTANCE;
    }

    @Override
    public void registerEntityComponent(IComponentProvider<EntityAccessor> provider, Class<? extends Entity> entityClass) {
        if (this.isSessionActive()) {
            this.session.registerEntityComponent(provider, entityClass);
        } else {
            this.entityComponentProviders.register(entityClass, provider);
            this.allProviders.add(provider);
        }
    }

    @Override
    public void registerBlockComponent(IComponentProvider<BlockAccessor> provider, Class<? extends Block> blockClass) {
        if (this.isSessionActive()) {
            this.session.registerBlockComponent(provider, blockClass);
        } else {
            this.blockComponentProviders.register(blockClass, provider);
            this.allProviders.add(provider);
        }
    }

    public List<IComponentProvider<BlockAccessor>> getBlockProviders(Block block, Predicate<IComponentProvider<? extends Accessor>> filter) {
        return this.blockComponentProviders.get(block).stream().filter(filter).collect(Collectors.toList());
    }

    public List<IComponentProvider<EntityAccessor>> getEntityProviders(Entity entity, Predicate<IComponentProvider<? extends Accessor>> filter) {
        return this.entityComponentProviders.get(entity).stream().filter(filter).collect(Collectors.toList());
    }

    public ImmutableSet<IComponentProvider<?>> getAllProvidersWithoutInfo() {
        return ImmutableSet.copyOf(this.allProviders);
    }

    @Override
    public void hideBlock(Class<? extends Block> block) {
        Objects.requireNonNull(block);
        this.hideBlocks.add(block);
    }

    @Override
    public void hideEntity(Class<? extends Entity> entity) {
        Objects.requireNonNull(entity);
        this.hideEntities.add(entity);
    }

    public List<HarvestHandler> getHarvestHandlers(Block block, Predicate<HarvestHandler> filter) {
        return this.harvestHandlers.get(block).stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public void registerItemStorageClient(IClientExtensionProvider<ItemStack, ItemView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.itemStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerFluidStorageClient(IClientExtensionProvider<FluidView.Data, FluidView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.fluidStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerProgressClient(IClientExtensionProvider<ProgressView.Data, ProgressView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.progressProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerHarvest(HarvestHandler handler, Class<? extends Block> blockClass) {
        Objects.requireNonNull(handler.getUid());
        this.harvestHandlers.register(blockClass, handler);
        WDMlaCommonRegistration.instance().priorities.put(handler);
    }

    @Override
    public boolean isServerConnected() {
        return Waila.instance.serverPresent;
    }

    @Override
    public boolean isShowDetailsPressed() {
        return Keyboard.isKeyDown((int)KeyEvent.key_details.func_151463_i());
    }

    @Override
    public NBTTagCompound getServerData() {
        return ObjectDataCenter.getServerData();
    }

    @Override
    public BlockAccessor.Builder blockAccessor() {
        Minecraft mc = Minecraft.func_71410_x();
        return new BlockAccessorImpl.Builder().level((World)mc.field_71441_e).player((EntityPlayer)mc.field_71439_g).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public EntityAccessor.Builder entityAccessor() {
        Minecraft mc = Minecraft.func_71410_x();
        return new EntityAccessorImpl.Builder().level((World)mc.field_71441_e).player((EntityPlayer)mc.field_71439_g).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public <T extends Accessor> void registerAccessorHandler(Class<T> clazz, AccessorClientHandler<T> handler) {
        this.accessorHandlers.put(clazz, handler);
    }

    public AccessorClientHandler<Accessor> getAccessorHandler(Class<? extends Accessor> clazz) {
        return Objects.requireNonNull(this.accessorHandlers.get(clazz), () -> "No accessor handler for " + clazz);
    }

    public void loadComplete() {
        PriorityStore<ResourceLocation, IWDMlaProvider> priorities = WDMlaCommonRegistration.instance().priorities;
        this.blockComponentProviders.invalidate();
        this.blockComponentProviders.loadComplete(priorities);
        this.entityComponentProviders.invalidate();
        this.entityComponentProviders.loadComplete(priorities);
        this.harvestHandlers.invalidate();
        this.harvestHandlers.loadComplete(priorities);
        this.session = null;
    }

    public void startSession() {
        if (this.session == null) {
            this.session = new ClientRegistrationSession(this);
        }
        this.session.reset();
    }

    public void endSession() {
        Preconditions.checkState((this.session != null ? 1 : 0) != 0, (Object)"Session not started");
        this.session.end();
    }

    public boolean isSessionActive() {
        return this.session != null && this.session.isActive();
    }
}

