/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import akka.japi.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.lookup.IHierarchyLookup;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;

public class CommonRegistrationSession {
    private final WDMlaCommonRegistration registration;
    private boolean active;
    private final List<Pair<IServerDataProvider<BlockAccessor>, Class<?>>> blockDataProviders = Lists.newArrayList();
    private final List<Pair<IServerDataProvider<EntityAccessor>, Class<? extends Entity>>> entityDataProviders = Lists.newArrayList();

    public CommonRegistrationSession(WDMlaCommonRegistration registration) {
        this.registration = registration;
    }

    private static <T extends IWDMlaProvider, C> void register(T provider, List<Pair<T, Class<? extends C>>> list, IHierarchyLookup<T> lookup, Class<? extends C> clazz) {
        Preconditions.checkArgument((boolean)lookup.isClassAcceptable(clazz), (String)"Class %s is not acceptable", (Object[])new Object[]{clazz});
        Objects.requireNonNull(provider.getUid());
        list.add(new Pair(provider, clazz));
    }

    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<?> blockOrBlobkEntityClass) {
        CommonRegistrationSession.register(dataProvider, this.blockDataProviders, this.registration.blockDataProviders, blockOrBlobkEntityClass);
    }

    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends Entity> entityClass) {
        CommonRegistrationSession.register(dataProvider, this.entityDataProviders, this.registration.entityDataProviders, entityClass);
    }

    public void reset() {
        this.blockDataProviders.clear();
        this.entityDataProviders.clear();
        this.active = true;
    }

    public void end() {
        Preconditions.checkState((boolean)this.active, (Object)"Session is not active");
        this.active = false;
        this.blockDataProviders.forEach(pair -> this.registration.registerBlockDataProvider((IServerDataProvider)pair.first(), (Class)pair.second()));
        this.entityDataProviders.forEach(pair -> this.registration.registerEntityDataProvider((IServerDataProvider)pair.first(), (Class)pair.second()));
    }

    public boolean isActive() {
        return this.active;
    }
}

