/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.harvestability;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class HarvestLevel {
    public static final HarvestLevel NO_TOOL = new HarvestLevel(-1);
    protected final int value;

    public HarvestLevel(int level) {
        this.value = level;
    }

    public HarvestLevel(HarvestLevel level) {
        this.value = level.value;
    }

    public boolean isToolRequired() {
        return this.value != -1;
    }

    public String getDisplayNum() {
        return this.isToolRequired() ? String.valueOf(this.value) : null;
    }

    public String getName() {
        String unlocalized = "hud.msg.wdmla.harvestlevel" + (this.value + 1);
        if (StatCollector.func_94522_b((String)unlocalized)) {
            return StatCollector.func_74838_a((String)unlocalized);
        }
        return String.valueOf(this.value);
    }

    public ItemStack getIconFromList(List<ItemStack> iconList) {
        if (iconList == null || iconList.isEmpty()) {
            return null;
        }
        if (iconList.size() <= this.value) {
            return iconList.get(iconList.size() - 1);
        }
        return iconList.get(this.value);
    }

    public boolean doesSatisfy(HarvestLevel otherHarvestLevel) {
        return this.value >= otherHarvestLevel.value;
    }
}

