/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.accessor;

import com.gtnewhorizons.wdmla.api.accessor.AccessorImpl;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.function.Supplier;
import mcp.mobius.waila.network.Message0x03EntRequest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class EntityAccessorImpl
extends AccessorImpl
implements EntityAccessor {
    private final Supplier<Entity> entity;

    public EntityAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.hit, builder.connected, builder.showDetails, builder.serverData);
        this.entity = builder.entity;
    }

    public static void handleRequest(ChannelHandlerContext ctx, NBTTagCompound tag, Message0x03EntRequest msg) {
        WorldServer world = DimensionManager.getWorld((int)msg.dim);
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(msg.id);
        if (entity == null) {
            return;
        }
        EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
        for (IServerDataProvider<EntityAccessor> provider : WDMlaCommonRegistration.instance().getEntityNBTProviders(entity)) {
            try {
                provider.appendServerData(tag, new Builder().level((World)world).player((EntityPlayer)player).entity(entity).build());
            }
            catch (AbstractMethodError | NoSuchMethodError incompatibleClassChangeError) {}
        }
        tag.func_74768_a("EntityId", entity.func_145782_y());
    }

    @Override
    public Entity getEntity() {
        return this.entity.get();
    }

    @Override
    @NotNull
    public Object getTarget() {
        return this.getEntity();
    }

    @Override
    public boolean verifyData(NBTTagCompound data) {
        if (!this.verify) {
            return true;
        }
        if (!data.func_74764_b("EntityId")) {
            return false;
        }
        return data.func_74762_e("EntityId") == this.getEntity().func_145782_y();
    }

    public static class Builder
    implements EntityAccessor.Builder {
        private World level;
        private EntityPlayer player;
        private NBTTagCompound serverData;
        private boolean connected;
        private boolean showDetails;
        private MovingObjectPosition hit;
        private Supplier<Entity> entity;
        private boolean verify;

        @Override
        public EntityAccessor.Builder level(World level) {
            this.level = level;
            return this;
        }

        @Override
        public EntityAccessor.Builder player(EntityPlayer player) {
            this.player = player;
            return this;
        }

        @Override
        public EntityAccessor.Builder serverData(NBTTagCompound serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public EntityAccessor.Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public EntityAccessor.Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public EntityAccessor.Builder hit(MovingObjectPosition hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public EntityAccessor.Builder entity(Supplier<Entity> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public EntityAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public EntityAccessor build() {
            EntityAccessorImpl accessor = new EntityAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }
}

