/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla;

import com.google.common.cache.Cache;
import com.gtnewhorizons.wdmla.WDMla;
import com.gtnewhorizons.wdmla.api.IWDMlaPlugin;
import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IServerExtensionProvider;
import com.gtnewhorizons.wdmla.api.view.FluidView;
import com.gtnewhorizons.wdmla.api.view.ViewGroup;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.config.WDMlaConfig;
import com.gtnewhorizons.wdmla.example.ExamplePlugin;
import com.gtnewhorizons.wdmla.example.TestMode;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.lookup.WrappedHierarchyLookup;
import com.gtnewhorizons.wdmla.plugin.PluginScanner;
import com.gtnewhorizons.wdmla.plugin.universal.ItemCollector;
import com.gtnewhorizons.wdmla.plugin.universal.ItemIterator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        PluginScanner.INSTANCE.scan(event);
    }

    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void postInit(FMLPostInitializationEvent event) {
        WDMlaCommonRegistration common = WDMlaCommonRegistration.instance();
        common.startSession();
        this.registerServerPlugins(common);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            WDMlaClientRegistration client = WDMlaClientRegistration.instance();
            client.startSession();
            this.registerClientPlugins(client);
            client.endSession();
            WDMlaConfig.instance().reloadConfig();
            WDMlaConfig.instance().save();
            OverlayConfig.updateColors();
        }
        common.endSession();
        CommonProxy.loadComplete();
    }

    public static void loadComplete() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            WDMlaCommonRegistration.instance().priorities.sort();
        }
        WDMlaCommonRegistration.instance().loadComplete();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            WDMlaClientRegistration.instance().loadComplete();
        }
    }

    public void serverStarting(FMLServerStartingEvent event) {
    }

    public void registerServerPlugins(WDMlaCommonRegistration registration) {
        for (IWDMlaPlugin plugin : PluginScanner.INSTANCE.results) {
            plugin.register(registration);
        }
        if (WDMla.isDevEnv() && (WDMla.testMode == TestMode.WDMla || WDMla.testMode == TestMode.PACKET)) {
            new ExamplePlugin().register(registration);
        }
    }

    public void registerClientPlugins(WDMlaClientRegistration registration) {
        for (IWDMlaPlugin plugin : PluginScanner.INSTANCE.results) {
            plugin.registerClient(registration);
        }
        if (WDMla.isDevEnv() && (WDMla.testMode == TestMode.WDMla || WDMla.testMode == TestMode.PACKET)) {
            new ExamplePlugin().registerClient(registration);
        }
    }

    public static <T> Map.Entry<ResourceLocation, List<ViewGroup<T>>> getServerExtensionData(Accessor accessor, WrappedHierarchyLookup<IServerExtensionProvider<T>> lookup) {
        for (IServerExtensionProvider<T> provider : lookup.wrappedGet(accessor)) {
            List<ViewGroup<T>> groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider.getClass().getName(), null);
                continue;
            }
            if (groups == null) continue;
            return new AbstractMap.SimpleEntry<ResourceLocation, List<ViewGroup<T>>>(provider.getUid(), groups);
        }
        return null;
    }

    public static ItemCollector<?> createItemCollector(Accessor accessor, Cache<Object, ItemCollector<?>> containerCache) {
        if (accessor.getTarget() instanceof EntityHorse) {
            return new ItemCollector<IInventory>(new ItemIterator.IInventoryItemIterator(o -> {
                Object patt5243$temp = o.getTarget();
                if (patt5243$temp instanceof EntityHorse) {
                    EntityHorse horse = (EntityHorse)patt5243$temp;
                    return horse.field_110296_bG;
                }
                return null;
            }, 0));
        }
        try {
            Object object = accessor.getTarget();
            if (object instanceof IInventory) {
                IInventory container = (IInventory)object;
                return (ItemCollector)containerCache.get((Object)container, () -> new ItemCollector<IInventory>(new ItemIterator.IInventoryItemIterator(0)));
            }
        }
        catch (ExecutionException e) {
            WailaExceptionHandler.handleErr(e, accessor.getTarget().getClass().getName(), null);
        }
        return ItemCollector.EMPTY;
    }

    public static List<ViewGroup<FluidView.Data>> wrapFluidStorage(Accessor accessor) {
        IFluidHandler fluidHandler;
        FluidTankInfo[] tankInfo;
        BlockAccessor blockAccessor;
        TileEntity tileEntity;
        if (accessor instanceof BlockAccessor && (tileEntity = (blockAccessor = (BlockAccessor)accessor).getTileEntity()) instanceof IFluidHandler && (tankInfo = (fluidHandler = (IFluidHandler)tileEntity).getTankInfo(ForgeDirection.UNKNOWN)) != null) {
            return CommonProxy.fromFluidStorage(tankInfo);
        }
        return null;
    }

    public static List<ViewGroup<FluidView.Data>> fromFluidStorage(FluidTankInfo[] storage) {
        HashMap<FluidStack, Long> map = new HashMap<FluidStack, Long>();
        int emptyTanks = 0;
        for (FluidTankInfo fluidTankInfo : storage) {
            if (fluidTankInfo.fluid == null) {
                ++emptyTanks;
            }
            map.put(fluidTankInfo.fluid, Long.valueOf(fluidTankInfo.capacity));
            if (map.size() >= PluginsConfig.universal.fluidStorage.normalAmount) break;
        }
        if (storage.length == 0) {
            return new ArrayList<ViewGroup<FluidView.Data>>();
        }
        int remaining = storage.length - emptyTanks - map.size();
        ViewGroup group = new ViewGroup(map.entrySet().stream().map(entry -> new FluidView.Data((FluidStack)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList()));
        if (remaining > 0) {
            group.getExtraData().func_74768_a("+", remaining);
        }
        return Arrays.asList(group);
    }
}

