/*
 * Decompiled with CFR 0.152.
 */
package mca.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mca.core.MCA;
import mca.enums.EnumInteraction;
import mca.enums.EnumMoodGroup;

public enum EnumPersonality {
    NONE(0, EnumMoodGroup.ALL),
    ATHLETIC(1, EnumMoodGroup.PLAYFUL),
    CONFIDENT(2, EnumMoodGroup.SERIOUS),
    STRONG(3, EnumMoodGroup.SERIOUS),
    FRIENDLY(4, EnumMoodGroup.GENERAL),
    CURIOUS(21, EnumMoodGroup.SERIOUS),
    PEACEFUL(22, EnumMoodGroup.GENERAL),
    FLIRTY(23, EnumMoodGroup.PLAYFUL),
    WITTY(24, EnumMoodGroup.PLAYFUL),
    SENSITIVE(41, EnumMoodGroup.GENERAL),
    GREEDY(42, EnumMoodGroup.SERIOUS),
    STUBBORN(43, EnumMoodGroup.SERIOUS),
    ODD(44, EnumMoodGroup.PLAYFUL);

    private int id;
    private EnumMoodGroup moodGroup;

    private EnumPersonality(int id, EnumMoodGroup moodGroup) {
        this.id = id;
        this.moodGroup = moodGroup;
    }

    public int getId() {
        return this.id;
    }

    public EnumMoodGroup getMoodGroup() {
        return this.moodGroup;
    }

    public static EnumPersonality getById(int id) {
        for (EnumPersonality personality : EnumPersonality.values()) {
            if (personality.id != id) continue;
            return personality;
        }
        return NONE;
    }

    public static EnumPersonality getAtRandom() {
        ArrayList<EnumPersonality> validList = new ArrayList<EnumPersonality>();
        for (EnumPersonality personality : EnumPersonality.values()) {
            if (personality.id == 0) continue;
            validList.add(personality);
        }
        return (EnumPersonality)((Object)validList.get(new Random().nextInt(validList.size())));
    }

    public static List<Integer> getListOfIds() {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (EnumPersonality personality : EnumPersonality.values()) {
            returnList.add(personality.id);
        }
        return returnList;
    }

    public String getFriendlyName() {
        String name = "personality." + this.name().toLowerCase();
        return MCA.getLanguageManager().getString(name);
    }

    public int getSuccessModifierForInteraction(EnumInteraction interaction) {
        switch (interaction) {
            case CHAT: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 15 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 5 : 0));
            }
            case JOKE: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 15 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -5 : 0));
            }
            case SHAKE_HAND: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 15 : 0));
            }
            case TELL_STORY: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 10 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 10 : 0));
            }
            case FLIRT: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 10 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -5 : 0));
            }
            case HUG: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 10 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -5 : 0));
            }
            case KISS: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 10 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -5 : 0));
            }
        }
        return 0;
    }

    public int getHeartsModifierForInteraction(EnumInteraction interaction) {
        switch (interaction) {
            case CHAT: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 1 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 2 : 0));
            }
            case JOKE: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 3 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -1 : 0));
            }
            case SHAKE_HAND: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? -1 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 2 : 0));
            }
            case TELL_STORY: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? -2 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 4 : 0));
            }
            case FLIRT: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 1 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -1 : 0));
            }
            case HUG: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 1 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -1 : 0));
            }
            case KISS: {
                return this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 2 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -2 : 0));
            }
        }
        return 0;
    }
}

