/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.enums.EnumInteraction;
import mca.packets.PacketInteractWithPlayerS;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import radixcore.client.render.RenderHelper;

@SideOnly(value=Side.CLIENT)
public class GuiPlayerMenu
extends GuiScreen {
    private final EntityPlayer player;
    private final EntityPlayer playerTarget;
    private final NBTPlayerData playerData;
    private boolean targetIsMarried;
    private boolean targetIsEngaged;
    private boolean isMarriedToInitiator;
    private String targetSpouseName;
    private boolean displayMarriageInfo;

    public GuiPlayerMenu(EntityPlayer player, EntityPlayer target, boolean targetIsMarried, boolean targetIsEngaged, boolean isMarriedToInitiator, String targetSpouseName) {
        this.player = player;
        this.playerData = MCA.getPlayerData(player);
        this.playerTarget = target;
        this.targetIsMarried = targetIsMarried;
        this.targetIsEngaged = targetIsEngaged;
        this.isMarriedToInitiator = isMarriedToInitiator;
        this.targetSpouseName = targetSpouseName;
    }

    public void func_73866_w_() {
        this.drawMainButtonMenu();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int i, int j, float f) {
        int marriageIconU = this.targetIsMarried ? 0 : (this.targetIsEngaged ? 64 : 16);
        GL11.glPushMatrix();
        GL11.glColor3f((float)255.0f, (float)255.0f, (float)255.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        RenderHelper.drawTexturedRectangle((ResourceLocation)new ResourceLocation("mca:textures/gui.png"), (int)5, (int)30, (int)marriageIconU, (int)0, (int)16, (int)16);
        GL11.glPopMatrix();
        if (this.displayMarriageInfo) {
            String phraseId = this.isMarriedToInitiator ? "gui.info.family.marriedtoplayer" : (this.targetIsMarried ? "gui.info.family.married" : (this.targetIsEngaged ? "gui.info.family.engaged" : "gui.info.family.notmarried"));
            RenderHelper.drawTextPopup((String)MCA.getLanguageManager().getString(phraseId, new Object[]{this.targetSpouseName}), (int)49, (int)73);
        }
        super.func_73863_a(i, j, f);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.displayMarriageInfo = x <= 38 && x >= 16 && y <= 86 && y >= 69;
    }

    protected void func_73864_a(int posX, int posY, int button) {
        super.func_73864_a(posX, posY, button);
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        if (keyCode == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    protected void func_146284_a(GuiButton button) {
        EnumInteraction interaction = EnumInteraction.fromId(button.field_146127_k);
        if (interaction != null) {
            MCA.getPacketHandler().sendPacketToServer(new PacketInteractWithPlayerS(interaction.getId(), this.playerTarget.func_145782_y()));
        }
        Minecraft.func_71410_x().func_147108_a(null);
    }

    private void drawMainButtonMenu() {
        int xLoc;
        this.field_146292_n.clear();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        if (this.isMarriedToInitiator) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.DIVORCE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLanguageManager().getString("gui.button.divorce")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.HAVEBABY.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLanguageManager().getString("gui.button.havebaby")));
            yLoc -= yInt;
        } else {
            this.field_146292_n.add(new GuiButton(EnumInteraction.ASKTOMARRY.getId(), this.field_146294_l / 2 + xLoc - 10, this.field_146295_m / 2 - yLoc, 75, 20, MCA.getLanguageManager().getString("gui.button.asktomarry")));
            yLoc -= yInt;
        }
    }

    private void close() {
        Minecraft.func_71410_x().func_147108_a(null);
    }
}

