/*
 * Decompiled with CFR 0.152.
 */
package mca.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mca.api.CookableFood;
import mca.api.CropEntry;
import mca.api.FishingEntry;
import mca.api.MiningEntry;
import mca.api.WeddingGift;
import mca.api.WoodcuttingEntry;
import mca.api.enums.EnumGiftCategory;
import mca.api.exception.MappingNotFoundException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import radixcore.util.RadixMath;

public final class RegistryMCA {
    public static final Random rand = new Random();
    private static final Map<Object, Integer> giftMap = new HashMap<Object, Integer>();
    private static final Map<Integer, MiningEntry> miningEntryMap = new HashMap<Integer, MiningEntry>();
    private static final Map<Integer, WoodcuttingEntry> woodcuttingBlockMap = new HashMap<Integer, WoodcuttingEntry>();
    private static final Map<Integer, CropEntry> cropEntryMap = new HashMap<Integer, CropEntry>();
    private static final Map<Integer, FishingEntry> fishingEntryMap = new HashMap<Integer, FishingEntry>();
    private static final List<Class> huntingKillableEntities = new ArrayList<Class>();
    private static final List<Class> huntingTameableEntities = new ArrayList<Class>();
    private static final List<CookableFood> cookableFood = new ArrayList<CookableFood>();
    private static final List<WeddingGift> villagerGiftsBad = new ArrayList<WeddingGift>();
    private static final List<WeddingGift> villagerGiftsGood = new ArrayList<WeddingGift>();
    private static final List<WeddingGift> villagerGiftsBetter = new ArrayList<WeddingGift>();
    private static final List<WeddingGift> villagerGiftsBest = new ArrayList<WeddingGift>();

    public static void addObjectAsGift(Object blockOrItem, int giftValue) {
        if (!(blockOrItem instanceof Block) && !(blockOrItem instanceof Item)) {
            throw new IllegalArgumentException("Provided gift object was not a block or an item.");
        }
        giftMap.put(blockOrItem, giftValue);
    }

    public static void addFishingEntryToFishingAI(int id, FishingEntry entry) {
        RegistryMCA.putIfNotDuplicate(fishingEntryMap, id, entry);
    }

    public static void addCropToFarmingAI(int id, CropEntry entry) {
        RegistryMCA.putIfNotDuplicate(cropEntryMap, id, entry);
    }

    public static void addBlockToWoodcuttingAI(int id, WoodcuttingEntry entry) {
        RegistryMCA.putIfNotDuplicate(woodcuttingBlockMap, id, entry);
    }

    public static void addBlockToMiningAI(int id, MiningEntry entry) {
        RegistryMCA.putIfNotDuplicate(miningEntryMap, id, entry);
    }

    public static void addEntityToHuntingAI(Class clazz) {
        RegistryMCA.addEntityToHuntingAI(clazz, true);
        RegistryMCA.addEntityToHuntingAI(clazz, false);
    }

    public static void addEntityToHuntingAI(Class clazz, boolean isKillable) {
        if (isKillable) {
            huntingKillableEntities.add(clazz);
        } else {
            huntingTameableEntities.add(clazz);
        }
    }

    public static void addFoodToCookingAI(CookableFood foodObj) {
        cookableFood.add(foodObj);
    }

    public static Class getRandomHuntingEntity(boolean shouldBeTameable) {
        if (shouldBeTameable) {
            int index = new Random().nextInt(huntingTameableEntities.size());
            return huntingTameableEntities.get(index);
        }
        int index = new Random().nextInt(huntingKillableEntities.size());
        return huntingKillableEntities.get(index);
    }

    public static MiningEntry getMiningEntryById(int id) throws MappingNotFoundException {
        MiningEntry entry = miningEntryMap.get(id);
        if (entry != null) {
            return entry;
        }
        throw new MappingNotFoundException();
    }

    public static Integer getIdOfMiningEntryContainingBlock(Block block) throws MappingNotFoundException {
        for (Map.Entry<Integer, MiningEntry> entry : miningEntryMap.entrySet()) {
            MiningEntry theEntry = entry.getValue();
            if (!theEntry.getBlock().equals(block)) continue;
            return entry.getKey();
        }
        throw new MappingNotFoundException();
    }

    public static WoodcuttingEntry getWoodcuttingEntryById(int id) throws MappingNotFoundException {
        WoodcuttingEntry entry = woodcuttingBlockMap.get(id);
        if (entry != null) {
            return entry;
        }
        throw new MappingNotFoundException();
    }

    public static WoodcuttingEntry getDefaultWoodcuttingEntry() {
        return woodcuttingBlockMap.get(1);
    }

    public static CropEntry getDefaultCropEntry() {
        return cropEntryMap.get(1);
    }

    public static Map<Object, Integer> getGiftMap() {
        return Collections.unmodifiableMap(giftMap);
    }

    public static List<CookableFood> getCookableFoodList() {
        return Collections.unmodifiableList(cookableFood);
    }

    public static Map<Integer, MiningEntry> getMiningEntryMap() {
        return Collections.unmodifiableMap(miningEntryMap);
    }

    public static List<Integer> getWoodcuttingBlockIDs() {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (Map.Entry<Integer, WoodcuttingEntry> entry : woodcuttingBlockMap.entrySet()) {
            returnList.add(entry.getKey());
        }
        return Collections.unmodifiableList(returnList);
    }

    public static List<Integer> getMiningEntryIDs() {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (Map.Entry<Integer, MiningEntry> entry : miningEntryMap.entrySet()) {
            returnList.add(entry.getKey());
        }
        return Collections.unmodifiableList(returnList);
    }

    public static CropEntry getCropEntryById(int id) throws MappingNotFoundException {
        CropEntry entry = cropEntryMap.get(id);
        if (entry != null) {
            return entry;
        }
        throw new MappingNotFoundException();
    }

    public static List<Integer> getCropEntryIDs() {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (Map.Entry<Integer, CropEntry> entry : cropEntryMap.entrySet()) {
            returnList.add(entry.getKey());
        }
        return returnList;
    }

    public static FishingEntry getRandomFishingEntry() {
        return fishingEntryMap.get(RadixMath.getNumberInRange((int)0, (int)(fishingEntryMap.size() - 1)));
    }

    public static FishingEntry getFishingEntryById(int id) throws MappingNotFoundException {
        FishingEntry entry = fishingEntryMap.get(id);
        if (entry != null) {
            return entry;
        }
        throw new MappingNotFoundException();
    }

    public static List<Integer> getFishingEntryIDs() {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (Map.Entry<Integer, CropEntry> entry : cropEntryMap.entrySet()) {
            returnList.add(entry.getKey());
        }
        return returnList;
    }

    public static void addWeddingGift(WeddingGift gift, EnumGiftCategory category) {
        switch (category) {
            case BAD: {
                villagerGiftsBad.add(gift);
                break;
            }
            case BEST: {
                villagerGiftsBest.add(gift);
                break;
            }
            case BETTER: {
                villagerGiftsBetter.add(gift);
                break;
            }
            case GOOD: {
                villagerGiftsGood.add(gift);
                break;
            }
        }
    }

    public static ItemStack getGiftStackFromRelationship(int heartsLevel) {
        List<WeddingGift> giftList = null;
        giftList = heartsLevel < 0 ? villagerGiftsBad : (heartsLevel >= 0 && heartsLevel <= 25 ? villagerGiftsGood : (heartsLevel > 25 && heartsLevel <= 50 ? villagerGiftsBetter : villagerGiftsBest));
        Random rand = new Random();
        WeddingGift giftEntry = giftList.get(rand.nextInt(giftList.size()));
        return new ItemStack(giftEntry.getItem(), rand.nextInt(giftEntry.getMaximum() - giftEntry.getMinimum() + 1) + giftEntry.getMinimum());
    }

    private static <K, V> void putIfNotDuplicate(Map<K, V> map, K key, V value) {
        if (map.containsKey(key)) {
            throw new IllegalArgumentException("Key is already contained in map for key/value pair: key = " + key + ", value = " + value);
        }
        if (map.containsValue(value)) {
            throw new IllegalArgumentException("Value is already contained in map for key/value pair: key = " + key + ", value = " + value);
        }
        map.put(key, value);
    }

    private static <K, V> K reverseLookupKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }

    private RegistryMCA() {
    }
}

