/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.List;
import mca.ai.AbstractToggleAI;
import mca.api.RegistryMCA;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.enums.EnumMovementState;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import radixcore.data.WatchedBoolean;
import radixcore.math.Point3D;
import radixcore.util.RadixExcept;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIHunting
extends AbstractToggleAI {
    private WatchedBoolean isAIActive;
    private Point3D standPoint;
    private boolean isTaming;
    private int ticksActive;

    public AIHunting(EntityHuman owner) {
        super(owner);
        this.isAIActive = new WatchedBoolean(false, 24, owner.getDataWatcherEx());
        this.standPoint = Point3D.ZERO;
    }

    @Override
    public void setIsActive(boolean value) {
        this.isAIActive.setValue((Object)value);
    }

    @Override
    public boolean getIsActive() {
        return this.isAIActive.getBoolean();
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (!MCA.getConfig().allowHuntingChore) {
            this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
            this.reset();
            return;
        }
        if (this.standPoint.iPosX == 0 && this.standPoint.iPosY == 0 && this.standPoint.iPosZ == 0) {
            List grassBlocks = RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_150349_c, (int)15);
            if (grassBlocks.size() > 0) {
                this.standPoint = (Point3D)grassBlocks.get(RadixMath.getNumberInRange((int)0, (int)(grassBlocks.size() - 1)));
            } else {
                this.owner.say("hunting.badspot", this.getAssigningPlayer());
                this.reset();
            }
            return;
        }
        if (RadixMath.getDistanceToXYZ((Entity)this.owner, (Point3D)this.standPoint) >= 5.0 && this.owner.func_70661_as().func_75500_f()) {
            boolean successful = this.owner.func_70661_as().func_75492_a(this.standPoint.dPosX, this.standPoint.dPosY, this.standPoint.dPosZ, (double)this.owner.getSpeed());
            if (!successful) {
                this.owner.say("hunting.badspot", this.getAssigningPlayer());
                this.reset();
            }
        } else if (RadixMath.getDistanceToXYZ((Entity)this.owner, (Point3D)this.standPoint) < 5.0) {
            ++this.ticksActive;
            if (this.ticksActive >= 400) {
                List nearbyItems;
                boolean doSpawn = this.owner.field_70170_p.field_73012_v.nextBoolean();
                if (doSpawn) {
                    try {
                        Class entityClass = RegistryMCA.getRandomHuntingEntity(this.isTaming);
                        EntityLiving entity = (EntityLiving)entityClass.getDeclaredConstructor(World.class).newInstance(this.owner.field_70170_p);
                        List nearbyGrass = RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_150349_c, (int)3);
                        Point3D spawnPoint = (Point3D)nearbyGrass.get(this.owner.field_70170_p.field_73012_v.nextInt(nearbyGrass.size()));
                        if (spawnPoint != null) {
                            entity.func_70107_b((double)spawnPoint.iPosX, (double)(spawnPoint.iPosY + 1), (double)spawnPoint.iPosZ);
                        }
                        this.owner.field_70170_p.func_72838_d((Entity)entity);
                        if (!this.isTaming) {
                            entity.func_70097_a(DamageSource.field_76377_j, 100.0f);
                            this.owner.func_71038_i();
                        }
                    }
                    catch (Exception e) {
                        RadixExcept.logErrorCatch((Throwable)e, (String)"There was an error spawning an entity for the hunting AI. If you are using a mod that expands MCA's hunting AI, it is likely the problem!");
                    }
                }
                if ((nearbyItems = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityItem.class, (Entity)this.owner, (int)5)).size() != 0) {
                    for (Entity entity : nearbyItems) {
                        EntityItem item = (EntityItem)entity;
                        ItemStack stack = item.func_92059_d();
                        this.addItemStackToInventory(stack);
                        item.func_70106_y();
                    }
                }
                this.ticksActive = 0;
            }
        }
    }

    @Override
    public void reset() {
        this.setIsActive(false);
        this.ticksActive = 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isHuntingActive", this.isAIActive.getBoolean().booleanValue());
        nbt.func_74757_a("isTaming", this.isTaming);
        this.standPoint.writeToNBT("standPoint", nbt);
        nbt.func_74768_a("ticksActive", this.ticksActive);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.isAIActive.setValue((Object)nbt.func_74767_n("isHuntingActive"));
        this.isTaming = nbt.func_74767_n("isTaming");
        this.standPoint = Point3D.readFromNBT((String)"standPoint", (NBTTagCompound)nbt);
        this.ticksActive = nbt.func_74762_e("ticksActive");
    }

    public void startTaming(EntityPlayer player) {
        this.assigningPlayer = player.func_110124_au().toString();
        this.standPoint = Point3D.ZERO;
        this.isTaming = true;
        this.setIsActive(true);
        this.owner.setMovementState(EnumMovementState.MOVE);
    }

    public void startKilling(EntityPlayer player) {
        this.assigningPlayer = player.func_110124_au().toString();
        this.standPoint = Point3D.ZERO;
        this.isTaming = false;
        this.setIsActive(true);
        this.owner.setMovementState(EnumMovementState.MOVE);
    }

    @Override
    protected String getName() {
        return "Hunting";
    }
}

