/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.turboasm;

import com.falsepattern.lib.turboasm.FastClassAccessor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ConstantPoolEntryTypes.class, Offsets.class})
public final class ClassHeaderMetadata
implements FastClassAccessor {
    public final int minorVersion;
    public final int majorVersion;
    public final int constantPoolEntryCount;
    public final int @NotNull [] constantPoolEntryOffsets;
    public final ConstantPoolEntryTypes @NotNull [] constantPoolEntryTypes;
    public final int constantPoolEndOffset;
    public final int accessFlags;
    public final int thisClassIndex;
    public final int superClassIndex;
    public final int interfacesCount;
    @NotNull
    public final String binaryThisName;
    @Nullable
    public final String binarySuperName;

    public ClassHeaderMetadata(byte @NotNull [] bytes) {
        int cpOff;
        if (!ClassHeaderMetadata.isValidClass(bytes)) {
            throw new IllegalArgumentException("Invalid class detected");
        }
        this.minorVersion = ClassHeaderMetadata.u16(bytes, 4);
        this.majorVersion = ClassHeaderMetadata.u16(bytes, 6);
        this.constantPoolEntryCount = ClassHeaderMetadata.u16(bytes, 8);
        this.constantPoolEntryOffsets = new int[this.constantPoolEntryCount];
        this.constantPoolEntryTypes = new ConstantPoolEntryTypes[this.constantPoolEntryCount];
        int off = 10;
        for (int entry = 0; entry < this.constantPoolEntryCount - 1; ++entry) {
            ConstantPoolEntryTypes type;
            this.constantPoolEntryOffsets[entry] = off;
            this.constantPoolEntryTypes[entry] = type = ConstantPoolEntryTypes.parse(bytes, off);
            if (type == ConstantPoolEntryTypes.Double || type == ConstantPoolEntryTypes.Long) {
                this.constantPoolEntryOffsets[++entry] = off;
                this.constantPoolEntryTypes[entry] = type;
            }
            off += type.byteLength(bytes, off);
        }
        this.constantPoolEndOffset = cpOff = off;
        this.accessFlags = ClassHeaderMetadata.u16(bytes, cpOff + 0);
        this.thisClassIndex = ClassHeaderMetadata.u16(bytes, cpOff + 2);
        this.superClassIndex = ClassHeaderMetadata.u16(bytes, cpOff + 4);
        this.interfacesCount = ClassHeaderMetadata.u16(bytes, cpOff + 6);
        if (this.constantPoolEntryTypes[this.thisClassIndex - 1] != ConstantPoolEntryTypes.Class) {
            throw new IllegalArgumentException("This class index is not a class ref");
        }
        int thisNameIndex = ClassHeaderMetadata.u16(bytes, this.constantPoolEntryOffsets[this.thisClassIndex - 1] + 1);
        if (this.constantPoolEntryTypes[thisNameIndex - 1] != ConstantPoolEntryTypes.Utf8) {
            throw new IllegalArgumentException("This class index does not point to a UTF8 entry");
        }
        this.binaryThisName = ClassHeaderMetadata.modifiedUtf8(bytes, this.constantPoolEntryOffsets[thisNameIndex - 1] + 1);
        if (this.superClassIndex == 0) {
            this.binarySuperName = null;
        } else {
            int superNameIndex = ClassHeaderMetadata.u16(bytes, this.constantPoolEntryOffsets[this.superClassIndex - 1] + 1);
            if (this.constantPoolEntryTypes[this.superClassIndex - 1] != ConstantPoolEntryTypes.Class) {
                throw new IllegalArgumentException("Super class index is not a class ref");
            }
            if (this.constantPoolEntryTypes[superNameIndex - 1] != ConstantPoolEntryTypes.Utf8) {
                throw new IllegalArgumentException("Super class index does not point to a UTF8 entry");
            }
            this.binarySuperName = ClassHeaderMetadata.modifiedUtf8(bytes, this.constantPoolEntryOffsets[superNameIndex - 1] + 1);
        }
    }

    public static int u8(byte @NotNull [] arr, int off) {
        return arr[off] & 0xFF;
    }

    public static int u16(byte @NotNull [] arr, int off) {
        return ClassHeaderMetadata.u8(arr, off) << 8 | ClassHeaderMetadata.u8(arr, off + 1);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String modifiedUtf8(byte @NotNull [] arr, int off) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(arr, off, arr.length - off);){
            String string;
            try (DataInputStream dis = new DataInputStream(bais);){
                string = dis.readUTF();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value="null -> false")
    public static boolean isValidClass(byte @Nullable [] classBytes) {
        if (classBytes == null) {
            return false;
        }
        if (classBytes.length < 14) {
            return false;
        }
        int magic = ClassHeaderMetadata.u8(classBytes, 0) << 24 | ClassHeaderMetadata.u8(classBytes, 1) << 16 | ClassHeaderMetadata.u8(classBytes, 2) << 8 | ClassHeaderMetadata.u8(classBytes, 3);
        return magic == -889275714;
    }

    public static int majorVersion(byte @NotNull [] classBytes) {
        return ClassHeaderMetadata.u16(classBytes, 6);
    }

    public static boolean hasSubstring(byte @Nullable [] classBytes, byte @NotNull [] substring) {
        if (classBytes == null) {
            return false;
        }
        int classLen = classBytes.length;
        int subLen = substring.length;
        if (classLen < subLen) {
            return false;
        }
        int startPos = 0;
        while (startPos + subLen - 1 < classLen) {
            block5: {
                for (int i = 0; i < subLen; ++i) {
                    if (classBytes[startPos + i] == substring[i]) {
                        continue;
                    }
                    break block5;
                }
                return true;
            }
            ++startPos;
        }
        return false;
    }

    @Override
    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    @Override
    @NotNull
    public String binaryThisName() {
        return this.binaryThisName;
    }

    @Override
    @Nullable
    public String binarySuperName() {
        return this.binarySuperName;
    }

    @NestHost(value=ClassHeaderMetadata.class)
    public static final class Offsets {
        public static final int magicU32 = 0;
        public static final int minorVersionU16 = 4;
        public static final int majorVersionU16 = 6;
        public static final int constantPoolCountU16 = 8;
        public static final int constantPoolStart = 10;
        public static final int pastCpAccessFlagsU16 = 0;
        public static final int pastCpThisClassU16 = 2;
        public static final int pastCpSuperClassU16 = 4;
        public static final int pastCpInterfacesCountU16 = 6;

        private Offsets() {
        }
    }

    @NestHost(value=ClassHeaderMetadata.class)
    public static enum ConstantPoolEntryTypes {
        Utf8(1, 45, -1),
        Integer(3, 45, 4),
        Float(4, 45, 4),
        Long(5, 45, 8),
        Double(6, 45, 8),
        Class(7, 49, 2),
        String(8, 45, 2),
        FieldRef(9, 45, 4),
        MethodRef(10, 45, 4),
        InterfaceMethodRef(11, 45, 4),
        NameAndType(12, 45, 4),
        MethodHandle(15, 51, 3),
        MethodType(16, 51, 2),
        Dynamic(17, 55, 4),
        InvokeDynamic(18, 51, 4),
        Module(19, 53, 2),
        Package(20, 53, 2);

        private static final ConstantPoolEntryTypes[] lookup;
        public final int tag;
        public final int minMajorVersion;
        public final int maybeByteLength;

        private ConstantPoolEntryTypes(int tag, int minMajorVersion, int maybeByteLength) {
            this.tag = tag;
            this.minMajorVersion = minMajorVersion;
            this.maybeByteLength = maybeByteLength;
        }

        public int byteLength(byte @NotNull [] classFile, int offset) {
            if (this == Utf8) {
                return 3 + ClassHeaderMetadata.u16(classFile, offset + 1);
            }
            if (this.maybeByteLength < 0) {
                throw new UnsupportedOperationException(ConstantPoolEntryTypes.jvmdowngrader$concat$byteLength$1(java.lang.String.valueOf((Object)this)));
            }
            return 1 + this.maybeByteLength;
        }

        @NotNull
        public static ConstantPoolEntryTypes parse(byte @NotNull [] classFile, int offset) {
            ConstantPoolEntryTypes type;
            int tag = ClassHeaderMetadata.u8(classFile, offset);
            ConstantPoolEntryTypes constantPoolEntryTypes = type = tag >= lookup.length ? null : lookup[tag];
            if (type == null) {
                throw new UnsupportedOperationException(ConstantPoolEntryTypes.jvmdowngrader$concat$parse$1(tag));
            }
            return type;
        }

        static {
            ConstantPoolEntryTypes[] values = ConstantPoolEntryTypes.values();
            int maxTag = values[values.length - 1].tag;
            ConstantPoolEntryTypes[] lut = new ConstantPoolEntryTypes[maxTag + 1];
            ConstantPoolEntryTypes[] constantPoolEntryTypesArray = values;
            int n = constantPoolEntryTypesArray.length;
            for (int i = 0; i < n; ++i) {
                ConstantPoolEntryTypes entry;
                lut[entry.tag] = entry = constantPoolEntryTypesArray[i];
            }
            lookup = lut;
        }

        private static /* synthetic */ String jvmdowngrader$concat$byteLength$1(String string) {
            return "Missing byte length implementation for tag " + string;
        }

        private static /* synthetic */ String jvmdowngrader$concat$parse$1(int n) {
            return "Unknown constant pool tag " + n;
        }
    }
}

