/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.dependencies;

import com.falsepattern.deploader.Library;
import com.falsepattern.deploader.version.ComplexVersion;
import com.falsepattern.deploader.version.Version;
import com.falsepattern.lib.dependencies.SemanticVersion;
import com.falsepattern.lib.internal.impl.dependencies.RawVersion;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class DependencyLoaderImpl {
    public static void addMavenRepo(String url) {
        com.falsepattern.deploader.DependencyLoaderImpl.addMavenRepo((String)url);
    }

    public static CompletableFuture<Void> loadLibrariesAsync(com.falsepattern.lib.dependencies.Library ... libraries) {
        Library[] libs = new Library[libraries.length];
        for (int i = 0; i < libraries.length; ++i) {
            libs[i] = DependencyLoaderImpl.adaptLibrary(libraries[i]);
        }
        return com.falsepattern.deploader.DependencyLoaderImpl.loadLibrariesAsync((Library[])libs);
    }

    public static void loadLibraries(com.falsepattern.lib.dependencies.Library ... libraries) {
        Library[] libs = new Library[libraries.length];
        for (int i = 0; i < libraries.length; ++i) {
            libs[i] = DependencyLoaderImpl.adaptLibrary(libraries[i]);
        }
        com.falsepattern.deploader.DependencyLoaderImpl.loadLibraries((Library[])libs);
    }

    public static com.falsepattern.lib.dependencies.Version parseVersion(String versionString) {
        Version realVersion = com.falsepattern.deploader.DependencyLoaderImpl.parseVersion((String)versionString);
        return DependencyLoaderImpl.adaptVersion(realVersion);
    }

    @Nullable
    private static com.falsepattern.lib.dependencies.Version adaptVersion(@Nullable Version version) {
        if (version == null) {
            return null;
        }
        if (version instanceof com.falsepattern.deploader.version.RawVersion) {
            com.falsepattern.deploader.version.RawVersion raw = (com.falsepattern.deploader.version.RawVersion)version;
            return new RawVersion(raw.versionString);
        }
        if (version instanceof com.falsepattern.deploader.version.SemanticVersion) {
            com.falsepattern.deploader.version.SemanticVersion sem = (com.falsepattern.deploader.version.SemanticVersion)version;
            return new SemanticVersion(sem.getMajorVersion(), sem.getMinorVersion(), sem.getPatchVersion(), sem.getPreRelease(), sem.getBuild());
        }
        if (version instanceof ComplexVersion) {
            ComplexVersion cplx = (ComplexVersion)version;
            Version[] versA = cplx.versions;
            com.falsepattern.lib.dependencies.Version[] vers = new com.falsepattern.lib.dependencies.Version[versA.length];
            for (int i = 0; i < versA.length; ++i) {
                vers[i] = DependencyLoaderImpl.adaptVersion(versA[i]);
            }
            return new com.falsepattern.lib.dependencies.ComplexVersion(vers);
        }
        throw new IllegalStateException(DependencyLoaderImpl.jvmdowngrader$concat$adaptVersion$1(version.getClass().getName()));
    }

    @Contract(value="null -> null;!null -> !null")
    @Nullable
    private static Version adaptVersion(@Nullable com.falsepattern.lib.dependencies.Version version) {
        if (version == null) {
            return null;
        }
        if (version instanceof RawVersion) {
            RawVersion raw = (RawVersion)version;
            return new com.falsepattern.deploader.version.RawVersion(raw.versionString);
        }
        if (version instanceof SemanticVersion) {
            SemanticVersion sem = (SemanticVersion)version;
            return new com.falsepattern.deploader.version.SemanticVersion(sem.getMajorVersion(), sem.getMinorVersion(), sem.getPatchVersion(), sem.getPreRelease(), sem.getBuild());
        }
        if (version instanceof com.falsepattern.lib.dependencies.ComplexVersion) {
            com.falsepattern.lib.dependencies.ComplexVersion cplx = (com.falsepattern.lib.dependencies.ComplexVersion)version;
            com.falsepattern.lib.dependencies.Version[] versA = cplx.versionsRaw();
            Version[] vers = new Version[versA.length];
            for (int i = 0; i < versA.length; ++i) {
                vers[i] = DependencyLoaderImpl.adaptVersion(versA[i]);
            }
            return new ComplexVersion(vers);
        }
        throw new IllegalStateException(DependencyLoaderImpl.jvmdowngrader$concat$adaptVersion$1(version.getClass().getName()));
    }

    private static Library adaptLibrary(com.falsepattern.lib.dependencies.Library library) {
        return new Library(library.loadingModId, library.groupId, library.artifactId, DependencyLoaderImpl.adaptVersion(library.minVersion), DependencyLoaderImpl.adaptVersion(library.maxVersion), DependencyLoaderImpl.adaptVersion(library.preferredVersion), library.regularSuffix, library.devSuffix);
    }

    private static /* synthetic */ String jvmdowngrader$concat$adaptVersion$1(String string) {
        return "Unknown version class " + string;
    }
}

