/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraftforge.common.config.Property;

public class IntListConfigField
extends AListConfigField<int[], Config.DefaultIntList> {
    private final int min;
    private final int max;

    public IntListConfigField(ConfigFieldParameters params) throws ConfigException {
        super(params, Property.Type.INTEGER, Config.DefaultIntList.class, Config.DefaultIntList::value, Property::setDefaultValues);
        Optional<Config.RangeInt> range = Optional.ofNullable(this.field.getAnnotation(Config.RangeInt.class));
        this.min = range.map(Config.RangeInt::min).orElse(Integer.MIN_VALUE);
        this.max = range.map(Config.RangeInt::max).orElse(Integer.MAX_VALUE);
        Property property = this.getProperty();
        property.setMinValue(this.min);
        property.setMaxValue(this.max);
        if (!property.isIntList()) {
            this.setToDefault();
        }
        property.comment = IntListConfigField.jvmdowngrader$concat$$init$$1(property.comment, this.min, this.max, Arrays.toString((int[])this.defaultValue));
    }

    @Override
    protected int length(int[] arr) {
        return arr.length;
    }

    @Override
    protected int[] arrayCopy(int[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, int[] arr) throws IOException {
        for (int i : arr) {
            output.writeInt(i);
        }
    }

    @Override
    protected void receiveElements(DataInput input, int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readInt();
        }
    }

    @Override
    protected int[] createArray(int length) {
        return new int[length];
    }

    @Override
    public boolean validateField() {
        if (!super.validateField()) {
            return false;
        }
        int[] ints = (int[])this.getField();
        boolean valid = true;
        for (int j = 0; j < ints.length; ++j) {
            int i = ints[j];
            if (i >= this.min && i <= this.max) continue;
            ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, j, Integer.toString(i), Integer.toString(this.min), Integer.toString(this.max));
            valid = false;
        }
        return valid;
    }

    @Override
    protected int[] getConfig() {
        return this.getProperty().getIntList();
    }

    @Override
    protected void putConfig(int[] value) {
        this.getProperty().set(value);
    }

    @Override
    protected int[] getDefault() {
        return Arrays.copyOf((int[])this.defaultValue, ((int[])this.defaultValue).length);
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, int n, int n2, String string2) {
        return string + "\n[range: " + n + " ~ " + n2 + ", default: " + string2 + "]";
    }
}

