/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.config.event;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.internal.EventUtil;
import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.text.FormattedText;
import com.falsepattern.lib.toasts.GuiToast;
import com.falsepattern.lib.toasts.SimpleToast;
import com.falsepattern.lib.toasts.icon.ToastBG;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.ApiStatus;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={StringPatternMismatch.class, FieldIsNull.class, StringSizeOutOfBounds.class, ListSizeOutOfBounds.class, NumericRangeOutOfBounds.class})
public class ConfigValidationFailureEvent
extends Event {
    public final String reason;
    public final Class<?> configClass;
    public final String fieldName;
    public final boolean listElement;
    public final int listIndex;

    @ApiStatus.Internal
    protected ConfigValidationFailureEvent(String reason, Class<?> configClass, String fieldName, boolean listElement, int listIndex) {
        this.reason = reason;
        this.configClass = configClass;
        this.fieldName = fieldName;
        this.listElement = listElement;
        this.listIndex = listIndex;
    }

    @ApiStatus.Internal
    public static void postNumericRangeOutOfBounds(Field field, int listIndex, String value, String min, String max) {
        EventUtil.postOnCommonBus(new NumericRangeOutOfBounds(field.getDeclaringClass(), field.getName(), listIndex, value, min, max));
    }

    @ApiStatus.Internal
    public static void postSize(Field field, int requestedSize, boolean fixedSize, int maxSize, int defaultSize) {
        EventUtil.postOnCommonBus(new ListSizeOutOfBounds(field.getDeclaringClass(), field.getName(), requestedSize, fixedSize, maxSize, defaultSize));
    }

    @ApiStatus.Internal
    public static void postStringSizeOutOfBounds(Field field, int listIndex, String text, int maxSize) {
        EventUtil.postOnCommonBus(new StringSizeOutOfBounds(field.getDeclaringClass(), field.getName(), listIndex, text, maxSize));
    }

    @ApiStatus.Internal
    public static void fieldIsNull(Field field, int listIndex) {
        EventUtil.postOnCommonBus(new FieldIsNull(field.getDeclaringClass(), field.getName(), listIndex));
    }

    @ApiStatus.Internal
    public static void postStringPatternMismatch(Field field, int listIndex, String text, String pattern) {
        EventUtil.postOnCommonBus(new StringPatternMismatch(field.getDeclaringClass(), field.getName(), listIndex, text, pattern));
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public void toast() {
        Config ann = this.configClass.getAnnotation(Config.class);
        SimpleToast toast = new SimpleToast(ToastBG.TOAST_DARK, null, (IChatComponent)FormattedText.parse(ConfigValidationFailureEvent.jvmdowngrader$concat$toast$1(String.valueOf(EnumChatFormatting.RED))).toChatText().get(0), (IChatComponent)FormattedText.parse(ConfigValidationFailureEvent.jvmdowngrader$concat$toast$1(ann.modid(), ann.category())).toChatText().get(0), false, 2000L);
        GuiToast.add(toast);
    }

    @ApiStatus.Internal
    protected void customText(StringBuilder b) {
    }

    @ApiStatus.Internal
    public void logWarn() {
        StringBuilder errorString = new StringBuilder("Error validating configuration field!");
        errorString.append("\nReason: ").append(this.reason);
        errorString.append("\nClass: ").append(this.configClass.getName()).append("\nField: ").append(this.fieldName);
        if (this.listElement) {
            errorString.append("\nArray index: ").append(this.listIndex);
        }
        this.customText(errorString);
        for (String line : errorString.toString().split("\n")) {
            FPLog.LOG.error(line);
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$toast$1(String string) {
        return string + "Config validation failed";
    }

    private static /* synthetic */ String jvmdowngrader$concat$toast$1(String string, String string2) {
        return string + ":" + string2;
    }

    @NestHost(value=ConfigValidationFailureEvent.class)
    public static final class NumericRangeOutOfBounds
    extends ConfigValidationFailureEvent {
        public final String value;
        public final String min;
        public final String max;

        @ApiStatus.Internal
        public NumericRangeOutOfBounds(Class<?> configClass, String fieldName, int listIndex, String value, String min, String max) {
            super("Number range out of bounds", configClass, fieldName, listIndex >= 0, listIndex);
            this.value = value;
            this.min = min;
            this.max = max;
        }

        @Override
        protected void customText(StringBuilder b) {
            b.append("\nValue: ").append(this.value).append("\nMin: ").append(this.min).append("\nMax: ").append(this.max);
        }
    }

    @NestHost(value=ConfigValidationFailureEvent.class)
    public static final class ListSizeOutOfBounds
    extends ConfigValidationFailureEvent {
        public final int size;
        public final boolean fixedSize;
        public final int maxSize;
        public final int defaultSize;

        @ApiStatus.Internal
        public ListSizeOutOfBounds(Class<?> configClass, String fieldName, int size, boolean fixedSize, int maxSize, int defaultSize) {
            super("Array size out of bounds", configClass, fieldName, false, -1);
            this.size = size;
            this.fixedSize = fixedSize;
            this.maxSize = maxSize;
            this.defaultSize = defaultSize;
        }

        @Override
        protected void customText(StringBuilder b) {
            b.append("\nSize: ").append(this.size);
            if (this.fixedSize) {
                b.append("\nRequired size: ").append(this.defaultSize);
            }
            b.append("\nMaximum size: ").append(this.maxSize);
        }
    }

    @NestHost(value=ConfigValidationFailureEvent.class)
    public static final class StringSizeOutOfBounds
    extends ConfigValidationFailureEvent {
        public final String text;
        public final int maxSize;

        @ApiStatus.Internal
        public StringSizeOutOfBounds(Class<?> configClass, String fieldName, int listIndex, String text, int maxSize) {
            super("String size out of bounds", configClass, fieldName, listIndex >= 0, listIndex);
            this.text = text;
            this.maxSize = maxSize;
        }

        @Override
        protected void customText(StringBuilder b) {
            b.append("\nText: ").append(this.text).append("\nSize: ").append(this.text.length()).append("\nMax size:").append(this.maxSize);
        }
    }

    @NestHost(value=ConfigValidationFailureEvent.class)
    public static final class FieldIsNull
    extends ConfigValidationFailureEvent {
        @ApiStatus.Internal
        public FieldIsNull(Class<?> configClass, String fieldName, int listIndex) {
            super("Unexpected null", configClass, fieldName, listIndex >= 0, listIndex);
        }

        @Override
        protected void customText(StringBuilder b) {
        }
    }

    @NestHost(value=ConfigValidationFailureEvent.class)
    public static final class StringPatternMismatch
    extends ConfigValidationFailureEvent {
        public final String text;
        public final String pattern;

        @ApiStatus.Internal
        public StringPatternMismatch(Class<?> configClass, String fieldName, int listIndex, String text, String pattern) {
            super("String pattern mismatch", configClass, fieldName, listIndex >= 0, listIndex);
            this.text = text;
            this.pattern = pattern;
        }

        @Override
        protected void customText(StringBuilder b) {
            b.append("\nText: ").append(this.text).append("\nPattern: ").append(this.pattern);
        }
    }
}

