/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.compat;

import lombok.NonNull;
import net.minecraft.util.EnumFacing;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public enum Rotation {
    NONE,
    CLOCKWISE_90,
    CLOCKWISE_180,
    COUNTERCLOCKWISE_90;


    public Rotation add(@NonNull Rotation rotation) {
        if (rotation == null) {
            throw new NullPointerException("rotation is marked non-null but is null");
        }
        Rotation[] values = Rotation.values();
        return values[(this.ordinal() + rotation.ordinal()) % values.length];
    }

    public EnumFacing rotate(@NonNull EnumFacing facing) {
        if (facing == null) {
            throw new NullPointerException("facing is marked non-null but is null");
        }
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            return facing;
        }
        switch (this) {
            case CLOCKWISE_90: {
                switch (facing) {
                    case NORTH: {
                        return EnumFacing.EAST;
                    }
                    case EAST: {
                        return EnumFacing.SOUTH;
                    }
                    case SOUTH: {
                        return EnumFacing.WEST;
                    }
                    case WEST: {
                        return EnumFacing.NORTH;
                    }
                }
                throw new IllegalStateException(Rotation.jvmdowngrader$concat$rotate$1(String.valueOf(facing)));
            }
            case CLOCKWISE_180: {
                switch (facing) {
                    case NORTH: {
                        return EnumFacing.SOUTH;
                    }
                    case EAST: {
                        return EnumFacing.WEST;
                    }
                    case SOUTH: {
                        return EnumFacing.NORTH;
                    }
                    case WEST: {
                        return EnumFacing.EAST;
                    }
                }
                throw new IllegalStateException(Rotation.jvmdowngrader$concat$rotate$1(String.valueOf(facing)));
            }
            case COUNTERCLOCKWISE_90: {
                switch (facing) {
                    case NORTH: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.NORTH;
                    }
                    case SOUTH: {
                        return EnumFacing.EAST;
                    }
                    case WEST: {
                        return EnumFacing.SOUTH;
                    }
                }
                throw new IllegalStateException(Rotation.jvmdowngrader$concat$rotate$1(String.valueOf(facing)));
            }
        }
        return facing;
    }

    public int rotate(int x, int z) {
        switch (this) {
            case CLOCKWISE_90: {
                return (x + z / 4) % z;
            }
            case CLOCKWISE_180: {
                return (x + z / 2) % z;
            }
            case COUNTERCLOCKWISE_90: {
                return (x + z * 3 / 4) % z;
            }
        }
        return x;
    }

    private static /* synthetic */ String jvmdowngrader$concat$rotate$1(String string) {
        return "Unable to get Y-rotated facing of " + string;
    }
}

