/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pcl.opensecurity.blocks.BlockOSBase;
import pcl.opensecurity.tileentity.TileEntityKeypadLock;

public class BlockKeypadLock
extends BlockOSBase {
    static IIcon textureTop;
    static IIcon textureSide;
    static IIcon textureBottom;

    public BlockKeypadLock() {
        this.func_149663_c("keypadlock");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        textureTop = iconRegister.func_94245_a("opensecurity:machine_side");
        textureBottom = iconRegister.func_94245_a("opensecurity:machine_side");
        textureSide = iconRegister.func_94245_a("opensecurity:machine_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side == 0) {
            return textureBottom;
        }
        if (side == 1) {
            return textureTop;
        }
        return textureSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int par2) {
        return side == 1 ? textureTop : textureSide;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side > 1) {
            int mx = x;
            int my = y;
            int mz = z;
            switch (side) {
                case 2: {
                    ++mz;
                    break;
                }
                case 3: {
                    --mz;
                    break;
                }
                case 4: {
                    ++mx;
                    break;
                }
                case 5: {
                    --mx;
                    break;
                }
            }
            int facing = blockAccess.func_72805_g(mx, my, mz);
            if (facing == side) {
                return false;
            }
        }
        return super.func_149646_a(blockAccess, x, y, z, side);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        int facing = world.func_72805_g(x, y, z);
        if (facing != side) {
            return false;
        }
        float relX = 0.0f;
        float relY = hitY * 16.0f;
        switch (facing) {
            case 2: {
                relX = hitX * 16.0f;
                break;
            }
            case 3: {
                relX = (1.0f - hitX) * 16.0f;
                break;
            }
            case 4: {
                relX = (1.0f - hitZ) * 16.0f;
                break;
            }
            case 5: {
                relX = hitZ * 16.0f;
                break;
            }
        }
        if (relX < 4.0f || relX > 12.0f || relY < 2.0f || relY > 11.5f) {
            return true;
        }
        int col = (int)((relX - 4.0f) / 3.0f);
        float colOff = (relX - 4.0f) % 3.0f;
        int row = (int)((relY - 2.0f) / 2.5f);
        float rowOff = (relY - 2.0f) % 2.5f;
        if (colOff > 2.0f || rowOff > 2.0f) {
            return true;
        }
        int idx = 2 - col + 3 * (3 - row);
        TileEntityKeypadLock te = (TileEntityKeypadLock)world.func_147438_o(x, y, z);
        te.pressedButton(player, idx);
        return true;
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityKeypadLock();
    }
}

