/*
 * Decompiled with CFR 0.152.
 */
package net.vademdev.solarfluxreboot.init.tileentity;

import cofh.api.energy.EnergyStorage;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.vademdev.solarfluxreboot.core.energy.TileEnergized;
import net.vademdev.solarfluxreboot.init.solar.SolarTier;

public class TileEntitySolarPanel
extends TileEnergized
implements IInventory {
    private SolarTier solarTier;
    private final short tickShift;
    private float sunIntensity;
    private int energyGeneration;
    private ItemStack[] contents = new ItemStack[5];

    public TileEntitySolarPanel() {
        this(SolarTier.TIER_1);
    }

    public TileEntitySolarPanel(SolarTier solarTier) {
        super(new EnergyStorage(solarTier.getEnergyCapacity(), solarTier.getEnergyTransfer(), solarTier.getEnergyTransfer()));
        this.tickShift = (short)new Random().nextInt(100);
        this.solarTier = solarTier;
    }

    public void func_145845_h() {
        this.generateEnergy();
        if (!this.field_145850_b.field_72995_K) {
            if (this.atTickRate(20)) {
                this.updateEnergyGeneration();
            }
            this.outputEnergy();
        }
    }

    private void generateEnergy() {
        if (this.energyGeneration > 0) {
            this.storage.receiveEnergy(this.energyGeneration, false);
        }
    }

    private void updateEnergyGeneration() {
        this.computeSunIntensity();
        this.energyGeneration = Math.round((float)this.solarTier.getEnergyGeneration() * this.sunIntensity);
    }

    private void computeSunIntensity() {
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            float celestialAngleRadians = this.field_145850_b.func_72929_e(1.0f);
            if ((double)celestialAngleRadians > Math.PI) {
                celestialAngleRadians = 6.283184f - celestialAngleRadians;
            }
            this.sunIntensity = 1.5f * MathHelper.func_76134_b((float)(celestialAngleRadians / 1.2f));
            this.sunIntensity = Math.max(0.0f, this.sunIntensity);
            this.sunIntensity = Math.min(1.0f, this.sunIntensity);
            if (this.sunIntensity > 0.0f) {
                if (this.field_145850_b.func_72896_J()) {
                    this.sunIntensity = (float)((double)this.sunIntensity * 0.4);
                } else if (this.field_145850_b.func_72911_I()) {
                    this.sunIntensity = (float)((double)this.sunIntensity * 0.4);
                }
            }
        } else {
            this.sunIntensity = 0.0f;
        }
    }

    public boolean atTickRate(int tickRate) {
        return (this.func_145831_w().func_82737_E() + (long)this.tickShift) % (long)tickRate == 0L;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.solarTier = SolarTier.valueOf(compound.func_74779_i("SolarTier"));
        this.storage.setCapacity(this.solarTier.getEnergyCapacity());
        this.storage.setMaxTransfer(this.solarTier.getEnergyTransfer());
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.contents.length) continue;
            this.contents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74778_a("SolarTier", this.solarTier.name());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.contents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int func_70302_i_() {
        return this.contents.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.contents[slotIndex] != null) {
            if (this.contents[slotIndex].field_77994_a <= amount) {
                ItemStack itemstack = this.contents[slotIndex];
                this.contents[slotIndex] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.contents[slotIndex].func_77979_a(amount);
            if (this.contents[slotIndex].field_77994_a == 0) {
                this.contents[slotIndex] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.contents[slotIndex] != null) {
            ItemStack itemstack = this.contents[slotIndex];
            this.contents[slotIndex] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack stack) {
        this.contents[slotIndex] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "SolarPanel";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return forgeDirection != ForgeDirection.UP;
    }

    public int getCurrentEnergyGeneration() {
        return this.energyGeneration;
    }

    public void setCurrentEnergyGeneration(int energyGeneration) {
        this.energyGeneration = energyGeneration;
    }

    public float getSunIntensity() {
        return this.sunIntensity;
    }

    public void setSunIntensity(float sunIntensity) {
        this.sunIntensity = sunIntensity;
    }

    public SolarTier getSolarTier() {
        return this.solarTier;
    }
}

