/*
 * Decompiled with CFR 0.152.
 */
package net.vademdev.solarfluxreboot.init;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.vademdev.solarfluxreboot.init.item.SolarPanelItemBlock;
import net.vademdev.solarfluxreboot.init.solar.BlockSolarPanel;
import net.vademdev.solarfluxreboot.init.solar.SolarTier;
import net.vademdev.solarfluxreboot.init.tileentity.TileEntitySolarPanel;

public class ModBlocks {
    public static Map<SolarTier, BlockSolarPanel> solarMap = new HashMap<SolarTier, BlockSolarPanel>();

    public ModBlocks() {
        this.initBlocks();
        this.initTilesEntities();
        solarMap.forEach(this::registerSolarBlock);
    }

    private void initBlocks() {
        for (SolarTier value : SolarTier.values()) {
            if (!value.isDependencyActive()) continue;
            solarMap.put(value, value.getSolarTierAsSolar());
        }
    }

    private void initTilesEntities() {
        this.registerTileEntity(TileEntitySolarPanel.class);
    }

    private void registerSolarBlock(SolarTier tier, BlockSolarPanel block) {
        GameRegistry.registerBlock((Block)block, SolarPanelItemBlock.class, (String)block.func_149739_a().substring(5));
    }

    private void registerTileEntity(Class<? extends TileEntity> tileEntity) {
        GameRegistry.registerTileEntity(tileEntity, (String)tileEntity.getSimpleName());
    }
}

