/*
 * Decompiled with CFR 0.152.
 */
package net.vademdev.solarfluxreboot.dependencies;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.vademdev.solarfluxreboot.Main;
import net.vademdev.solarfluxreboot.init.craftings.AvaritiaCraftings;
import net.vademdev.solarfluxreboot.init.craftings.BotaniaCraftings;
import net.vademdev.solarfluxreboot.init.craftings.DefaultCraftings;
import net.vademdev.solarfluxreboot.init.craftings.DraconicEvolutionCraftings;
import net.vademdev.solarfluxreboot.init.craftings.ICraftingHandler;

public enum Dependency {
    THERMAL_EXPENTION("ThermalExpansion", new DefaultCraftings(), true),
    BOTANIA("Botania", new BotaniaCraftings(), false),
    DRACONIC_EVOLUTION("DraconicEvolution", new DraconicEvolutionCraftings(), false),
    AVARITIA("Avaritia", new AvaritiaCraftings(), false);

    private String modid;
    private ICraftingHandler craftingHandler;
    private boolean defaultLoaded;

    private Dependency(String modid, ICraftingHandler craftingHandler, boolean defaultLoaded) {
        this.modid = modid;
        this.craftingHandler = craftingHandler;
        this.defaultLoaded = defaultLoaded;
    }

    public Item getItem(String name) {
        return GameRegistry.findItem((String)this.modid, (String)name);
    }

    public ItemStack getItemStackWithMetadata(String name, int metadata) {
        return new ItemStack(GameRegistry.findItem((String)this.modid, (String)name), 1, metadata);
    }

    public Block getBlock(String name) {
        return GameRegistry.findBlock((String)this.modid, (String)name);
    }

    public void registerCraftings() {
        if (this.craftingHandler == null) {
            return;
        }
        this.craftingHandler.registerShapedRecipies();
        this.craftingHandler.registerShapelessRecipies();
        this.craftingHandler.registerOthersRecipies();
    }

    public String getModid() {
        return this.modid;
    }

    public boolean isLoaded() {
        return !this.defaultLoaded ? Main.instance.dependenciesManager.isDependencyLoaded(this) : this.defaultLoaded;
    }

    public boolean isDefaultLoaded() {
        return this.defaultLoaded;
    }
}

