/*
 * Decompiled with CFR 0.152.
 */
package net.vademdev.solarfluxreboot.core.energy;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEnergized
extends TileEntity
implements IEnergyHandler {
    public EnergyStorage storage;

    public TileEnergized(EnergyStorage storage) {
        this.storage = storage;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }

    public void outputEnergy() {
        for (ForgeDirection vd : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.func_145831_w().func_147438_o(this.field_145851_c + vd.offsetX, this.field_145848_d + vd.offsetY, this.field_145849_e + vd.offsetZ);
            if (te instanceof IEnergyReceiver) {
                this.extractEnergy(vd, ((IEnergyReceiver)te).receiveEnergy(vd.getOpposite(), this.extractEnergy(vd, this.storage.getMaxExtract(), true), false), false);
                continue;
            }
            if (!(te instanceof IEnergyStorage)) continue;
            this.extractEnergy(vd, ((IEnergyStorage)te).receiveEnergy(this.extractEnergy(vd, this.storage.getMaxExtract(), true), false), false);
        }
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(Math.min(maxExtract, this.storage.getMaxExtract()), simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }
}

