/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.mysteriumlib.asm.fixes;

import com.google.common.cache.Cache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.tclproject.mysteriumlib.asm.annotations.Fix;
import net.tclproject.teresetfix.TEResetFix;

public class MysteriumPatchesFixesTE {
    private static final MethodHandle dormantChunkCacheGet = MysteriumPatchesFixesTE.createDormantChunkCacheGet();

    private static MethodHandle createDormantChunkCacheGet() {
        try {
            Field field2 = ForgeChunkManager.class.getDeclaredField("dormantChunkCache");
            field2.setAccessible(true);
            return MethodHandles.publicLookup().unreflectGetter(field2);
        }
        catch (Exception e) {
            TEResetFix.logger.error("Cannot get dormantChunkCache. The mod will not work properly and you should report this as a bug.", (Throwable)e);
            return null;
        }
    }

    @Fix(insertOnExit=true)
    public static void fetchDormantChunk(ForgeChunkManager fcm, long coords, World world) {
        try {
            Map dormantChunkCache = null;
            try {
                dormantChunkCache = dormantChunkCacheGet.invokeExact();
            }
            catch (Throwable e) {
                TEResetFix.logger.error("Cannot invoke dormantChunkCache! The mod will not work properly and you should report this as a bug.", e);
            }
            Cache cache = (Cache)dormantChunkCache.get(world);
            if (cache == null) {
                return;
            }
            cache.invalidate((Object)coords);
        }
        catch (Exception e) {
            TEResetFix.logger.error("Something went wrong. The mod will not work properly and you should report this as a bug.", (Throwable)e);
        }
    }
}

