/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.network;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.item.AEItemStack;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.core.MEHandler;
import portablejim.bbw.shims.BasicPlayerShim;

public abstract class SynchronizeAEItemQuantity<T extends IMessage>
implements IMessage,
IMessageHandler<T, IMessage> {
    private static final byte INT = -128;
    private static final byte SHORT = -127;
    private static final int USHORT_MAX = 65535;
    private static final short UBYTE_MAX = 251;

    public static void writeVar(ByteBuf buf, int value) {
        if (value > 65535) {
            buf.writeByte(-128);
            buf.writeInt(value);
            return;
        }
        if (value > 251) {
            buf.writeByte(-127);
            buf.writeShort(value);
            return;
        }
        buf.writeByte(value);
    }

    public static int readVar(ByteBuf buf) {
        short type = buf.readByte();
        switch (type) {
            case -128: {
                return buf.readInt();
            }
            case -127: {
                return buf.readShort();
            }
        }
        return type;
    }

    public static class SyncServer
    extends SynchronizeAEItemQuantity<SyncServer> {
        private ItemStack stack;

        public SyncServer() {
        }

        public SyncServer(ItemStack stack) {
            this.stack = stack;
        }

        public void fromBytes(ByteBuf buf) {
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        }

        public IMessage onMessage(SyncServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WirelessTerminalGuiObject obj = MEHandler.getTerminalGuiObject((EntityPlayer)player);
            if (obj == null) {
                BetterBuildersWandsMod.instance.networkWrapper.sendTo((IMessage)new SyncClient(0), player);
                return null;
            }
            IAEItemStack item = (IAEItemStack)obj.getStorageList().findPrecise((IAEStack)AEItemStack.create((ItemStack)message.stack));
            if (item != null && (obj.rangeCheck() || Loader.isModLoaded((String)"ae2fc") && Util.hasInfinityBoosterCard((ItemStack)obj.getItemStack()))) {
                int size = (int)Math.min(item.getStackSize(), Integer.MAX_VALUE);
                BetterBuildersWandsMod.instance.networkWrapper.sendTo((IMessage)new SyncClient(size), player);
            } else {
                BetterBuildersWandsMod.instance.networkWrapper.sendTo((IMessage)new SyncClient(0), player);
            }
            return null;
        }
    }

    public static class SyncClient
    extends SynchronizeAEItemQuantity<SyncClient> {
        private int size;

        public SyncClient() {
        }

        public SyncClient(int value) {
            this.size = value;
        }

        public void fromBytes(ByteBuf buf) {
            BasicPlayerShim.AEItemSize = SyncClient.readVar(buf);
        }

        public void toBytes(ByteBuf buf) {
            SyncClient.writeVar(buf, this.size);
        }

        public IMessage onMessage(SyncClient message, MessageContext ctx) {
            return null;
        }
    }
}

