/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.component;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBobble;
import com.hbm.itempool.ItemPool;
import com.hbm.lib.HbmChestContents;
import com.hbm.util.LootGenerator;
import com.hbm.world.gen.component.Component;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemDoor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class CivilianFeatures {
    public static void registerComponents() {
        MapGenStructureIO.func_143031_a(NTMHouse1.class, (String)"NTMHouse1");
        MapGenStructureIO.func_143031_a(NTMHouse2.class, (String)"NTMHouse2");
        MapGenStructureIO.func_143031_a(NTMLab1.class, (String)"NTMLab1");
        MapGenStructureIO.func_143031_a(NTMLab2.class, (String)"NTMLab2");
        MapGenStructureIO.func_143031_a(RuralHouse1.class, (String)"NTMRuralHouse1");
    }

    public static class RuralHouse1
    extends Component {
        public RuralHouse1() {
        }

        public RuralHouse1(Random rand, int minX, int minZ) {
            super(rand, minX, 64, minZ, 14, 8, 14);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.func_74878_a(world, box, 9, 1, 3, 12, 4, 8);
            this.func_74878_a(world, box, 5, 1, 2, 8, 3, 8);
            this.func_74878_a(world, box, 2, 1, 5, 4, 3, 8);
            this.func_74878_a(world, box, 2, 1, 10, 7, 3, 12);
            this.fillWithBlocks(world, box, 1, 0, 4, 4, 0, 4, ModBlocks.concrete_colored_ext);
            this.fillWithBlocks(world, box, 4, 0, 2, 4, 0, 3, ModBlocks.concrete_colored_ext);
            this.fillWithBlocks(world, box, 4, 0, 1, 9, 0, 1, ModBlocks.concrete_colored_ext);
            this.fillWithBlocks(world, box, 9, 0, 2, 10, 0, 2, ModBlocks.concrete_colored_ext);
            this.func_151550_a(world, ModBlocks.concrete_colored_ext, 0, 12, 0, 2, box);
            this.fillWithBlocks(world, box, 13, 0, 2, 13, 0, 9, ModBlocks.concrete_colored_ext);
            this.fillWithBlocks(world, box, 5, 0, 9, 12, 0, 9, ModBlocks.concrete_colored_ext);
            this.fillWithBlocks(world, box, 2, 0, 9, 3, 0, 9, ModBlocks.concrete_colored_ext);
            this.func_151550_a(world, ModBlocks.concrete_colored_ext, 0, 8, 0, 10, box);
            this.fillWithBlocks(world, box, 8, 0, 12, 8, 0, 13, ModBlocks.concrete_colored_ext);
            this.fillWithBlocks(world, box, 1, 0, 13, 7, 0, 13, ModBlocks.concrete_colored_ext);
            this.fillWithBlocks(world, box, 1, 0, 5, 1, 0, 12, ModBlocks.concrete_colored_ext);
            this.placeFoundationUnderneath(world, ModBlocks.concrete_colored_ext, 0, 1, 10, 8, 13, -1, box);
            this.placeFoundationUnderneath(world, ModBlocks.concrete_colored_ext, 0, 1, 4, 3, 9, -1, box);
            this.placeFoundationUnderneath(world, ModBlocks.concrete_colored_ext, 0, 4, 1, 13, 9, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 2, 3, 2, 3, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 3, 2, 3, 2, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 3, 0, 3, 0, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 5, 0, 5, 0, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 8, 0, 8, 0, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 10, 0, 10, 0, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 14, 1, 14, 1, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 14, 3, 14, 3, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 14, 5, 14, 6, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 14, 8, 14, 8, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 14, 10, 14, 10, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 9, 14, 9, 14, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 7, 14, 7, 14, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 4, 14, 5, 14, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 2, 14, 2, 14, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 0, 14, 0, 14, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 0, 13, 0, 13, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 0, 11, 0, 11, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 0, 9, 0, 9, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 0, 6, 0, 7, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 0, 4, 0, 4, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150364_r, 0, 0, 3, 0, 4, -1, box);
            this.fillWithBlocks(world, box, 1, 1, 4, 4, 4, 4, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 2, 5, 4, 7, 5, 4, Blocks.field_150336_V);
            this.func_151550_a(world, Blocks.field_150336_V, 0, 3, 6, 4, box);
            this.func_151550_a(world, Blocks.field_150336_V, 0, 6, 6, 4, box);
            this.fillWithBlocks(world, box, 4, 7, 4, 5, 7, 4, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 4, 1, 1, 4, 4, 3, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 5, 1, 1, 8, 1, 1, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 5, 4, 1, 8, 4, 1, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 9, 1, 1, 9, 4, 2, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 10, 1, 2, 10, 3, 2, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 12, 1, 2, 13, 3, 2, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 10, 4, 2, 13, 4, 2, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 9, 5, 2, 12, 5, 2, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 10, 6, 2, 11, 6, 2, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 13, 1, 3, 13, 1, 8, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 13, 3, 3, 13, 4, 8, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 13, 1, 9, 13, 4, 9, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 9, 1, 9, 12, 1, 9, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 9, 4, 9, 12, 5, 9, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 10, 6, 9, 11, 6, 9, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 8, 1, 9, 8, 4, 10, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 8, 1, 12, 8, 3, 13, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 8, 4, 11, 8, 4, 13, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 7, 1, 13, 7, 3, 13, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 3, 1, 13, 6, 1, 13, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 2, 4, 13, 7, 5, 13, Blocks.field_150336_V);
            this.func_151550_a(world, Blocks.field_150336_V, 0, 6, 6, 13, box);
            this.func_151550_a(world, Blocks.field_150336_V, 0, 3, 6, 13, box);
            this.fillWithBlocks(world, box, 4, 7, 13, 5, 7, 13, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 2, 1, 13, 2, 3, 13, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 1, 1, 13, 1, 4, 13, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 1, 1, 5, 1, 1, 12, Blocks.field_150336_V);
            this.func_151550_a(world, Blocks.field_150336_V, 0, 1, 2, 9, box);
            this.fillWithBlocks(world, box, 1, 3, 5, 1, 3, 12, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 2, 1, 9, 3, 3, 9, Blocks.field_150336_V);
            this.fillWithBlocks(world, box, 5, 1, 9, 7, 3, 9, Blocks.field_150336_V);
            this.fillWithMetadataBlocks(world, box, 5, 2, 1, 5, 3, 1, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 8, 2, 1, 8, 3, 1, Blocks.field_150344_f, 1);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 11, 3, 2, box);
            this.fillWithMetadataBlocks(world, box, 13, 2, 3, 13, 2, 4, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 13, 2, 7, 13, 2, 8, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 12, 2, 9, 12, 3, 9, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 9, 2, 9, 9, 3, 9, Blocks.field_150344_f, 1);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 8, 3, 11, box);
            this.fillWithMetadataBlocks(world, box, 6, 2, 13, 6, 3, 13, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 3, 2, 13, 3, 3, 13, Blocks.field_150344_f, 1);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 1, 2, 12, box);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 1, 2, 10, box);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 1, 2, 8, box);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 1, 2, 5, box);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 4, 3, 9, box);
            int logW = this.getPillarMeta(4);
            int logN = this.getPillarMeta(8);
            this.fillWithBlocks(world, box, 0, 0, 3, 0, 3, 3, Blocks.field_150364_r);
            this.fillWithMetadataBlocks(world, box, 1, 4, 3, 3, 4, 3, Blocks.field_150364_r, logW);
            this.fillWithMetadataBlocks(world, box, 3, 4, 1, 3, 4, 2, Blocks.field_150364_r, logN);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 1, 3, 3, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 3, 3, 1, box);
            this.fillWithMetadataBlocks(world, box, 1, 1, 3, 2, 1, 3, (Block)Blocks.field_150376_bx, 1);
            this.fillWithMetadataBlocks(world, box, 3, 1, 1, 3, 1, 3, (Block)Blocks.field_150376_bx, 1);
            this.fillWithBlocks(world, box, 3, 0, 0, 3, 3, 0, Blocks.field_150364_r);
            this.fillWithMetadataBlocks(world, box, 4, 1, 0, 9, 1, 0, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 4, 3, 0, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 9, 3, 0, box);
            this.fillWithBlocks(world, box, 10, 0, 0, 10, 3, 0, Blocks.field_150364_r);
            this.fillWithMetadataBlocks(world, box, 10, 4, 1, 13, 4, 1, Blocks.field_150364_r, logW);
            this.fillWithBlocks(world, box, 14, 0, 1, 14, 3, 1, Blocks.field_150364_r);
            this.fillWithBlocks(world, box, 14, 0, 3, 14, 3, 3, Blocks.field_150364_r);
            this.fillWithBlocks(world, box, 14, 0, 8, 14, 3, 8, Blocks.field_150364_r);
            this.fillWithBlocks(world, box, 14, 0, 10, 14, 3, 10, Blocks.field_150364_r);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 1, 14, 1, 2, box);
            this.fillWithMetadataBlocks(world, box, 14, 1, 4, 14, 1, 7, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 1, 14, 1, 9, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 14, 3, 2, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 14, 3, 4, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 14, 3, 7, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 14, 3, 9, box);
            this.fillWithMetadataBlocks(world, box, 9, 4, 10, 13, 4, 10, Blocks.field_150364_r, logW);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 13, 3, 10, box);
            this.fillWithBlocks(world, box, 9, 0, 14, 9, 3, 14, Blocks.field_150364_r);
            this.fillWithBlocks(world, box, 7, 0, 14, 7, 3, 14, Blocks.field_150364_r);
            this.fillWithBlocks(world, box, 2, 0, 14, 2, 3, 14, Blocks.field_150364_r);
            this.fillWithBlocks(world, box, 0, 0, 14, 0, 3, 14, Blocks.field_150364_r);
            this.fillWithMetadataBlocks(world, box, 1, 4, 14, 8, 4, 14, Blocks.field_150364_r, logW);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 1, 8, 1, 14, box);
            this.fillWithMetadataBlocks(world, box, 3, 1, 14, 6, 1, 14, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 1, 1, 1, 14, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 8, 3, 14, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 1, 3, 14, box);
            this.fillWithBlocks(world, box, 0, 0, 9, 0, 3, 9, Blocks.field_150364_r);
            this.fillWithMetadataBlocks(world, box, 0, 1, 10, 0, 1, 13, (Block)Blocks.field_150376_bx, 1);
            this.fillWithMetadataBlocks(world, box, 0, 1, 4, 0, 1, 8, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 0, 3, 13, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 0, 3, 10, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 0, 3, 8, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 0, 3, 4, box);
            int stairW = this.getStairMeta(0);
            int stairE = this.getStairMeta(1);
            int stairN = this.getStairMeta(2);
            int stairS = this.getStairMeta(3);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 11, 0, 2, box);
            this.fillWithMetadataBlocks(world, box, 9, 0, 3, 12, 0, 8, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 5, 0, 2, 8, 0, 8, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 2, 0, 5, 4, 0, 8, Blocks.field_150344_f, 1);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 4, 0, 9, box);
            this.fillWithMetadataBlocks(world, box, 2, 0, 10, 7, 0, 12, Blocks.field_150344_f, 1);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 8, 0, 11, box);
            this.fillWithBlocks(world, box, 13, 1, 0, 14, 1, 0, Blocks.field_150422_aJ);
            this.fillWithBlocks(world, box, 10, 0, 1, 13, 0, 1, Blocks.field_150344_f);
            this.fillWithMetadataBlocks(world, box, 11, 0, 0, 12, 0, 0, Blocks.field_150485_bF, stairN);
            this.fillWithMetadataBlocks(world, box, 13, 0, 0, 14, 0, 0, Blocks.field_150344_f, 1);
            this.fillWithBlocks(world, box, 12, 0, 10, 13, 0, 10, Blocks.field_150344_f);
            this.fillWithBlocks(world, box, 9, 0, 10, 11, 0, 11, Blocks.field_150344_f);
            this.fillWithBlocks(world, box, 9, 0, 12, 10, 0, 12, Blocks.field_150344_f);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 9, 0, 13, box);
            for (int i = 0; i < 3; ++i) {
                this.fillWithMetadataBlocks(world, box, 10 + i, 0, 13 - i, 11 + i, 0, 13 - i, Blocks.field_150344_f, 1);
                this.fillWithBlocks(world, box, 10 + i, 1, 13 - i, 11 + i, 1, 13 - i, Blocks.field_150422_aJ);
            }
            this.fillWithMetadataBlocks(world, box, 12, 4, 3, 12, 4, 8, Blocks.field_150476_ad, stairW | 4);
            this.fillWithBlocks(world, box, 12, 5, 3, 12, 5, 8, Blocks.field_150344_f);
            this.fillWithBlocks(world, box, 10, 5, 3, 11, 6, 8, Blocks.field_150344_f);
            this.fillWithBlocks(world, box, 9, 5, 3, 9, 5, 8, Blocks.field_150344_f);
            this.fillWithMetadataBlocks(world, box, 9, 4, 3, 9, 4, 8, Blocks.field_150476_ad, stairE | 4);
            this.fillWithBlocks(world, box, 8, 4, 5, 8, 4, 8, Blocks.field_150344_f);
            this.fillWithBlocks(world, box, 5, 4, 2, 8, 4, 4, Blocks.field_150344_f);
            this.fillWithBlocks(world, box, 1, 4, 5, 7, 4, 12, Blocks.field_150344_f);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 1, 5, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 2, 6, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 3, 6, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 3, 7, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 4, 7, 3, box);
            this.fillWithMetadataBlocks(world, box, 4, 8, 3, 5, 8, 3, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 5, 7, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 6, 7, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 6, 6, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 7, 6, 3, box);
            this.fillWithMetadataBlocks(world, box, 2, 5, 3, 3, 5, 3, Blocks.field_150344_f, 1);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 3, 5, 2, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 1, 3, 5, 1, box);
            this.fillWithMetadataBlocks(world, box, 3, 4, 0, 14, 4, 0, Blocks.field_150485_bF, stairN);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 8, 5, 1, box);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 9, 5, 1, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 1, 10, 5, 1, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 9, 6, 1, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 10, 6, 1, box);
            this.fillWithMetadataBlocks(world, box, 10, 7, 1, 11, 7, 1, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 11, 6, 1, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 12, 6, 1, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 12, 5, 1, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 13, 5, 1, box);
            this.fillWithMetadataBlocks(world, box, 14, 4, 1, 14, 4, 10, Blocks.field_150485_bF, stairE);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 13, 5, 10, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 12, 5, 10, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 12, 6, 10, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 11, 6, 10, box);
            this.fillWithMetadataBlocks(world, box, 10, 7, 10, 11, 7, 10, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 10, 6, 10, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 9, 6, 10, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 9, 5, 10, box);
            this.fillWithMetadataBlocks(world, box, 9, 4, 11, 9, 4, 14, Blocks.field_150485_bF, stairE);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 8, 5, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 7, 5, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 7, 6, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 6, 6, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE, 6, 7, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 5, 7, 14, box);
            this.fillWithMetadataBlocks(world, box, 4, 8, 14, 5, 8, 14, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 4, 7, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 3, 7, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 3, 6, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 2, 6, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 2, 5, 14, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairW, 1, 5, 14, box);
            this.fillWithMetadataBlocks(world, box, 0, 4, 3, 0, 4, 14, Blocks.field_150485_bF, stairW);
            for (int z = 6; z <= 11; z += 5) {
                for (int i = 0; i < 3; ++i) {
                    this.func_151550_a(world, Blocks.field_150485_bF, stairE | 4, 2 + i, 5 + i, z, box);
                    this.func_151550_a(world, Blocks.field_150485_bF, stairW | 4, 7 - i, 5 + i, z, box);
                }
            }
            BrokenStairs roofStairs = new BrokenStairs();
            BrokenBlocks roofBlocks = new BrokenBlocks();
            roofStairs.setMetadata(stairW);
            this.fillWithBlocks(world, box, 4, 5, 1, 7, 5, 1, (Block)Blocks.field_150376_bx);
            this.fillWithRandomizedBlocks(world, box, 4, 5, 2, 7, 5, 3, rand, roofBlocks);
            this.fillWithRandomizedBlocks(world, box, 8, 5, 2, 8, 5, 10, rand, roofBlocks);
            this.fillWithRandomizedBlocks(world, box, 9, 6, 2, 9, 6, 9, rand, roofStairs);
            this.randomlyFillWithBlocks(world, box, rand, 0.8f, 10, 7, 2, 11, 7, 9, (Block)Blocks.field_150376_bx);
            roofStairs.setMetadata(stairE);
            this.fillWithRandomizedBlocks(world, box, 12, 6, 2, 12, 6, 9, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 13, 5, 2, 13, 5, 9, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 8, 5, 11, 8, 5, 13, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 7, 6, 4, 7, 6, 13, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 6, 7, 4, 6, 7, 7, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 6, 7, 11, 6, 7, 13, rand, roofStairs);
            roofStairs.setMetadata(stairW);
            this.fillWithBlocks(world, box, 4, 8, 4, 5, 8, 5, (Block)Blocks.field_150376_bx);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 5, 8, 6, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 4, 8, 11, box);
            this.fillWithBlocks(world, box, 4, 8, 12, 5, 8, 13, (Block)Blocks.field_150376_bx);
            this.fillWithRandomizedBlocks(world, box, 3, 7, 4, 3, 7, 6, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 3, 7, 10, 3, 7, 13, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 2, 6, 4, 2, 6, 13, rand, roofStairs);
            this.fillWithRandomizedBlocks(world, box, 1, 5, 4, 1, 5, 13, rand, roofStairs);
            int metaN = this.getDecoMeta(3);
            int metaE = this.getDecoMeta(4);
            this.randomlyFillWithBlocks(world, box, rand, 0.05f, 12, 3, 3, 12, 3, 8, Blocks.field_150321_G);
            this.randomlyFillWithBlocks(world, box, rand, 0.05f, 10, 4, 3, 11, 4, 8, Blocks.field_150321_G);
            this.randomlyFillWithBlocks(world, box, rand, 0.05f, 5, 3, 2, 8, 3, 2, Blocks.field_150321_G);
            this.randomlyFillWithBlocks(world, box, rand, 0.05f, 5, 3, 3, 9, 3, 8, Blocks.field_150321_G);
            this.randomlyFillWithBlocks(world, box, rand, 0.05f, 2, 3, 5, 4, 3, 8, Blocks.field_150321_G);
            this.randomlyFillWithBlocks(world, box, rand, 0.05f, 2, 3, 10, 7, 3, 12, Blocks.field_150321_G);
            this.placeDoor(world, box, Blocks.field_150466_ao, 1, false, false, 11, 1, 2);
            this.placeDoor(world, box, Blocks.field_150466_ao, 1, false, rand.nextBoolean(), 4, 1, 9);
            this.placeDoor(world, box, Blocks.field_150466_ao, 2, false, rand.nextBoolean(), 8, 1, 11);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 6, 2, 1, 7, 3, 1, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 13, 2, 5, 13, 2, 6, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 10, 2, 9, 11, 3, 9, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 4, 2, 13, 5, 3, 13, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 1, 2, 11, 1, 2, 11, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 1, 2, 6, 1, 2, 7, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 4, 6, 4, 5, 6, 4, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.5f, 4, 6, 13, 5, 6, 13, Blocks.field_150410_aZ);
            this.func_151550_a(world, Blocks.field_150415_aT, this.getDecoModelMeta(4) >> 2, 6, 4, 10, box);
            this.fillWithMetadataBlocks(world, box, 6, 2, 10, 6, 3, 10, Blocks.field_150468_ap, metaN);
            this.func_151550_a(world, Blocks.field_150476_ad, stairN | 4, 12, 1, 5, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 8, 12, 1, 6, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairS | 4, 12, 1, 7, box);
            this.fillWithMetadataBlocks(world, box, 9, 1, 4, 9, 1, 5, Blocks.field_150401_cl, stairE | 4);
            this.fillWithMetadataBlocks(world, box, 8, 1, 4, 8, 1, 5, (Block)Blocks.field_150376_bx, 13);
            this.fillWithMetadataBlocks(world, box, 7, 1, 4, 7, 1, 5, Blocks.field_150401_cl, stairW | 4);
            this.func_151550_a(world, Blocks.field_150401_cl, stairS | 4, 8, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150401_cl, stairW, 7, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150401_cl, stairS, 6, 1, 2, box);
            this.fillWithMetadataBlocks(world, box, 5, 1, 2, 5, 1, 3, Blocks.field_150401_cl, stairE);
            this.func_151550_a(world, Blocks.field_150401_cl, stairN, 5, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairW, 10, 1, 5, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairN, 8, 1, 6, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairE, 9, 1, 8, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairE | 4, 9, 2, 8, box);
            this.fillWithBlocks(world, box, 8, 1, 8, 8, 2, 8, Blocks.field_150342_X);
            this.func_151550_a(world, Blocks.field_150476_ad, stairW, 7, 1, 8, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairW | 4, 7, 2, 8, box);
            this.fillWithMetadataBlocks(world, box, 7, 3, 8, 9, 3, 8, (Block)Blocks.field_150376_bx, 1);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 4, 1, 5, box);
            this.func_151550_a(world, rand.nextBoolean() ? ModBlocks.machine_electric_furnace_off : Blocks.field_150460_al, metaN, 3, 1, 5, box);
            this.fillWithBlocks(world, box, 2, 1, 5, 2, 1, 6, (Block)Blocks.field_150334_T);
            this.func_151550_a(world, (Block)Blocks.field_150383_bp, 2, 2, 1, 7, box);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 2, 1, 8, box);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 4, 3, 5, box);
            this.func_151550_a(world, Blocks.field_150379_bu, 0, 3, 3, 5, box);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 2, 3, 5, box);
            this.func_151550_a(world, ModBlocks.steel_wall, metaN, 3, 3, 6, box);
            this.func_151550_a(world, ModBlocks.radiorec, this.getDecoMeta(2), 8, 2, 2, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 7, 2, 4, box);
            this.fillWithBlocks(world, box, 2, 1, 12, 3, 1, 12, Blocks.field_150342_X);
            this.func_151550_a(world, Blocks.field_150476_ad, stairE | 4, 4, 1, 12, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 8, 5, 1, 12, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairW | 4, 6, 1, 12, box);
            this.fillWithBlocks(world, box, 7, 1, 12, 7, 2, 12, Blocks.field_150342_X);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 5, 5, 1, 11, box);
            this.placeBed(world, box, 1, 3, 1, 10);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 4, 2, 12, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(0), 5, 2, 12, box);
            this.fillWithMetadataBlocks(world, box, 4, 5, 5, 5, 5, 5, Blocks.field_150401_cl, stairS | 4);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 1, 4, 5, 6, box);
            this.func_151550_a(world, ModBlocks.crate_can, 0, 7, 5, 7, box);
            this.func_151550_a(world, ModBlocks.crate_can, 0, 2, 5, 9, box);
            this.func_151550_a(world, ModBlocks.crate_can, 0, 3, 5, 11, box);
            if (rand.nextBoolean()) {
                this.func_151550_a(world, ModBlocks.machine_diesel, metaE, 7, 5, 9, box);
            }
            this.func_151550_a(world, rand.nextBoolean() ? ModBlocks.crate_weapon : ModBlocks.crate, 0, 6, 5, 12, box);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(2), 7, 1, 10, ItemPool.getPool("POOL_OFFICE_TRASH"), 4);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, metaE, 7, 5, 5, ItemPool.getPool("POOL_GENERIC"), 8);
            this.func_151550_a(world, ModBlocks.deco_loot, 0, 3, 2, 12, box);
            LootGenerator.lootBookLore(world, this.func_74865_a(3, 12), this.func_74862_a(2), this.func_74873_b(3, 12), HbmChestContents.generateLabBook(rand));
            this.func_151550_a(world, ModBlocks.deco_loot, 0, 5, 6, 5, box);
            LootGenerator.lootMakeshiftGun(world, this.func_74865_a(5, 5), this.func_74862_a(6), this.func_74873_b(5, 5));
            this.placeRandomBobble(world, box, rand, 5, 5, 12);
            return true;
        }

        public static class BrokenBlocks
        extends StructureComponent.BlockSelector {
            public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
                float chance = rand.nextFloat();
                if ((double)chance < 0.6) {
                    this.field_151562_a = Blocks.field_150344_f;
                    this.field_75065_b = 0;
                } else if ((double)chance < 0.8) {
                    this.field_151562_a = Blocks.field_150476_ad;
                    this.field_75065_b = rand.nextInt(4);
                } else {
                    this.field_151562_a = Blocks.field_150376_bx;
                    this.field_75065_b = 0;
                }
            }
        }

        public static class BrokenStairs
        extends StructureComponent.BlockSelector {
            public void setMetadata(int meta) {
                this.field_75065_b = meta;
            }

            public int func_75064_b() {
                return this.field_151562_a instanceof BlockStairs ? this.field_75065_b : 0;
            }

            public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
                float chance = rand.nextFloat();
                this.field_151562_a = (double)chance < 0.7 ? Blocks.field_150476_ad : ((double)chance < 0.97 ? Blocks.field_150376_bx : Blocks.field_150350_a);
            }
        }
    }

    public static class NTMLab2
    extends Component {
        private static Component.SuperConcrete RandomSuperConcrete = new Component.SuperConcrete();
        private static Component.ConcreteBricks RandomConcreteBricks = new Component.ConcreteBricks();
        private static Component.LabTiles RandomLabTiles = new Component.LabTiles();
        private boolean[] hasPlacedLoot = new boolean[2];

        public NTMLab2() {
        }

        public NTMLab2(Random rand, int minX, int minZ) {
            super(rand, minX, 64, minZ, 12, 11, 8);
            this.hasPlacedLoot[0] = false;
            this.hasPlacedLoot[1] = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot1", this.hasPlacedLoot[0]);
            nbt.func_74757_a("hasLoot2", this.hasPlacedLoot[1]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot[0] = nbt.func_74767_n("hasLoot1");
            this.hasPlacedLoot[1] = nbt.func_74767_n("hasLoot2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.field_74887_e.func_78886_a(0, -7, 0);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 0, 12, 6, 6, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 7, 6, 8, 6, box);
            if (this.func_151548_a(world, 9, 7, 7, box).func_149688_o().func_76222_j() || this.func_151548_a(world, 9, 7, 7, box) == Blocks.field_150350_a) {
                int stairMeta = this.func_151555_a(Blocks.field_150390_bg, 2);
                this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 9, 7, 10, 7, 7, box);
                this.func_151556_a(world, box, 9, 7, 7, 10, 7, 7, Blocks.field_150390_bg, stairMeta, Blocks.field_150350_a, 0, false);
            }
            this.func_74878_a(world, box, 1, 7, 1, 11, 11, 5);
            this.func_74878_a(world, box, 1, 7, 6, 5, 11, 7);
            this.func_74878_a(world, box, 9, 8, 6, 10, 9, 6);
            this.func_74878_a(world, box, 5, 5, 1, 6, 6, 2);
            this.func_74878_a(world, box, 2, 0, 2, 10, 3, 6);
            this.func_74882_a(world, box, 0, 7, 0, 12, 11, 0, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 0, 7, 0, 0, 11, 8, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 1, 7, 8, 5, 7, 8, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 1, 8, 8, 1, 10, 8, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 2, 7, 8, 2, 10, 8, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 3, 8, 8, 3, 10, 8, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 4, 7, 8, 4, 10, 8, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 5, 8, 8, 5, 10, 8, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, 11, 8, 5, 11, 8, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 6, 7, 7, 6, 11, 8, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 6, 7, 6, 7, 9, 6, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 6, 10, 6, 7, 10, 6, ModBlocks.concrete_super_broken, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 8, 7, 6, 12, 7, 6, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 8, 8, 6, 8, 11, 6, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 9, 10, 6, 10, 11, 6, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 11, 7, 6, 12, 11, 6, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 12, 7, 1, 12, 7, 5, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 12, 8, 5, 12, 10, 5, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 12, 8, 4, 12, 10, 4, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 12, 8, 3, 12, 10, 3, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 12, 8, 2, 12, 10, 2, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 12, 8, 1, 12, 10, 1, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 12, 11, 1, 12, 11, 5, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 1, 0, 1, 11, 3, 1, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, 0, 2, 1, 3, 6, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, 0, 7, 11, 3, 7, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 11, 0, 2, 11, 3, 6, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 6, 0, 3, 6, 3, 6, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, 7, 1, 3, 7, 7, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 4, 7, 6, 5, 7, 7, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 8, 7, 1, 11, 7, 5, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 9, 7, 6, 10, 7, 6, false, rand, RandomLabTiles);
            this.func_151549_a(world, box, 4, 7, 1, 7, 7, 1, ModBlocks.tile_lab_broken, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.tile_lab_broken, 0, 4, 7, 2, box);
            this.func_151549_a(world, box, 4, 7, 3, 4, 7, 5, ModBlocks.tile_lab_cracked, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.tile_lab_broken, 0, 5, 7, 3, box);
            this.func_151549_a(world, box, 5, 7, 4, 5, 7, 5, ModBlocks.tile_lab_cracked, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.tile_lab_broken, 0, 6, 7, 4, box);
            this.func_151550_a(world, ModBlocks.tile_lab_cracked, 0, 6, 7, 5, box);
            this.func_151549_a(world, box, 7, 7, 2, 7, 7, 3, ModBlocks.tile_lab_broken, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 7, 7, 4, 7, 7, 5, ModBlocks.tile_lab_cracked, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, 11, 1, 2, 11, 7, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 11, 6, 4, 11, 7, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 9, 11, 1, 11, 11, 5, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 11, 1, 8, 11, 1, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 11, 2, 4, 11, 2, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 7, 11, 2, 8, 11, 2, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 11, 3, 3, 11, 5, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 4, 11, 4, 4, 11, 5, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 5, 11, 6, 5, 11, 7, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 8, 11, 3, 8, 11, 5, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 2, 0, 2, 5, 0, 6, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 6, 0, 2, 6, 0, 3, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 7, 0, 2, 10, 0, 6, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 1, 4, 1, 11, 4, 7, false, rand, RandomConcreteBricks);
            int eastMeta = this.getDecoMeta(4);
            int westMeta = this.getDecoMeta(5);
            int northMeta = this.getDecoMeta(3);
            int southMeta = this.getDecoMeta(2);
            this.func_151550_a(world, ModBlocks.crashed_balefire, southMeta, 6, 9, 3, box);
            int doorMeta = this.func_151555_a(Blocks.field_150466_ao, 1);
            this.func_151550_a(world, ModBlocks.door_office, doorMeta, 9, 8, 6, box);
            ItemDoor.func_150924_a((World)world, (int)this.func_74865_a(9, 6), (int)this.func_74862_a(8), (int)this.func_74873_b(9, 6), (int)doorMeta, (Block)ModBlocks.door_office);
            this.func_151550_a(world, ModBlocks.door_office, doorMeta, 10, 8, 6, box);
            ItemDoor.func_150924_a((World)world, (int)this.func_74865_a(10, 6), (int)this.func_74862_a(8), (int)this.func_74873_b(10, 6), (int)doorMeta, (Block)ModBlocks.door_office);
            this.func_151549_a(world, box, 1, 8, 1, 1, 10, 1, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 1, 8, 2, 1, 9, 3, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.tape_recorder, westMeta, 1, 10, 2, box);
            this.func_151550_a(world, ModBlocks.steel_beam, 0, 1, 10, 3, box);
            this.func_151549_a(world, box, 1, 8, 6, 1, 10, 6, ModBlocks.deco_pipe_framed_rusted, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 8, 8, 1, 8, 10, 1, ModBlocks.steel_wall, eastMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 9, 10, 1, 10, 10, 1, ModBlocks.steel_grate, 0, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 9, 9, 1, 10, 9, 1, ModBlocks.tape_recorder, northMeta, Blocks.field_150350_a, 0, false);
            this.func_151549_a(world, box, 9, 8, 1, 10, 8, 1, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 11, 8, 1, 11, 10, 1, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 2, 1, 2, 2, 1, 6, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.vitrified_barrel, 0, 2, 2, 2, box);
            this.func_151556_a(world, box, 3, 1, 2, 3, 3, 2, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, 1, 4, 3, 3, 4, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, 1, 6, 3, 3, 6, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.crate, 0, 4, 1, 6, box);
            this.func_151550_a(world, ModBlocks.crate_lead, 0, 4, 2, 6, box);
            if (!this.hasPlacedLoot[0]) {
                this.hasPlacedLoot[0] = this.generateInvContents(world, box, rand, ModBlocks.crate_iron, 5, 1, 6, ItemPool.getPool("POOL_NUKE_FUEL"), 10);
            }
            this.func_151549_a(world, box, 4, 1, 5, 5, 1, 5, ModBlocks.crate_lead, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 7, 1, 6, 7, 3, 6, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 8, 1, 6, 10, 1, 6, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 8, 2, 6, 9, 2, 6, ModBlocks.tape_recorder, southMeta, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.steel_beam, 0, 10, 2, 6, box);
            this.func_151549_a(world, box, 8, 3, 6, 10, 3, 6, ModBlocks.steel_roof, Blocks.field_150350_a, false);
            if (!this.hasPlacedLoot[1]) {
                this.hasPlacedLoot[1] = this.generateInvContents(world, box, rand, ModBlocks.crate_iron, 10, 1, 3, ItemPool.getPool("POOL_NUKE_TRASH"), 9);
                if (rand.nextInt(2) == 0) {
                    this.generateLoreBook(world, box, 10, 1, 3, 1, HbmChestContents.generateOfficeBook(rand));
                }
            }
            return true;
        }
    }

    public static class NTMLab1
    extends Component {
        private static Component.ConcreteBricks RandomConcreteBricks = new Component.ConcreteBricks();
        private static Component.LabTiles RandomLabTiles = new Component.LabTiles();
        private boolean[] hasPlacedLoot = new boolean[2];

        public NTMLab1() {
        }

        public NTMLab1(Random rand, int minX, int minZ) {
            super(rand, minX, 64, minZ, 9, 4, 7);
            this.hasPlacedLoot[0] = false;
            this.hasPlacedLoot[1] = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot1", this.hasPlacedLoot[0]);
            nbt.func_74757_a("hasLoot2", this.hasPlacedLoot[1]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot[0] = nbt.func_74767_n("hasLoot1");
            this.hasPlacedLoot[1] = nbt.func_74767_n("hasLoot2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 0, 9, 5, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 3, 6, 9, 7, -1, box);
            if (this.func_151548_a(world, 2, 0, 6, box).func_149688_o().func_76222_j() || this.func_151548_a(world, 2, 0, 6, box) == Blocks.field_150350_a) {
                this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 2, 6, 2, 6, -1, box);
                this.func_151550_a(world, Blocks.field_150390_bg, this.getStairMeta(0), 2, 0, 6, box);
            }
            this.func_74878_a(world, box, 1, 0, 1, 8, 4, 4);
            this.func_74878_a(world, box, 4, 0, 4, 8, 4, 6);
            this.func_74878_a(world, box, 3, 1, 6, 3, 2, 6);
            int pillarMeta = this.getPillarMeta(8);
            this.func_151549_a(world, box, 0, 0, 0, 0, 3, 0, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 9, 0, 0, 9, 3, 0, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 0, 0, 1, 0, 0, 4, ModBlocks.concrete_pillar, pillarMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 9, 0, 1, 9, 0, 6, ModBlocks.concrete_pillar, pillarMeta, Blocks.field_150350_a, 0, false);
            this.func_151549_a(world, box, 0, 0, 5, 0, 3, 5, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 0, 5, 3, 3, 5, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 0, 7, 3, 3, 7, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 9, 0, 7, 9, 3, 7, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, 0, 0, 8, 3, 0, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 0, 4, 0, 9, 4, 0, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 0, 1, 1, 0, 3, 4, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 0, 4, 0, 0, 4, 5, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 1, 0, 5, 2, 4, 5, false, rand, RandomConcreteBricks);
            this.func_151550_a(world, ModBlocks.brick_concrete_broken, 0, 3, 4, 5, box);
            this.func_74882_a(world, box, 3, 3, 6, 3, 4, 6, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 4, 0, 7, 8, 1, 7, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 4, 2, 7, 4, 3, 7, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 8, 2, 7, 8, 3, 7, false, rand, RandomConcreteBricks);
            this.func_151551_a(world, box, rand, 0.75f, 5, 2, 7, 7, 3, 7, Blocks.field_150410_aZ, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 3, 4, 7, 9, 4, 7, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 9, 1, 1, 9, 4, 6, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 1, 0, 1, 8, 0, 4, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 4, 0, 5, 8, 0, 6, false, rand, RandomLabTiles);
            this.func_151550_a(world, ModBlocks.tile_lab_cracked, 0, 3, 0, 6, box);
            this.func_151549_a(world, box, 1, 3, 1, 1, 4, 4, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 2, 4, 1, 8, 4, 4, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 4, 4, 5, 8, 4, 6, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 1, 1, 1, 1, 1, 4, Blocks.field_150346_d, 2, Blocks.field_150350_a, 0, false);
            int westDecoMeta = this.getDecoMeta(5);
            this.func_151556_a(world, box, 2, 1, 1, 2, 1, 4, ModBlocks.steel_wall, westDecoMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 2, 3, 1, 2, 3, 4, ModBlocks.steel_wall, westDecoMeta, Blocks.field_150350_a, 0, false);
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                this.func_151550_a(world, ModBlocks.plant_flower, i, 1, 2, 1 + i, box);
            }
            int doorMeta = this.func_151555_a(Blocks.field_150466_ao, 2);
            this.func_151550_a(world, ModBlocks.door_office, doorMeta, 3, 1, 6, box);
            ItemDoor.func_150924_a((World)world, (int)this.func_74865_a(3, 6), (int)this.func_74862_a(1), (int)this.func_74873_b(3, 6), (int)doorMeta, (Block)ModBlocks.door_office);
            int northDecoMeta = this.getDecoMeta(3);
            this.func_151556_a(world, box, 5, 3, 1, 8, 3, 1, ModBlocks.steel_scaffold, westDecoMeta < 4 ? 0 : 8, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 5, 3, 2, 8, 3, 2, ModBlocks.steel_wall, northDecoMeta, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.machine_electric_furnace_off, northDecoMeta, 5, 1, 1, box);
            this.func_151550_a(world, ModBlocks.machine_microwave, northDecoMeta, 5, 2, 1, box);
            this.func_151550_a(world, ModBlocks.deco_titanium, 0, 6, 1, 1, box);
            this.func_151550_a(world, ModBlocks.machine_shredder, 0, 7, 1, 1, box);
            this.func_151550_a(world, ModBlocks.deco_titanium, 0, 8, 1, 1, box);
            this.func_151549_a(world, box, 5, 1, 3, 8, 1, 3, ModBlocks.deco_titanium, Blocks.field_150350_a, false);
            if (!this.hasPlacedLoot[0]) {
                this.func_151550_a(world, ModBlocks.deco_loot, 0, 6, 2, 3, box);
                LootGenerator.lootMedicine(world, this.func_74865_a(6, 3), this.func_74862_a(2), this.func_74873_b(6, 3));
                this.hasPlacedLoot[0] = true;
            }
            this.func_151550_a(world, ModBlocks.crate_can, 0, 8, 1, 5, box);
            if (!this.hasPlacedLoot[1]) {
                this.hasPlacedLoot[1] = this.generateInvContents(world, box, rand, ModBlocks.crate_iron, 8, 1, 6, ItemPool.getPool("POOL_GENERIC"), 8);
            }
            return true;
        }
    }

    public static class NTMHouse2
    extends Component {
        private static Component.Sandstone RandomSandstone = new Component.Sandstone();
        private boolean[] hasPlacedLoot = new boolean[2];

        public NTMHouse2() {
        }

        public NTMHouse2(Random rand, int minX, int minZ) {
            super(rand, minX, 64, minZ, 15, 5, 9);
            this.hasPlacedLoot[0] = false;
            this.hasPlacedLoot[1] = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot1", this.hasPlacedLoot[0]);
            nbt.func_74757_a("hasLoot2", this.hasPlacedLoot[1]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot[0] = nbt.func_74767_n("hasLoot1");
            this.hasPlacedLoot[1] = nbt.func_74767_n("hasLoot2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.placeFoundationUnderneath(world, Blocks.field_150322_A, 0, 0, 0, 6, 15, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150322_A, 0, 9, 0, 15, 9, -1, box);
            this.func_74878_a(world, box, 1, 0, 1, 5, 5, 8);
            this.func_74882_a(world, box, 0, 0, 0, 6, 1, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 2, 0, 1, 2, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 2, 0, box);
            this.func_74882_a(world, box, 3, 2, 0, 3, 2, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 2, 0, box);
            this.func_74882_a(world, box, 5, 2, 0, 6, 2, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 3, 0, 6, 3, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 0, 1, 0, 3, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 0, 9, 6, 1, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 2, 9, 1, 2, 9, false, rand, RandomSandstone);
            this.func_151549_a(world, box, 2, 2, 9, 4, 2, 9, Blocks.field_150422_aJ, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 5, 2, 9, 6, 2, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 3, 9, 6, 3, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 0, 8, 6, 3, 8, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 0, 7, 6, 0, 7, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 3, 7, 6, 3, 7, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 0, 1, 6, 3, 6, false, rand, RandomSandstone);
            this.func_151549_a(world, box, 1, 0, 1, 5, 0, 8, Blocks.field_150322_A, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, 4, 0, 5, 4, 9, Blocks.field_150322_A, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 0, 4, 0, 0, 4, 9, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 6, 4, 0, 6, 4, 9, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 2, 5, 0, 4, 5, 0, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, 5, 1, 3, 5, 2, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, 5, 4, 3, 5, 6, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 3, 5, 8, box);
            this.func_151556_a(world, box, 2, 5, 9, 4, 5, 9, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, 9, 0, 0, 15, 0, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 9, 1, 0, 13, 1, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 9, 2, 0, 9, 2, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 9, 2, 0, box);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 12, 2, 0, box);
            this.func_74882_a(world, box, 9, 0, 1, 9, 3, 1, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 9, 0, 2, 9, 0, 2, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 9, 3, 2, 9, 3, 8, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 9, 4, 2, box);
            this.func_151556_a(world, box, 9, 4, 4, 9, 4, 7, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, 9, 0, 3, 9, 1, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 9, 0, 2, 9, 0, 2, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 9, 2, 3, 9, 2, 3, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 2, 4, box);
            this.func_74882_a(world, box, 9, 2, 5, 9, 2, 5, false, rand, RandomSandstone);
            this.func_151549_a(world, box, 9, 2, 6, 9, 2, 7, Blocks.field_150422_aJ, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 9, 2, 8, 9, 2, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 10, 0, 9, 15, 1, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 10, 2, 9, 10, 2, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 14, 2, 9, 15, 2, 9, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 15, 0, 1, 15, 0, 8, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 15, 1, 3, 15, 1, 3, false, rand, RandomSandstone);
            this.func_151556_a(world, box, 15, 1, 4, 15, 1, 5, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, 15, 1, 8, 15, 1, 6, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 15, 1, 8, box);
            this.func_151549_a(world, box, 10, 0, 1, 14, 0, 8, Blocks.field_150322_A, Blocks.field_150350_a, false);
            int eastMeta = this.getDecoMeta(4);
            this.func_151550_a(world, ModBlocks.machine_boiler_off, 4, 1, 1, 1, box);
            this.func_151549_a(world, box, 1, 2, 1, 1, 3, 1, ModBlocks.deco_pipe_quad_rusted, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.deco_pipe_rim_rusted, 0, 1, 5, 1, box);
            this.func_151550_a(world, ModBlocks.crate, 0, 2, 1, 3, box);
            this.func_151550_a(world, ModBlocks.crate_can, 0, 1, 1, 5, box);
            if (!this.hasPlacedLoot[0]) {
                this.func_151550_a(world, (Block)Blocks.field_150486_ae, this.func_151555_a((Block)Blocks.field_150486_ae, 3), 1, 1, 7, box);
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ItemPool.getPool("POOL_MACHINE_PARTS"), (IInventory)((TileEntityChest)world.func_147438_o(this.func_74865_a(1, 7), this.func_74862_a(1), this.func_74873_b(1, 7))), (int)10);
                this.hasPlacedLoot[0] = true;
            }
            this.func_151549_a(world, box, 4, 1, 8, 5, 1, 8, ModBlocks.crate, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 5, 1, 4, 5, 3, 4, ModBlocks.steel_scaffold, eastMeta < 4 ? 0 : 8, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 5, 1, 6, 5, 3, 6, ModBlocks.steel_scaffold, eastMeta < 4 ? 0 : 8, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.steel_grate, 7, 5, 1, 5, box);
            this.func_151550_a(world, ModBlocks.crate_weapon, 0, 5, 2, 5, box);
            if (!this.hasPlacedLoot[1]) {
                this.func_151550_a(world, (Block)Blocks.field_150486_ae, this.func_151555_a((Block)Blocks.field_150486_ae, 3), 10, 1, 1, box);
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ItemPool.getPool("POOL_ANTENNA"), (IInventory)((TileEntityChest)world.func_147438_o(this.func_74865_a(10, 1), this.func_74862_a(1), this.func_74873_b(10, 1))), (int)10);
                this.hasPlacedLoot[1] = true;
            }
            this.func_151550_a(world, ModBlocks.bobblehead, rand.nextInt(16), 10, 1, 4, box);
            BlockBobble.TileEntityBobble bobble = (BlockBobble.TileEntityBobble)world.func_147438_o(this.func_74865_a(10, 4), this.func_74862_a(1), this.func_74873_b(10, 4));
            if (bobble != null) {
                bobble.type = BlockBobble.BobbleType.values()[rand.nextInt(BlockBobble.BobbleType.values().length - 1) + 1];
                bobble.func_70296_d();
            }
            this.func_151551_a(world, box, rand, 0.25f, 11, 1, 1, 14, 1, 8, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            return true;
        }
    }

    public static class NTMHouse1
    extends Component {
        private boolean hasPlacedChest;
        private static Component.Sandstone RandomSandstone = new Component.Sandstone();

        public NTMHouse1() {
        }

        public NTMHouse1(Random rand, int minX, int minZ) {
            super(rand, minX, 64, minZ, 9, 4, 6);
            this.hasPlacedChest = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasChest", this.hasPlacedChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedChest = nbt.func_74767_n("hasChest");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.placeFoundationUnderneath(world, Blocks.field_150322_A, 0, 0, 0, 9, 6, -1, box);
            this.func_74882_a(world, box, 0, 0, 0, 9, 0, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 1, 0, 1, 1, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 1, 0, box);
            this.func_74882_a(world, box, 3, 1, 0, 5, 1, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 1, 0, box);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 1, 0, box);
            this.func_74882_a(world, box, 8, 1, 0, 9, 1, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 2, 0, 7, 2, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 0, 0, 0, 1, 6, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 0, 2, 1, box);
            this.func_151556_a(world, box, 0, 2, 3, 0, 2, 6, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, 1, 0, 6, 1, 1, 6, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 3, 0, 6, 9, 1, 6, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 2, 6, 3, 2, 6, false, rand, RandomSandstone);
            this.func_151556_a(world, box, 4, 2, 6, 5, 2, 6, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 7, 2, 6, box);
            this.func_74882_a(world, box, 9, 0, 0, 9, 0, 6, false, rand, RandomSandstone);
            this.func_151551_a(world, box, rand, 0.65f, 9, 1, 1, 9, 1, 5, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 4, 0, 1, 4, 1, 3, false, rand, RandomSandstone);
            this.func_151550_a(world, ModBlocks.reinforced_sand, 0, 4, 0, 4, box);
            this.func_151550_a(world, ModBlocks.crate_weapon, 0, 1, 0, 1, box);
            if (!this.hasPlacedChest) {
                this.hasPlacedChest = this.func_74879_a(world, box, rand, 3, 0, 1, ItemPool.getPool("POOL_GENERIC"), rand.nextInt(2) + 8);
            }
            this.func_151549_a(world, box, 5, 0, 1, 6, 0, 1, ModBlocks.crate, Blocks.field_150350_a, false);
            this.func_151550_a(world, (Block)Blocks.field_150354_m, 0, 7, 0, 1, box);
            if ((double)rand.nextFloat() <= 0.25) {
                this.func_151550_a(world, ModBlocks.crate_metal, 0, 8, 0, 1, box);
            }
            this.func_151551_a(world, box, rand, 0.25f, 1, 0, 2, 3, 0, 5, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            this.func_151551_a(world, box, rand, 0.25f, 5, 0, 2, 8, 0, 5, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            return true;
        }
    }
}

