/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.entity.IResistanceProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.EntityDamageUtil;
import com.hbm.util.Tuple;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DamageResistanceHandler {
    public static float currentPDT = 0.0f;
    public static float currentPDR = 0.0f;
    public static final String CATEGORY_EXPLOSION = "EXPL";
    public static final String CATEGORY_FIRE = "FIRE";
    public static final String CATEGORY_PHYSICAL = "PHYS";
    public static final String CATEGORY_ENERGY = "EN";
    public static final Gson gson = new Gson();
    public static HashMap<Item, ResistanceStats> itemStats = new HashMap();
    public static HashMap<Tuple.Quartet<Item, Item, Item, Item>, ResistanceStats> setStats = new HashMap();
    public static HashMap<Class<? extends Entity>, ResistanceStats> entityStats = new HashMap();
    public static HashMap<Item, List<Tuple.Quartet<Item, Item, Item, Item>>> itemInfoSet = new HashMap();

    public static void init() {
        File folder = MainRegistry.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmArmor.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmArmor.json");
        DamageResistanceHandler.clearSystem();
        if (!config.exists()) {
            DamageResistanceHandler.initDefaults();
            DamageResistanceHandler.writeDefault(template);
        } else {
            DamageResistanceHandler.readConfig(config);
        }
    }

    private static void clearSystem() {
        itemStats.clear();
        setStats.clear();
        entityStats.clear();
        itemInfoSet.clear();
    }

    private static void writeDefault(File file) {
        MainRegistry.logger.info("No armor file found, registering defaults for " + file.getName());
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("comment").value("Template file, remove the underscore ('_') from the name to enable the config.");
            DamageResistanceHandler.serialize(writer);
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readConfig(File file) {
        MainRegistry.logger.info("Reading armor file " + file.getName());
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            DamageResistanceHandler.deserialize(json);
        }
        catch (FileNotFoundException ex) {
            DamageResistanceHandler.clearSystem();
            DamageResistanceHandler.initDefaults();
            ex.printStackTrace();
        }
    }

    public static void initDefaults() {
        entityStats.put(EntityCreeper.class, new ResistanceStats().addCategory(CATEGORY_EXPLOSION, 2.0f, 0.25f));
        itemStats.put(ModItems.jackt, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 5.0f, 0.5f));
        itemStats.put(ModItems.jackt2, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 5.0f, 0.5f));
        DamageResistanceHandler.registerSet(ModItems.steel_helmet, ModItems.steel_plate, ModItems.steel_legs, ModItems.steel_boots, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.titanium_helmet, ModItems.titanium_plate, ModItems.titanium_legs, ModItems.titanium_boots, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.alloy_helmet, ModItems.alloy_plate, ModItems.alloy_legs, ModItems.alloy_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.cobalt_helmet, ModItems.cobalt_plate, ModItems.cobalt_legs, ModItems.cobalt_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.starmetal_helmet, ModItems.starmetal_plate, ModItems.starmetal_legs, ModItems.starmetal_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 3.0f, 0.25f).setOther(1.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.zirconium_legs, ModItems.zirconium_legs, ModItems.zirconium_legs, ModItems.zirconium_legs, new ResistanceStats().setOther(0.0f, 1.0f));
        DamageResistanceHandler.registerSet(ModItems.dnt_helmet, ModItems.dnt_plate, ModItems.dnt_legs, ModItems.dnt_boots, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.cmb_helmet, ModItems.cmb_plate, ModItems.cmb_legs, ModItems.cmb_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 5.0f, 0.5f).setOther(5.0f, 0.25f));
        DamageResistanceHandler.registerSet(ModItems.schrabidium_helmet, ModItems.schrabidium_plate, ModItems.schrabidium_legs, ModItems.schrabidium_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 10.0f, 0.65f).setOther(5.0f, 0.5f));
        DamageResistanceHandler.registerSet(ModItems.robes_helmet, ModItems.robes_plate, ModItems.robes_legs, ModItems.robes_boots, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.security_helmet, ModItems.security_plate, ModItems.security_legs, ModItems.security_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 5.0f, 0.5f).addCategory(CATEGORY_EXPLOSION, 2.0f, 0.25f));
        DamageResistanceHandler.registerSet(ModItems.steamsuit_helmet, ModItems.steamsuit_plate, ModItems.steamsuit_legs, ModItems.steamsuit_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.5f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 5.0f, 0.25f).setOther(0.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.dieselsuit_helmet, ModItems.dieselsuit_plate, ModItems.dieselsuit_legs, ModItems.dieselsuit_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 1.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.5f, 0.5f).addCategory(CATEGORY_EXPLOSION, 2.0f, 0.15f).setOther(0.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.t45_helmet, ModItems.t45_plate, ModItems.t45_legs, ModItems.t45_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.5f, 0.35f).addCategory(CATEGORY_EXPLOSION, 5.0f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(0.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.t51_helmet, ModItems.t51_plate, ModItems.t51_legs, ModItems.t51_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.5f, 0.35f).addCategory(CATEGORY_EXPLOSION, 5.0f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(0.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.ajr_helmet, ModItems.ajr_plate, ModItems.ajr_legs, ModItems.ajr_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 4.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.5f, 0.35f).addCategory(CATEGORY_EXPLOSION, 7.5f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(0.0f, 0.15f));
        DamageResistanceHandler.registerSet(ModItems.ajro_helmet, ModItems.ajro_plate, ModItems.ajro_legs, ModItems.ajro_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 4.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.5f, 0.35f).addCategory(CATEGORY_EXPLOSION, 7.5f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(0.0f, 0.15f));
        DamageResistanceHandler.registerSet(ModItems.rpa_helmet, ModItems.rpa_plate, ModItems.rpa_legs, ModItems.rpa_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 25.0f, 0.65f).addCategory(CATEGORY_FIRE, 10.0f, 0.9f).addCategory(CATEGORY_EXPLOSION, 15.0f, 0.25f).addCategory(CATEGORY_ENERGY, 25.0f, 0.75f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(15.0f, 0.3f));
        ResistanceStats bj = new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 5.0f, 0.5f).addCategory(CATEGORY_FIRE, 2.5f, 0.5f).addCategory(CATEGORY_EXPLOSION, 10.0f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(2.0f, 0.15f);
        DamageResistanceHandler.registerSet(ModItems.bj_helmet, ModItems.bj_plate, ModItems.bj_legs, ModItems.bj_boots, bj);
        DamageResistanceHandler.registerSet(ModItems.bj_helmet, ModItems.bj_plate_jetpack, ModItems.bj_legs, ModItems.bj_boots, bj);
        DamageResistanceHandler.registerSet(ModItems.envsuit_helmet, ModItems.envsuit_plate, ModItems.envsuit_legs, ModItems.envsuit_boots, new ResistanceStats().addCategory(CATEGORY_FIRE, 2.0f, 0.75f).addExact(DamageSource.field_76369_e.field_76373_n, 0.0f, 1.0f).addExact(DamageSource.field_76379_h.field_76373_n, 5.0f, 0.75f).setOther(0.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.hev_helmet, ModItems.hev_plate, ModItems.hev_legs, ModItems.hev_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.25f).addCategory(CATEGORY_FIRE, 0.5f, 0.5f).addCategory(CATEGORY_EXPLOSION, 5.0f, 0.25f).addExact(DamageSource.field_76370_b.field_76373_n, 0.0f, 1.0f).addExact(DamageSource.field_76379_h.field_76373_n, 10.0f, 0.0f).setOther(2.0f, 0.25f));
        DamageResistanceHandler.registerSet(ModItems.bismuth_helmet, ModItems.bismuth_plate, ModItems.bismuth_legs, ModItems.bismuth_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.15f).addCategory(CATEGORY_FIRE, 5.0f, 0.5f).addCategory(CATEGORY_EXPLOSION, 5.0f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(2.0f, 0.25f));
        DamageResistanceHandler.registerSet(ModItems.fau_helmet, ModItems.fau_plate, ModItems.fau_legs, ModItems.fau_boots, new ResistanceStats().addCategory(CATEGORY_EXPLOSION, 50.0f, 0.95f).addCategory(CATEGORY_FIRE, 0.0f, 1.0f).addExact(DamageClass.LASER.name(), 25.0f, 0.95f).addExact(DamageSource.field_76379_h.field_76373_n, 0.0f, 1.0f).setOther(100.0f, 0.99f));
        DamageResistanceHandler.registerSet(ModItems.dns_helmet, ModItems.dns_plate, ModItems.dns_legs, ModItems.dns_boots, new ResistanceStats().addCategory(CATEGORY_EXPLOSION, 100.0f, 0.99f).addCategory(CATEGORY_FIRE, 0.0f, 1.0f).setOther(1000.0f, 1.0f));
        DamageResistanceHandler.registerSet(ModItems.taurun_helmet, ModItems.taurun_plate, ModItems.taurun_legs, ModItems.taurun_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.0f, 0.25f).addCategory(CATEGORY_EXPLOSION, 0.0f, 0.25f).addExact(DamageSource.field_76379_h.field_76373_n, 4.0f, 0.5f).setOther(2.0f, 0.1f));
        DamageResistanceHandler.registerSet(ModItems.trenchmaster_helmet, ModItems.trenchmaster_plate, ModItems.trenchmaster_legs, ModItems.trenchmaster_boots, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 5.0f, 0.5f).addCategory(CATEGORY_FIRE, 5.0f, 0.5f).addCategory(CATEGORY_EXPLOSION, 5.0f, 0.25f).addExact(DamageClass.LASER.name(), 15.0f, 0.9f).addExact(DamageSource.field_76379_h.field_76373_n, 10.0f, 0.5f).setOther(5.0f, 0.25f));
        DamageResistanceHandler.registerSet(ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots, new ResistanceStats().setOther(1000000.0f, 1.0f));
        DamageResistanceHandler.registerSet(ModItems.hazmat_helmet, ModItems.hazmat_plate, ModItems.hazmat_legs, ModItems.hazmat_boots, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.hazmat_helmet_red, ModItems.hazmat_plate_red, ModItems.hazmat_legs_red, ModItems.hazmat_boots_red, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.hazmat_helmet_grey, ModItems.hazmat_plate_grey, ModItems.hazmat_legs_grey, ModItems.hazmat_boots_grey, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.liquidator_helmet, ModItems.liquidator_plate, ModItems.liquidator_legs, ModItems.liquidator_boots, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.hazmat_paa_helmet, ModItems.hazmat_paa_plate, ModItems.hazmat_paa_legs, ModItems.hazmat_paa_boots, new ResistanceStats());
        DamageResistanceHandler.registerSet(ModItems.asbestos_helmet, ModItems.asbestos_plate, ModItems.asbestos_legs, ModItems.asbestos_boots, new ResistanceStats().addCategory(CATEGORY_FIRE, 10.0f, 0.9f));
    }

    public static void registerSet(Item helmet, Item plate, Item legs, Item boots, ResistanceStats stats) {
        Tuple.Quartet<Item, Item, Item, Item> set = new Tuple.Quartet<Item, Item, Item, Item>(helmet, plate, legs, boots);
        setStats.put(set, stats);
        if (helmet != null) {
            DamageResistanceHandler.addToListInHashMap(helmet, itemInfoSet, set);
        }
        if (plate != null) {
            DamageResistanceHandler.addToListInHashMap(plate, itemInfoSet, set);
        }
        if (legs != null) {
            DamageResistanceHandler.addToListInHashMap(legs, itemInfoSet, set);
        }
        if (boots != null) {
            DamageResistanceHandler.addToListInHashMap(boots, itemInfoSet, set);
        }
    }

    public static void addToListInHashMap(Object key, HashMap map, Object listElement) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            map.put(key, list);
        }
        list.add(listElement);
    }

    public static void addInfo(ItemStack stack, List desc) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if (itemInfoSet.containsKey(stack.func_77973_b())) {
            List<Tuple.Quartet<Item, Item, Item, Item>> sets = itemInfoSet.get(stack.func_77973_b());
            for (Tuple.Quartet<Item, Item, Item, Item> set : sets) {
                ResistanceStats stats = setStats.get(set);
                if (stats == null) continue;
                ArrayList<String> toAdd = new ArrayList<String>();
                for (Map.Entry<String, Resistance> entry : stats.categoryResistances.entrySet()) {
                    toAdd.add(I18nUtil.resolveKey("damage.category." + entry.getKey(), new Object[0]) + ": " + entry.getValue().threshold + "/" + (int)(entry.getValue().resistance * 100.0f) + "%");
                }
                for (Map.Entry<String, Resistance> entry : stats.exactResistances.entrySet()) {
                    toAdd.add(I18nUtil.resolveKey("damage.exact." + entry.getKey(), new Object[0]) + ": " + entry.getValue().threshold + "/" + (int)(entry.getValue().resistance * 100.0f) + "%");
                }
                if (stats.otherResistance != null) {
                    toAdd.add(I18nUtil.resolveKey("damage.other", new Object[0]) + ": " + stats.otherResistance.threshold + "/" + (int)(stats.otherResistance.resistance * 100.0f) + "%");
                }
                if (toAdd.isEmpty()) break;
                desc.add(EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("damage.inset", new Object[0]));
                if (set.getW() != null) {
                    desc.add(EnumChatFormatting.DARK_PURPLE + "  " + new ItemStack(set.getW()).func_82833_r());
                }
                if (set.getX() != null) {
                    desc.add(EnumChatFormatting.DARK_PURPLE + "  " + new ItemStack(set.getX()).func_82833_r());
                }
                if (set.getY() != null) {
                    desc.add(EnumChatFormatting.DARK_PURPLE + "  " + new ItemStack(set.getY()).func_82833_r());
                }
                if (set.getZ() != null) {
                    desc.add(EnumChatFormatting.DARK_PURPLE + "  " + new ItemStack(set.getZ()).func_82833_r());
                }
                desc.addAll(toAdd);
                break;
            }
        }
        if (itemStats.containsKey(stack.func_77973_b())) {
            ResistanceStats stats = itemStats.get(stack.func_77973_b());
            ArrayList<String> toAdd = new ArrayList<String>();
            for (Map.Entry<String, Resistance> entry : stats.categoryResistances.entrySet()) {
                toAdd.add(I18nUtil.resolveKey("damage.category." + entry.getKey(), new Object[0]) + ": " + entry.getValue().threshold + "/" + (int)(entry.getValue().resistance * 100.0f) + "%");
            }
            for (Map.Entry<String, Resistance> entry : stats.exactResistances.entrySet()) {
                toAdd.add(I18nUtil.resolveKey("damage.exact." + entry.getKey(), new Object[0]) + ": " + entry.getValue().threshold + "/" + (int)(entry.getValue().resistance * 100.0f) + "%");
            }
            if (stats.otherResistance != null) {
                toAdd.add(I18nUtil.resolveKey("damage.other", new Object[0]) + ": " + stats.otherResistance.threshold + "/" + (int)(stats.otherResistance.resistance * 100.0f) + "%");
            }
            if (!toAdd.isEmpty()) {
                desc.add(EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("damage.item", new Object[0]));
                desc.addAll(toAdd);
            }
        }
    }

    public static void serialize(JsonWriter writer) throws IOException {
        writer.name("itemStats").beginArray();
        for (Map.Entry<Item, ResistanceStats> entry : itemStats.entrySet()) {
            writer.beginArray().setIndent("");
            writer.value(Item.field_150901_e.func_148750_c((Object)entry.getKey())).setIndent("  ");
            writer.beginObject();
            entry.getValue().serialize(writer);
            writer.setIndent("");
            writer.endObject().endArray().setIndent("  ");
        }
        writer.endArray();
        writer.name("setStats").beginArray();
        for (Map.Entry<Object, ResistanceStats> entry : setStats.entrySet()) {
            writer.beginArray().setIndent("");
            writer.value(Item.field_150901_e.func_148750_c(((Tuple.Quartet)entry.getKey()).getW())).value(Item.field_150901_e.func_148750_c(((Tuple.Quartet)entry.getKey()).getX())).value(Item.field_150901_e.func_148750_c(((Tuple.Quartet)entry.getKey()).getY())).value(Item.field_150901_e.func_148750_c(((Tuple.Quartet)entry.getKey()).getZ())).setIndent("  ");
            writer.beginObject();
            entry.getValue().serialize(writer);
            writer.setIndent("");
            writer.endObject().endArray().setIndent("  ");
        }
        writer.endArray();
        writer.name("entityStats").beginArray();
        for (Map.Entry<Object, ResistanceStats> entry : entityStats.entrySet()) {
            writer.beginArray().setIndent("");
            writer.value(((Class)entry.getKey()).getName()).setIndent("  ");
            writer.beginObject();
            entry.getValue().serialize(writer);
            writer.setIndent("");
            writer.endObject().endArray().setIndent("  ");
        }
        writer.endArray();
    }

    public static void deserialize(JsonObject json) {
        JsonArray itemStatsArray = json.get("itemStats").getAsJsonArray();
        for (Object element : itemStatsArray) {
            JsonArray statArray = element.getAsJsonArray();
            Item item = (Item)Item.field_150901_e.func_82594_a(statArray.get(0).getAsString());
            JsonObject stats = statArray.get(1).getAsJsonObject();
            itemStats.put(item, ResistanceStats.deserialize(stats));
        }
        JsonArray setStatsArray = json.get("setStats").getAsJsonArray();
        for (JsonElement element : setStatsArray) {
            JsonArray statArray = element.getAsJsonArray();
            Item helmet = statArray.get(0).isJsonNull() ? null : (Item)Item.field_150901_e.func_82594_a(statArray.get(0).getAsString());
            Item plate = statArray.get(1).isJsonNull() ? null : (Item)Item.field_150901_e.func_82594_a(statArray.get(1).getAsString());
            Item legs = statArray.get(2).isJsonNull() ? null : (Item)Item.field_150901_e.func_82594_a(statArray.get(2).getAsString());
            Item boots = statArray.get(3).isJsonNull() ? null : (Item)Item.field_150901_e.func_82594_a(statArray.get(3).getAsString());
            JsonObject stats = statArray.get(4).getAsJsonObject();
            DamageResistanceHandler.registerSet(helmet, plate, legs, boots, ResistanceStats.deserialize(stats));
        }
        JsonArray entityStatsArray = json.get("entityStats").getAsJsonArray();
        for (JsonElement element : entityStatsArray) {
            JsonArray statArray = element.getAsJsonArray();
            try {
                Class<?> clazz = Class.forName(statArray.get(0).getAsString());
                JsonObject stats = statArray.get(1).getAsJsonObject();
                entityStats.put(clazz, ResistanceStats.deserialize(stats));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public static void setup(float dt, float dr) {
        currentPDT = dt;
        currentPDR = dr;
    }

    public static void reset() {
        currentPDT = 0.0f;
        currentPDR = 0.0f;
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        if (event.source.func_151517_h()) {
            return;
        }
        EntityLivingBase e = event.entityLiving;
        float amount = event.ammount;
        float[] vals = DamageResistanceHandler.getDTDR(e, event.source, amount, currentPDT, currentPDR);
        float dt = vals[0] - currentPDT;
        float dr = vals[1] - currentPDR;
        if (dt > 0.0f && dt >= event.ammount || dr >= 1.0f) {
            event.setCanceled(true);
            EntityDamageUtil.damageArmorNT(e, amount);
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingHurtEvent event) {
        event.ammount = DamageResistanceHandler.calculateDamage(event.entityLiving, event.source, event.ammount, currentPDT, currentPDR);
        if (event.entityLiving instanceof IResistanceProvider) {
            IResistanceProvider irp = (IResistanceProvider)event.entityLiving;
            irp.onDamageDealt(event.source, event.ammount);
        }
    }

    public static String typeToCategory(DamageSource source) {
        if (source.func_94541_c()) {
            return CATEGORY_EXPLOSION;
        }
        if (source.func_76347_k()) {
            return CATEGORY_FIRE;
        }
        if (source.func_76352_a()) {
            return CATEGORY_PHYSICAL;
        }
        if (source.field_76373_n.equals(DamageClass.LASER.name())) {
            return CATEGORY_ENERGY;
        }
        if (source.field_76373_n.equals(DamageClass.MICROWAVE.name())) {
            return CATEGORY_ENERGY;
        }
        if (source.field_76373_n.equals(DamageClass.SUBATOMIC.name())) {
            return CATEGORY_ENERGY;
        }
        if (source.field_76373_n.equals(DamageClass.ELECTRIC.name())) {
            return CATEGORY_ENERGY;
        }
        if (source == DamageSource.field_76367_g) {
            return CATEGORY_PHYSICAL;
        }
        if (source instanceof EntityDamageSource) {
            return CATEGORY_PHYSICAL;
        }
        return source.field_76373_n;
    }

    public static float calculateDamage(EntityLivingBase entity, DamageSource damage, float amount, float pierceDT, float pierce) {
        if (damage.func_151517_h()) {
            return amount;
        }
        float[] vals = DamageResistanceHandler.getDTDR(entity, damage, amount, pierceDT, pierce);
        float dt = vals[0];
        float dr = vals[1];
        if ((dt = Math.max(0.0f, dt - pierceDT)) >= amount) {
            return 0.0f;
        }
        amount -= dt;
        return amount *= 1.0f - (dr *= MathHelper.func_76131_a((float)(1.0f - pierce), (float)0.0f, (float)2.0f));
    }

    public static float[] getDTDR(EntityLivingBase entity, DamageSource damage, float amount, float pierceDT, float pierce) {
        Resistance res;
        Resistance res2;
        Tuple.Quartet<Item, Item, Item, Object> wornSet;
        ResistanceStats setResistance;
        float dt = 0.0f;
        float dr = 0.0f;
        if (entity instanceof IResistanceProvider) {
            IResistanceProvider irp = (IResistanceProvider)entity;
            float[] res3 = irp.getCurrentDTDR(damage, amount, pierceDT, pierce);
            dt += res3[0];
            dr += res3[1];
        }
        if ((setResistance = setStats.get(wornSet = new Tuple.Quartet<Item, Item, Item, Object>(entity.func_71124_b(4) != null ? entity.func_71124_b(4).func_77973_b() : null, entity.func_71124_b(3) != null ? entity.func_71124_b(3).func_77973_b() : null, entity.func_71124_b(2) != null ? entity.func_71124_b(2).func_77973_b() : null, (entity.func_71124_b(1) != null ? entity.func_71124_b(1).func_77973_b() : null)))) != null && (res2 = setResistance.getResistance(damage)) != null) {
            dt += res2.threshold;
            dr += res2.resistance;
        }
        for (int i = 1; i <= 4; ++i) {
            Resistance res4;
            ResistanceStats stats;
            ItemStack armor = entity.func_71124_b(i);
            if (armor == null || (stats = itemStats.get(armor.func_77973_b())) == null || (res4 = stats.getResistance(damage)) == null) continue;
            dt += res4.threshold;
            dr += res4.resistance;
        }
        ResistanceStats innateResistance = entityStats.get(entity.getClass());
        if (innateResistance != null && (res = innateResistance.getResistance(damage)) != null) {
            dt += res.threshold;
            dr += res.resistance;
        }
        return new float[]{dt, dr};
    }

    public static class Resistance {
        public float threshold;
        public float resistance;

        public Resistance(float threshold, float resistance) {
            this.threshold = threshold;
            this.resistance = resistance;
        }
    }

    public static class ResistanceStats {
        public HashMap<String, Resistance> exactResistances = new HashMap();
        public HashMap<String, Resistance> categoryResistances = new HashMap();
        public Resistance otherResistance;

        public Resistance getResistance(DamageSource source) {
            Resistance exact = this.exactResistances.get(source.field_76373_n);
            if (exact != null) {
                return exact;
            }
            Resistance category = this.categoryResistances.get(DamageResistanceHandler.typeToCategory(source));
            if (category != null) {
                return category;
            }
            return source.func_76363_c() ? null : this.otherResistance;
        }

        public ResistanceStats addExact(String type, float threshold, float resistance) {
            this.exactResistances.put(type, new Resistance(threshold, resistance));
            return this;
        }

        public ResistanceStats addCategory(String type, float threshold, float resistance) {
            this.categoryResistances.put(type, new Resistance(threshold, resistance));
            return this;
        }

        public ResistanceStats setOther(float threshold, float resistance) {
            this.otherResistance = new Resistance(threshold, resistance);
            return this;
        }

        public void serialize(JsonWriter writer) throws IOException {
            if (!this.exactResistances.isEmpty()) {
                writer.name("exact").beginArray();
                for (Map.Entry<String, Resistance> entry : this.exactResistances.entrySet()) {
                    writer.beginArray().setIndent("");
                    writer.value(entry.getKey()).value((double)entry.getValue().threshold).value((double)entry.getValue().resistance).endArray().setIndent("  ");
                }
                writer.endArray();
            }
            if (!this.categoryResistances.isEmpty()) {
                writer.name("category").beginArray();
                for (Map.Entry<String, Resistance> entry : this.categoryResistances.entrySet()) {
                    writer.beginArray().setIndent("");
                    writer.value(entry.getKey()).value((double)entry.getValue().threshold).value((double)entry.getValue().resistance).endArray().setIndent("  ");
                }
                writer.endArray();
            }
            if (this.otherResistance != null) {
                writer.name("other").beginArray().setIndent("");
                writer.value((double)this.otherResistance.threshold).value((double)this.otherResistance.resistance).endArray().setIndent("  ");
            }
        }

        public static ResistanceStats deserialize(JsonObject json) {
            JsonArray array;
            ResistanceStats stats = new ResistanceStats();
            if (json.has("exact")) {
                JsonArray exact = json.get("exact").getAsJsonArray();
                for (JsonElement element : exact) {
                    array = element.getAsJsonArray();
                    stats.exactResistances.put(array.get(0).getAsString(), new Resistance(array.get(1).getAsFloat(), array.get(2).getAsFloat()));
                }
            }
            if (json.has("category")) {
                JsonArray category = json.get("category").getAsJsonArray();
                for (JsonElement element : category) {
                    array = element.getAsJsonArray();
                    stats.categoryResistances.put(array.get(0).getAsString(), new Resistance(array.get(1).getAsFloat(), array.get(2).getAsFloat()));
                }
            }
            if (json.has("other")) {
                JsonArray other = json.get("other").getAsJsonArray();
                stats.otherResistance = new Resistance(other.get(0).getAsFloat(), other.get(1).getAsFloat());
            }
            return stats;
        }
    }

    public static enum DamageClass {
        PHYSICAL,
        FIRE,
        EXPLOSIVE,
        ELECTRIC,
        LASER,
        MICROWAVE,
        SUBATOMIC,
        OTHER;

    }
}

