/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.fluidmk2.FluidNode;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityPipelineBase
extends TileEntityPipeBaseNT {
    protected List<int[]> connected = new ArrayList<int[]>();

    @Override
    public FluidNode createNode(FluidType type) {
        TileEntityPipelineBase tile = this;
        FluidNode node = new FluidNode(type.getNetworkProvider(), new BlockPos[]{new BlockPos(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)}).setConnections(new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN));
        for (int[] pos : this.connected) {
            node.addConnection(new DirPos(pos[0], pos[1], pos[2], ForgeDirection.UNKNOWN));
        }
        return node;
    }

    public void addConnection(int x, int y, int z) {
        this.connected.add(new int[]{x, y, z});
        FluidNode node = (FluidNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.type.getNetworkProvider());
        node.recentlyChanged = true;
        node.addConnection(new DirPos(x, y, z, ForgeDirection.UNKNOWN));
        this.func_70296_d();
        if (this.field_145850_b instanceof WorldServer) {
            WorldServer world = (WorldServer)this.field_145850_b;
            world.func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void disconnectAll() {
        for (int[] pos : this.connected) {
            TileEntity te = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2]);
            if (te == this || !(te instanceof TileEntityPipelineBase)) continue;
            TileEntityPipelineBase pipeline = (TileEntityPipelineBase)te;
            UniNodespace.destroyNode(this.field_145850_b, pos[0], pos[1], pos[2], this.type.getNetworkProvider());
            for (int i = 0; i < pipeline.connected.size(); ++i) {
                int[] conPos = pipeline.connected.get(i);
                if (conPos[0] != this.field_145851_c || conPos[1] != this.field_145848_d || conPos[2] != this.field_145849_e) continue;
                pipeline.connected.remove(i);
                --i;
            }
            pipeline.func_70296_d();
            if (!(this.field_145850_b instanceof WorldServer)) continue;
            WorldServer world = (WorldServer)this.field_145850_b;
            world.func_73040_p().func_151250_a(pipeline.field_145851_c, pipeline.field_145848_d, pipeline.field_145849_e);
        }
        UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.type.getNetworkProvider());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.disconnectAll();
    }

    public static int canConnect(TileEntityPipelineBase first, TileEntityPipelineBase second) {
        if (first.getConnectionType() != second.getConnectionType()) {
            return 1;
        }
        if (first == second) {
            return 2;
        }
        if (first.type != second.type) {
            return 4;
        }
        double len = Math.min(first.getMaxPipeLength(), second.getMaxPipeLength());
        Vec3 firstPos = first.getConnectionPoint();
        Vec3 secondPos = second.getConnectionPoint();
        Vec3 delta = Vec3.func_72443_a((double)(secondPos.field_72450_a - firstPos.field_72450_a), (double)(secondPos.field_72448_b - firstPos.field_72448_b), (double)(secondPos.field_72449_c - firstPos.field_72449_c));
        return len >= delta.func_72433_c() ? 0 : 3;
    }

    public abstract ConnectionType getConnectionType();

    public abstract Vec3 getMountPos();

    public abstract double getMaxPipeLength();

    public Vec3 getConnectionPoint() {
        Vec3 mount = this.getMountPos();
        return mount.func_72441_c((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public List<int[]> getConnected() {
        return this.connected;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("conCount", this.connected.size());
        for (int i = 0; i < this.connected.size(); ++i) {
            nbt.func_74783_a("con" + i, this.connected.get(i));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int count = nbt.func_74762_e("conCount");
        this.connected.clear();
        for (int i = 0; i < count; ++i) {
            this.connected.add(nbt.func_74759_k("con" + i));
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static enum ConnectionType {
        SMALL;

    }
}

