/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IHeatSource;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerMachineCoker;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCoker;
import com.hbm.inventory.recipes.CokerRecipes;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityMachineCoker
extends TileEntityMachineBase
implements SimpleComponent,
CompatHandler.OCComponent,
IFluidStandardTransceiver,
IGUIProvider,
IFluidCopiable {
    public boolean wasOn;
    public int progress;
    public static int processTime = 20000;
    public int heat;
    public static int maxHeat = 100000;
    public static double diffusion = 0.25;
    public FluidTank[] tanks = new FluidTank[2];
    AxisAlignedBB bb = null;

    public TileEntityMachineCoker() {
        super(2);
        this.tanks[0] = new FluidTank(Fluids.HEAVYOIL, 16000);
        this.tanks[1] = new FluidTank(Fluids.OIL_COKER, 8000);
    }

    @Override
    public String getName() {
        return "container.machineCoker";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tryPullHeat();
            this.tanks[0].setType(0, this.slots);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            this.wasOn = false;
            if (this.canProcess()) {
                int burn = this.heat / 100;
                if (burn > 0) {
                    this.wasOn = true;
                    this.progress += burn;
                    this.heat -= burn;
                    if (this.progress >= processTime) {
                        this.markChanged();
                        this.progress -= processTime;
                        Tuple.Triplet<Integer, ItemStack, FluidStack> recipe = CokerRecipes.getOutput(this.tanks[0].getTankType());
                        int fillReq = recipe.getX();
                        ItemStack output = recipe.getY();
                        FluidStack byproduct = recipe.getZ();
                        if (output != null) {
                            if (this.slots[1] == null) {
                                this.slots[1] = output.func_77946_l();
                            } else {
                                this.slots[1].field_77994_a += output.field_77994_a;
                            }
                        }
                        if (byproduct != null) {
                            this.tanks[1].setFill(this.tanks[1].getFill() + byproduct.fill);
                        }
                        this.tanks[0].setFill(this.tanks[0].getFill() - fillReq);
                    }
                }
                if (this.wasOn && this.field_145850_b.func_82737_E() % 5L == 0L) {
                    PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.19999999f);
                }
            }
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[1].getFill() <= 0) continue;
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.networkPackNT(25);
        } else if (this.wasOn && this.field_145850_b.func_82737_E() % 2L == 0L) {
            NBTTagCompound fx = new NBTTagCompound();
            fx.func_74778_a("type", "tower");
            fx.func_74776_a("lift", 10.0f);
            fx.func_74776_a("base", 0.75f);
            fx.func_74776_a("max", 3.0f);
            fx.func_74768_a("life", 200 + this.field_145850_b.field_73012_v.nextInt(50));
            fx.func_74768_a("color", 0x404040);
            fx.func_74780_a("posX", (double)this.field_145851_c + 0.5);
            fx.func_74780_a("posY", (double)(this.field_145848_d + 22));
            fx.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
            MainRegistry.proxy.effectNT(fx);
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    public boolean canProcess() {
        Tuple.Triplet<Integer, ItemStack, FluidStack> recipe = CokerRecipes.getOutput(this.tanks[0].getTankType());
        if (recipe == null) {
            return false;
        }
        int fillReq = recipe.getX();
        ItemStack output = recipe.getY();
        FluidStack byproduct = recipe.getZ();
        if (byproduct != null) {
            this.tanks[1].setTankType(byproduct.type);
        }
        if (this.tanks[0].getFill() < fillReq) {
            return false;
        }
        if (byproduct != null && byproduct.fill + this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
            return false;
        }
        if (output != null && this.slots[1] != null) {
            if (output.func_77973_b() != this.slots[1].func_77973_b()) {
                return false;
            }
            if (output.func_77960_j() != this.slots[1].func_77960_j()) {
                return false;
            }
            if (output.field_77994_a + this.slots[1].field_77994_a > output.func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.wasOn);
        buf.writeInt(this.heat);
        buf.writeInt(this.progress);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.wasOn = buf.readBoolean();
        this.heat = buf.readInt();
        this.progress = buf.readInt();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    protected void tryPullHeat() {
        if (this.heat >= maxHeat) {
            return;
        }
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * diffusion);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > maxHeat) {
                    this.heat = maxHeat;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.progress = nbt.func_74762_e("prog");
        this.heat = nbt.func_74762_e("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        nbt.func_74768_a("prog", this.progress);
        nbt.func_74768_a("heat", this.heat);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 23), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineCoker(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCoker(player.field_71071_by, this);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_coker";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTypeStored(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getTankType().getName(), this.tanks[1].getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluidStored(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[1].getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getTankType().getName(), this.tanks[1].getTankType().getName(), this.tanks[0].getFill(), this.tanks[1].getFill(), this.heat};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getFluidStored", "getTypeStored", "getHeat", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getFluidStored": {
                return this.getFluidStored(context, args);
            }
            case "getTypeStored": {
                return this.getTypeStored(context, args);
            }
            case "getHeat": {
                return this.getHeat(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

