/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.container.ContainerMachineMilkReformer;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMilkReformer;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineMilkReformer
extends TileEntityMachineBase
implements IGUIProvider,
IFluidStandardTransceiver,
IEnergyReceiverMK2 {
    public FluidTank[] tanks = new FluidTank[4];
    public long power;
    public static final long maxPower = 100000000L;
    AxisAlignedBB bb = null;

    public TileEntityMachineMilkReformer() {
        super(11);
        this.tanks[0] = new FluidTank(Fluids.MILK, 64000);
        this.tanks[1] = new FluidTank(Fluids.EMILK, 32000);
        this.tanks[2] = new FluidTank(Fluids.CMILK, 32000);
        this.tanks[3] = new FluidTank(Fluids.CREAM, 32000);
    }

    @Override
    public String getName() {
        return "container.milkreformer";
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2], this.tanks[3]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineMilkReformer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMilkReformer(player.field_71071_by, this);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000000L);
            this.tanks[0].loadTank(1, 2, this.slots);
            this.refine();
            this.tanks[1].unloadTank(3, 4, this.slots);
            this.tanks[2].unloadTank(5, 6, this.slots);
            this.tanks[3].unloadTank(7, 8, this.slots);
            for (DirPos pos : this.getConPos()) {
                for (int i = 1; i < 4; ++i) {
                    if (this.tanks[i].getFill() <= 0) continue;
                    this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            this.networkPackNT(150);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void refine() {
        if (this.power < 10000L) {
            return;
        }
        if (this.tanks[0].getFill() < 100) {
            return;
        }
        if (this.tanks[1].getFill() + 50 > this.tanks[1].getMaxFill()) {
            return;
        }
        if (this.tanks[2].getFill() + 35 > this.tanks[2].getMaxFill()) {
            return;
        }
        if (this.tanks[3].getFill() + 15 > this.tanks[3].getMaxFill()) {
            return;
        }
        this.power -= 10000L;
        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
        this.tanks[1].setFill(this.tanks[1].getFill() + 50);
        this.tanks[2].setFill(this.tanks[2].getFill() + 35);
        this.tanks[3].setFill(this.tanks[3].getFill() + 15);
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "input");
        this.tanks[1].readFromNBT(nbt, "m1");
        this.tanks[2].readFromNBT(nbt, "m2");
        this.tanks[3].readFromNBT(nbt, "m3");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "input");
        this.tanks[1].writeToNBT(nbt, "m1");
        this.tanks[2].writeToNBT(nbt, "m2");
        this.tanks[3].writeToNBT(nbt, "m3");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 7), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }
}

