/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyProviderMK2;
import com.hbm.entity.effect.EntityCloudFleija;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.container.ContainerMachineDischarger;
import com.hbm.inventory.gui.GUIMachineDischarger;
import com.hbm.inventory.recipes.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityMachineDischarger
extends TileEntityMachineBase
implements IEnergyProviderMK2,
IGUIProvider,
IPersistentNBT {
    public long power = 0L;
    public int process = 0;
    public int temp = 20;
    public static final int maxtemp = 2000;
    public static final long maxPower = 500000000L;
    public static long Gen = 20000000L;
    public static final int processSpeed = 100;
    public static final int CoolDown = 400;
    private AudioWrapper audio;

    public TileEntityMachineDischarger() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.machine_discharger";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 0: {
                if (!MachineRecipes.mODE(stack, OreDictManager.SA326.ingot())) break;
                return true;
            }
            case 2: {
                if (!MachineRecipes.mODE(stack, OreDictManager.U233.ingot())) break;
                return true;
            }
            default: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.process = nbt.func_74762_e("process");
        this.temp = nbt.func_74762_e("temp");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("temp", this.temp);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (i == 0) {
            return true;
        }
        return i == 1 && stack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)stack.func_77973_b()).getCharge(stack) == 0L;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 500000000L;
    }

    public long getTempScaled(int i) {
        return this.temp * i / 2000;
    }

    public int getProgressScaled(int i) {
        return this.process * i / 100;
    }

    public int getCoolDownScaled(int i) {
        return this.temp * i / 400;
    }

    public boolean canProcess() {
        if (this.temp <= 20 && this.slots[0] != null && MachineRecipes.mODE(this.slots[0], OreDictManager.SA326.ingot())) {
            return true;
        }
        if (this.temp <= 20 && this.slots[0] != null && MachineRecipes.mODE(this.slots[0], OreDictManager.U233.ingot())) {
            return true;
        }
        if (this.temp <= 20 && this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.ingot_electronium) {
            return true;
        }
        return this.temp <= 20 && this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.battery_creative;
    }

    public boolean isProcessing() {
        return this.process > 0;
    }

    public void process() {
        ++this.process;
        if (this.process >= 100) {
            this.process = 0;
            this.temp = 2000;
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0 && this.slots[0].func_77973_b() == ModItems.ingot_u233) {
                this.power = (long)((double)this.power + (double)Gen * 0.8);
                this.slots[0] = null;
                this.slots[0] = new ItemStack(ModItems.ingot_titanium);
            }
            if (this.slots[0].field_77994_a <= 0 && this.slots[0].func_77973_b() == ModItems.ingot_schrabidium) {
                this.power += Gen * 2L;
                this.slots[0] = null;
                this.slots[0] = new ItemStack(ModItems.ingot_hafnium);
            }
            if (this.slots[0].field_77994_a <= 0 && this.slots[0].func_77973_b() == ModItems.ingot_electronium) {
                this.power += Gen * 4L;
                this.slots[0] = null;
                this.slots[0] = new ItemStack(ModItems.ingot_dineutronium);
            }
            if (this.slots[0].field_77994_a <= 0 && this.slots[0].func_77973_b() == ModItems.battery_creative) {
                EntityNukeExplosionMK3 ex = EntityNukeExplosionMK3.statFacFleija(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 120);
                if (!ex.field_70128_L) {
                    this.field_145850_b.func_72838_d((Entity)ex);
                    EntityCloudFleija cloud = new EntityCloudFleija(this.field_145850_b, 120);
                    cloud.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    this.field_145850_b.func_72838_d((Entity)cloud);
                }
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeItemsFromTE(this.slots, 1, this.power, 500000000L);
            if (this.canProcess()) {
                this.process();
            } else {
                this.process = 0;
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                if (this.temp > 20) {
                    this.temp -= 5;
                }
                if (this.temp < 20) {
                    this.temp = 20;
                }
            }
            if (this.temp > 20) {
                if (this.field_145850_b.func_82737_E() % 7L == 0L) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 11), (double)this.field_145849_e, "random.fizz", 0.5f, 0.5f);
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "tower");
                data.func_74776_a("lift", 0.1f);
                data.func_74776_a("base", 0.3f);
                data.func_74776_a("max", 1.0f);
                data.func_74768_a("life", 20 + this.field_145850_b.field_73012_v.nextInt(20));
                data.func_74780_a("posX", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                data.func_74780_a("posY", (double)(this.field_145848_d + 1));
                MainRegistry.proxy.effectNT(data);
            }
            this.networkPackNT(50);
        } else if (this.process > 0) {
            if (this.audio == null) {
                this.audio = this.createAudioLoop();
                this.audio.startSound();
            } else if (!this.audio.isPlaying()) {
                this.audio = this.rebootAudio(this.audio);
            }
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:weapon.tauChargeLoop", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.power);
        buf.writeInt(this.process);
        buf.writeInt(this.temp);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.power = buf.readLong();
        this.process = buf.readInt();
        this.temp = buf.readInt();
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 500000000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineDischarger(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineDischarger(player.field_71071_by, this);
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74768_a("progress", this.process);
        data.func_74768_a("temp", this.temp);
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.power = data.func_74763_f("power");
        this.temp = data.func_74762_e("temp");
        this.process = data.func_74762_e("procsess");
    }
}

