/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineChemplant;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineChemplant;
import com.hbm.inventory.recipes.ChemplantRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Deprecated
public class TileEntityMachineChemplant
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IGUIProvider,
IUpgradeInfoProvider {
    public long power;
    public static final long maxPower = 100000L;
    public int progress;
    public int maxProgress = 100;
    public boolean isProgressing;
    private AudioWrapper audio;
    public FluidTank[] tanks;
    int consumption = 100;
    int speed = 100;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    int lsl0 = 0;
    int lsl1 = 0;
    int lsu0 = 0;
    int lsu1 = 0;
    AxisAlignedBB bb = null;

    public TileEntityMachineChemplant() {
        super(21);
        this.tanks = new FluidTank[4];
        for (int i = 0; i < 4; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, 24000);
        }
    }

    @Override
    public String getName() {
        return "container.chemplant";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.speed = 100;
            this.consumption = 100;
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            int fluidDelay = 40;
            if (this.lsu0 >= fluidDelay && this.tanks[0].loadTank(17, 19, this.slots)) {
                this.lsl0 = 0;
            }
            if (this.lsu1 >= fluidDelay && this.tanks[1].loadTank(18, 20, this.slots)) {
                this.lsl1 = 0;
            }
            if (this.lsl0 >= fluidDelay && this.slots[17] != null && !FluidTank.noDualUnload.contains(this.slots[17].func_77973_b()) && this.tanks[0].unloadTank(17, 19, this.slots)) {
                this.lsu0 = 0;
            }
            if (this.lsl1 >= fluidDelay && this.slots[18] != null && !FluidTank.noDualUnload.contains(this.slots[18].func_77973_b()) && this.tanks[1].unloadTank(18, 20, this.slots)) {
                this.lsu1 = 0;
            }
            this.tanks[2].unloadTank(9, 11, this.slots);
            this.tanks[3].unloadTank(10, 12, this.slots);
            if (this.lsl0 < fluidDelay) {
                ++this.lsl0;
            }
            if (this.lsl1 < fluidDelay) {
                ++this.lsl1;
            }
            if (this.lsu0 < fluidDelay) {
                ++this.lsu0;
            }
            if (this.lsu1 < fluidDelay) {
                ++this.lsu1;
            }
            this.loadItems();
            this.unloadItems();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[2].getFill() > 0) {
                    this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                if (this.tanks[3].getFill() <= 0) continue;
                this.sendFluid(this.tanks[3], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.upgradeManager.checkSlots(this, this.slots, 1, 3);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.speed -= speedLevel * 25;
            this.consumption += speedLevel * 300;
            this.speed += powerLevel * 5;
            this.consumption -= powerLevel * 20;
            this.speed /= overLevel + 1;
            this.consumption *= overLevel + 1;
            if (this.speed <= 0) {
                this.speed = 1;
            }
            if (!this.canProcess()) {
                this.progress = 0;
            } else {
                this.isProgressing = true;
                this.process();
            }
            this.networkPackNT(150);
        } else {
            if (this.isProgressing && this.field_145850_b.func_82737_E() % 3L == 0L) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                double x = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 1.125 + (double)rot.offsetX * 0.125;
                double y = this.field_145848_d + 3;
                double z = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 1.125 + (double)rot.offsetZ * 0.125;
                this.field_145850_b.func_72869_a("cloud", x, y, z, 0.0, 0.1, 0.0);
            }
            float volume = this.getVolume(1.0f);
            if (this.isProgressing && volume > 0.0f) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.updateVolume(volume);
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                    this.audio.updateVolume(volume);
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.progress);
        buf.writeInt(this.maxProgress);
        buf.writeBoolean(this.isProgressing);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.progress = buf.readInt();
        this.maxProgress = buf.readInt();
        this.isProgressing = buf.readBoolean();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.chemplantOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 3 + dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3 + dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX * 2 + dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 + dir.offsetZ, rot.getOpposite())};
    }

    private boolean canProcess() {
        if (this.slots[4] == null || this.slots[4].func_77973_b() != ModItems.chemistry_template) {
            return false;
        }
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[4].func_77960_j());
        if (recipe == null) {
            return false;
        }
        this.setupTanks(recipe);
        if (this.power < (long)this.consumption) {
            return false;
        }
        if (!this.hasRequiredFluids(recipe)) {
            return false;
        }
        if (!this.hasSpaceForFluids(recipe)) {
            return false;
        }
        if (!this.hasRequiredItems(recipe)) {
            return false;
        }
        if (!this.hasSpaceForItems(recipe)) {
            return false;
        }
        if (recipe.oxygenConsumption > 0) {
            return this.breatheAir(recipe.oxygenConsumption);
        }
        return true;
    }

    private void setupTanks(ChemplantRecipes.ChemRecipe recipe) {
        if (recipe.inputFluids[0] != null) {
            this.tanks[0].withPressure(recipe.inputFluids[0].pressure).setTankType(recipe.inputFluids[0].type);
        } else {
            this.tanks[0].setTankType(Fluids.NONE);
        }
        if (recipe.inputFluids[1] != null) {
            this.tanks[1].withPressure(recipe.inputFluids[1].pressure).setTankType(recipe.inputFluids[1].type);
        } else {
            this.tanks[1].setTankType(Fluids.NONE);
        }
        if (recipe.outputFluids[0] != null) {
            this.tanks[2].withPressure(recipe.outputFluids[0].pressure).setTankType(recipe.outputFluids[0].type);
        } else {
            this.tanks[2].setTankType(Fluids.NONE);
        }
        if (recipe.outputFluids[1] != null) {
            this.tanks[3].withPressure(recipe.outputFluids[1].pressure).setTankType(recipe.outputFluids[1].type);
        } else {
            this.tanks[3].setTankType(Fluids.NONE);
        }
    }

    private boolean hasRequiredFluids(ChemplantRecipes.ChemRecipe recipe) {
        if (recipe.inputFluids[0] != null && this.tanks[0].getFill() < recipe.inputFluids[0].fill) {
            return false;
        }
        return recipe.inputFluids[1] == null || this.tanks[1].getFill() >= recipe.inputFluids[1].fill;
    }

    private boolean hasSpaceForFluids(ChemplantRecipes.ChemRecipe recipe) {
        if (recipe.outputFluids[0] != null && this.tanks[2].getFill() + recipe.outputFluids[0].fill > this.tanks[2].getMaxFill()) {
            return false;
        }
        return recipe.outputFluids[1] == null || this.tanks[3].getFill() + recipe.outputFluids[1].fill <= this.tanks[3].getMaxFill();
    }

    private boolean hasRequiredItems(ChemplantRecipes.ChemRecipe recipe) {
        return InventoryUtil.doesArrayHaveIngredients(this.slots, 13, 16, recipe.inputs);
    }

    private boolean hasSpaceForItems(ChemplantRecipes.ChemRecipe recipe) {
        return InventoryUtil.doesArrayHaveSpace(this.slots, 5, 8, recipe.outputs);
    }

    private void process() {
        this.power -= (long)this.consumption;
        ++this.progress;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.meteorite_sword_machined) {
            this.slots[0] = new ItemStack(ModItems.meteorite_sword_treated);
        }
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[4].func_77960_j());
        this.maxProgress = recipe.getDuration() * this.speed / 100;
        if (this.maxProgress <= 0) {
            this.maxProgress = 1;
        }
        if (this.progress >= this.maxProgress) {
            this.consumeFluids(recipe);
            this.produceFluids(recipe);
            this.consumeItems(recipe);
            this.produceItems(recipe);
            this.progress = 0;
            this.func_70296_d();
        }
    }

    private void consumeFluids(ChemplantRecipes.ChemRecipe recipe) {
        if (recipe.inputFluids[0] != null) {
            this.tanks[0].setFill(this.tanks[0].getFill() - recipe.inputFluids[0].fill);
        }
        if (recipe.inputFluids[1] != null) {
            this.tanks[1].setFill(this.tanks[1].getFill() - recipe.inputFluids[1].fill);
        }
    }

    private void produceFluids(ChemplantRecipes.ChemRecipe recipe) {
        if (recipe.outputFluids[0] != null) {
            this.tanks[2].setFill(this.tanks[2].getFill() + recipe.outputFluids[0].fill);
        }
        if (recipe.outputFluids[1] != null) {
            this.tanks[3].setFill(this.tanks[3].getFill() + recipe.outputFluids[1].fill);
        }
    }

    private void consumeItems(ChemplantRecipes.ChemRecipe recipe) {
        for (RecipesCommon.AStack in : recipe.inputs) {
            if (in == null) continue;
            InventoryUtil.tryConsumeAStack(this.slots, 13, 16, in);
        }
    }

    private void produceItems(ChemplantRecipes.ChemRecipe recipe) {
        for (ItemStack out : recipe.outputs) {
            if (out == null) continue;
            InventoryUtil.tryAddItemToInventory(this.slots, 5, 8, out.func_77946_l());
        }
    }

    private void loadItems() {
        if (this.slots[4] == null || this.slots[4].func_77973_b() != ModItems.chemistry_template) {
            return;
        }
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[4].func_77960_j());
        if (recipe != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
            int x = this.field_145851_c - dir.offsetX * 2;
            int z = this.field_145849_e - dir.offsetZ * 2;
            TileEntity te = this.field_145850_b.func_147438_o(x, this.field_145848_d, z);
            if (te instanceof IInventory) {
                IInventory inv = (IInventory)te;
                ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
                int[] access = sided != null ? sided.func_94128_d(dir.ordinal()) : null;
                block0: for (RecipesCommon.AStack ingredient : recipe.inputs) {
                    block1: while (!InventoryUtil.doesArrayHaveIngredients(this.slots, 13, 16, ingredient)) {
                        boolean found = false;
                        for (int i = 0; i < (access != null ? access.length : inv.func_70302_i_()); ++i) {
                            int j;
                            int slot = access != null ? access[i] : i;
                            ItemStack stack = inv.func_70301_a(slot);
                            if (!ingredient.matchesRecipe(stack, true) || sided != null && !sided.func_102008_b(slot, stack, 0)) continue;
                            for (j = 13; j <= 16; ++j) {
                                if (this.slots[j] == null || !(this.slots[j].field_77994_a < this.slots[j].func_77976_d() & InventoryUtil.doesStackDataMatch(this.slots[j], stack))) continue;
                                inv.func_70298_a(slot, 1);
                                ++this.slots[j].field_77994_a;
                                continue block1;
                            }
                            for (j = 13; j <= 16; ++j) {
                                if (this.slots[j] != null) continue;
                                this.slots[j] = stack.func_77946_l();
                                this.slots[j].field_77994_a = 1;
                                inv.func_70298_a(slot, 1);
                                continue block1;
                            }
                        }
                        if (found) continue;
                        continue block0;
                    }
                }
            }
        }
    }

    private void unloadItems() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        int x = this.field_145851_c + dir.offsetX * 3 + rot.offsetX;
        int z = this.field_145849_e + dir.offsetZ * 3 + rot.offsetZ;
        TileEntity te = this.field_145850_b.func_147438_o(x, this.field_145848_d, z);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
            int[] access = sided != null ? sided.func_94128_d(dir.ordinal()) : null;
            boolean shouldOutput = true;
            block0: while (shouldOutput) {
                shouldOutput = false;
                for (int i = 5; i <= 8; ++i) {
                    int slot;
                    int j;
                    ItemStack out = this.slots[i];
                    if (out == null) continue;
                    for (j = 0; j < (access != null ? access.length : inv.func_70302_i_()); ++j) {
                        ItemStack target;
                        int n = slot = access != null ? access[j] : j;
                        if (!inv.func_94041_b(slot, out) || !InventoryUtil.doesStackDataMatch(out, target = inv.func_70301_a(slot)) || target.field_77994_a >= Math.min(target.func_77976_d(), inv.func_70297_j_())) continue;
                        int toDec = Math.min(out.field_77994_a, Math.min(target.func_77976_d(), inv.func_70297_j_()) - target.field_77994_a);
                        this.func_70298_a(i, toDec);
                        target.field_77994_a += toDec;
                        shouldOutput = true;
                        continue block0;
                    }
                    for (j = 0; j < (access != null ? access.length : inv.func_70302_i_()); ++j) {
                        int n = slot = access != null ? access[j] : j;
                        if (!inv.func_94041_b(slot, out) || inv.func_70301_a(slot) != null || !(sided != null ? sided.func_102007_a(slot, out, dir.ordinal()) : inv.func_94041_b(slot, out))) continue;
                        ItemStack copy = out.func_77946_l();
                        copy.field_77994_a = 1;
                        inv.func_70299_a(slot, copy);
                        this.func_70298_a(i, 1);
                        shouldOutput = true;
                        continue block0;
                    }
                }
            }
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progress", this.progress);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[2], this.tanks[3]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineChemplant(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineChemplant(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_chemplant));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 300 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 30 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 5 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 9);
        return upgrades;
    }
}

