/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import api.hbm.fluidmk2.IFluidUserMK2;
import com.hbm.interfaces.ICopiable;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.util.BobMathUtil;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public interface IFluidCopiable
extends ICopiable {
    default public int[] getFluidIDToCopy() {
        IFluidUserMK2 tile = (IFluidUserMK2)((Object)this);
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (FluidTank tank : tile.getAllTanks()) {
            if (tank.getTankType().hasNoID()) continue;
            types.add(tank.getTankType().getID());
        }
        return BobMathUtil.intCollectionToArray(types);
    }

    default public FluidTank getTankToPaste() {
        TileEntity te = (TileEntity)this;
        if (te instanceof IFluidStandardTransceiverMK2) {
            IFluidStandardTransceiverMK2 tile = (IFluidStandardTransceiverMK2)((Object)this);
            return tile.getReceivingTanks() != null ? tile.getReceivingTanks()[0] : null;
        }
        return null;
    }

    @Override
    default public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.getFluidIDToCopy().length > 0) {
            tag.func_74783_a("fluidID", this.getFluidIDToCopy());
        }
        return tag;
    }

    @Override
    default public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        int[] ids;
        if (this.getTankToPaste() != null && (ids = nbt.func_74759_k("fluidID")).length > 0 && index < ids.length) {
            int id = ids[index];
            this.getTankToPaste().setTankType(Fluids.fromID(id));
        }
    }

    @Override
    default public String[] infoForDisplay(World world, int x, int y, int z) {
        int[] ids = this.getFluidIDToCopy();
        String[] names = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            names[i] = Fluids.fromID(ids[i]).getUnlocalizedName();
        }
        return names;
    }
}

