/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.handler.RocketStruct;
import com.hbm.items.ISatChip;
import com.hbm.items.ModItems;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class ItemCustomRocket
extends Item
implements ISatChip {
    public static ItemStack build(RocketStruct rocket) {
        ItemStack stack = new ItemStack(ModItems.rocket_custom);
        stack.field_77990_d = new NBTTagCompound();
        rocket.writeToNBT(stack.field_77990_d);
        return stack;
    }

    public static ItemStack build(RocketStruct rocket, boolean hasFuel) {
        ItemStack stack = ItemCustomRocket.build(rocket);
        ItemCustomRocket.setFuel(stack, hasFuel);
        return stack;
    }

    public static RocketStruct get(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemCustomRocket) || stack.field_77990_d == null) {
            return null;
        }
        return RocketStruct.readFromNBT(stack.field_77990_d);
    }

    public static boolean hasFuel(ItemStack stack) {
        if (stack == null || stack.field_77990_d == null) {
            return false;
        }
        return stack.field_77990_d.func_74767_n("hasFuel");
    }

    public static void setFuel(ItemStack stack, boolean hasFuel) {
        if (stack == null) {
            return;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a("hasFuel", hasFuel);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        RocketStruct rocket = ItemCustomRocket.get(stack);
        if (rocket == null) {
            return;
        }
        list.add(EnumChatFormatting.BOLD + "Payload: " + EnumChatFormatting.GRAY + I18nUtil.resolveKey(rocket.capsule.part.func_77658_a() + ".name", new Object[0]));
        list.add(EnumChatFormatting.BOLD + "Stages: " + EnumChatFormatting.GRAY + rocket.stages.size());
        if (ItemCustomRocket.hasFuel(stack)) {
            list.add(EnumChatFormatting.GRAY + "Is fully fueled");
        }
        if (this.getFreq(stack) != 0) {
            list.add(EnumChatFormatting.BOLD + "Satellite Frequency: " + EnumChatFormatting.GRAY + this.getFreq(stack));
        }
    }
}

