/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIDMulti;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTItemControlPacket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIScreenFluid
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_fluid.png");
    protected int xSize = 176;
    protected int ySize = 54;
    protected int guiLeft;
    protected int guiTop;
    private GuiTextField search;
    private final EntityPlayer player;
    private FluidType primary = Fluids.NONE;
    private FluidType secondary = Fluids.NONE;
    private FluidType[] searchArray = new FluidType[9];

    public GUIScreenFluid(EntityPlayer player) {
        this.player = player;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
    }

    public void func_73876_c() {
        if (this.player.func_70694_bm() == null || this.player.func_70694_bm().func_77973_b() != ModItems.fluid_identifier_multi) {
            this.player.func_71053_j();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.search = new GuiTextField(this.field_146289_q, this.guiLeft + 46, this.guiTop + 11, 86, 12);
        this.search.func_146193_g(-1);
        this.search.func_146204_h(-1);
        this.search.func_146185_a(false);
        this.search.func_146195_b(true);
        if (this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77973_b() == ModItems.fluid_identifier_multi) {
            this.primary = ItemFluidIDMulti.getType(this.player.func_70694_bm(), true);
            this.secondary = ItemFluidIDMulti.getType(this.player.func_70694_bm(), false);
        }
    }

    protected void func_73864_a(int i, int j, int button) {
        this.search.func_146192_a(i, j, button);
        for (int k = 0; k < this.searchArray.length; ++k) {
            NBTTagCompound data;
            if (this.searchArray[k] == null) {
                return;
            }
            if (this.guiLeft + 7 + k * 18 > i || this.guiLeft + 7 + k * 18 + 18 <= i || this.guiTop + 29 >= j || this.guiTop + 29 + 18 < j) continue;
            if (button == 0) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                this.primary = this.searchArray[k];
                data = new NBTTagCompound();
                data.func_74768_a("primary", this.primary.getID());
                PacketDispatcher.wrapper.sendToServer(new NBTItemControlPacket(data));
                continue;
            }
            if (button != 1) continue;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.secondary = this.searchArray[k];
            data = new NBTTagCompound();
            data.func_74768_a("secondary", this.secondary.getID());
            PacketDispatcher.wrapper.sendToServer(new NBTItemControlPacket(data));
        }
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        this.search.func_146194_f();
        for (int k = 0; k < this.searchArray.length; ++k) {
            if (this.searchArray[k] == null) {
                return;
            }
            if (this.guiLeft + 7 + k * 18 > i || this.guiLeft + 7 + k * 18 + 18 <= i || this.guiTop + 29 >= j || this.guiTop + 29 + 18 < j) continue;
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(this.searchArray[k].getLocalizedName());
            this.searchArray[k].addInfo(tooltip);
            this.func_146283_a(tooltip, i, j);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.search.func_146206_l()) {
            this.func_73729_b(this.guiLeft + 43, this.guiTop + 7, 166, 54, 90, 18);
        }
        for (int k = 0; k < this.searchArray.length; ++k) {
            FluidType type = this.searchArray[k];
            if (type == null) {
                return;
            }
            Color color = new Color(type.getColor());
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.func_73729_b(this.guiLeft + 12 + k * 18, this.guiTop + 31, 12 + k * 18, 56, 8, 14);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (type == this.primary && type == this.secondary) {
                this.func_73729_b(this.guiLeft + 7 + k * 18, this.guiTop + 29, 176, 36, 18, 18);
                continue;
            }
            if (type == this.primary) {
                this.func_73729_b(this.guiLeft + 7 + k * 18, this.guiTop + 29, 176, 0, 18, 18);
                continue;
            }
            if (type != this.secondary) continue;
            this.func_73729_b(this.guiLeft + 7 + k * 18, this.guiTop + 29, 176, 18, 18, 18);
        }
    }

    protected void func_73869_a(char c, int key) {
        if (this.search.func_146201_a(c, key)) {
            this.updateSearch();
        } else {
            super.func_73869_a(c, key);
        }
        if (key == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void updateSearch() {
        this.searchArray = new FluidType[9];
        int next = 0;
        String subs = this.search.func_146179_b().toLowerCase(Locale.US);
        for (FluidType type : Fluids.getInNiceOrder()) {
            String name = type.getLocalizedName().toLowerCase(Locale.US);
            if (!name.contains(subs) || type.hasNoID()) continue;
            this.searchArray[next] = type;
            if (++next < 9) continue;
            return;
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

