/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.glyphid;

import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.entity.mob.glyphid.GlyphidStats;
import com.hbm.main.ResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityGlyphidBrawler
extends EntityGlyphid {
    public int timer = 0;
    protected Entity lastTarget;
    protected double lastX;
    protected double lastY;
    protected double lastZ;

    public EntityGlyphidBrawler(World world) {
        super(world);
        this.func_70105_a(2.0f, 1.125f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Entity e = this.func_70777_m();
        if (e != null && this.func_70089_S()) {
            this.lastX = e.field_70165_t;
            this.lastY = e.field_70163_u;
            this.lastZ = e.field_70161_v;
            if (--this.timer <= 0) {
                this.leap();
                this.timer = 80 + this.field_70170_p.field_73012_v.nextInt(30);
            }
        }
    }

    public void leap() {
        if (!this.field_70170_p.field_72995_K && this.field_70789_a instanceof EntityLivingBase && this.func_70032_d(this.field_70789_a) < 20.0f) {
            int prediction;
            Vec3 delta;
            double len;
            Entity e = this.func_70777_m();
            double velX = e.field_70165_t - this.lastX;
            double velY = e.field_70163_u - this.lastY;
            double velZ = e.field_70161_v - this.lastZ;
            if (this.lastTarget != e) {
                velZ = 0.0;
                velY = 0.0;
                velX = 0.0;
            }
            if ((len = (delta = Vec3.func_72443_a((double)(e.field_70165_t - this.field_70165_t + velX * (double)(prediction = 60)), (double)(e.field_70163_u + (double)(e.field_70131_O / 2.0f) - (this.field_70163_u + 1.0) + velY * (double)prediction), (double)(e.field_70161_v - this.field_70161_v + velZ * (double)prediction))).func_72433_c()) < 3.0) {
                return;
            }
            double targetYaw = -Math.atan2(delta.field_72450_a, delta.field_72449_c);
            double x = Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c);
            double y = delta.field_72448_b;
            double v0 = 1.5;
            double v02 = v0 * v0;
            double g = 0.01;
            double targetPitch = Math.atan((v02 + Math.sqrt(v02 * v02 - g * (g * x * x + 2.0 * y * v02)) * 1.0) / (g * x));
            Vec3 fireVec = null;
            if (!Double.isNaN(targetPitch)) {
                fireVec = Vec3.func_72443_a((double)v0, (double)0.0, (double)0.0);
                fireVec.func_72446_c((float)(-targetPitch / 3.5));
                fireVec.func_72442_b((float)(-(targetYaw + 1.5707963267948966)));
            }
            if (fireVec != null) {
                this.setThrowableHeading(fireVec.field_72450_a, fireVec.field_72448_b, fireVec.field_72449_c, (float)v0, this.field_70146_Z.nextFloat());
            }
        }
    }

    public void setThrowableHeading(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float throwLen = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)throwLen;
        motionY /= (double)throwLen;
        motionZ /= (double)throwLen;
        motionX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        motionY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        motionZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        this.field_70159_w = motionX *= (double)velocity;
        this.field_70181_x = motionY *= (double)velocity;
        this.field_70179_y = motionZ *= (double)velocity;
        float hyp = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, hyp) * 180.0 / Math.PI);
    }

    @Override
    public ResourceLocation getSkin() {
        return ResourceManager.glyphid_brawler_tex;
    }

    @Override
    public double getScale() {
        return 1.25;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(GlyphidStats.getStats().getBrawler().health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(GlyphidStats.getStats().getBrawler().speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(GlyphidStats.getStats().getBrawler().damage);
    }

    @Override
    public GlyphidStats.StatBundle getStats() {
        return GlyphidStats.getStats().statsBrawler;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h && amount <= 10.0f) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean isArmorBroken(float amount) {
        return (double)this.field_70146_Z.nextInt(100) <= Math.min(Math.pow((double)amount * 0.25, 2.0), 100.0);
    }
}

