/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.blocks.ILookOverlay;
import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.CelestialTeleporter;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.SolarSystemWorldSavedData;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.RocketStruct;
import com.hbm.items.ISatChip;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissilePart;
import com.hbm.items.weapon.ItemCustomRocket;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.EntityBufPacket;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.machine.TileEntityOrbitalStation;
import com.hbm.tileentity.machine.TileEntityOrbitalStationLauncher;
import com.hbm.util.BobMathUtil;
import com.hbm.util.CompatExternal;
import com.hbm.util.ParticleUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityRideableRocket
extends EntityMissileBaseNT
implements ILookOverlay,
IBufPacketReceiver {
    public ItemStack navDrive;
    public EntityRideableRocketDummy capDummy;
    private int stateTimer = 0;
    public int decoupleTimer = 0;
    public int shroudTimer = 0;
    public int forceExitTimer = 0;
    private static final int WATCHABLE_STATE = 8;
    private static final int WATCHABLE_DRIVE = 9;
    private static final int WATCHABLE_TIMER = 10;
    private static final int WATCHABLE_ROCKET = 11;
    private double rocketVelocity = 0.0;
    private boolean sizeSet = false;
    private AudioWrapper audio;
    private RocketState lastState = RocketState.AWAITING;
    private boolean willExplode = false;
    private int satFreq = 0;
    private TileEntityOrbitalStation targetPort;

    public EntityRideableRocket(World world) {
        super(world);
        this.func_70105_a(2.0f, 8.0f);
        this.sizeSet = false;
        this.targetX = (int)this.field_70165_t - 10000;
        this.targetZ = (int)this.field_70161_v;
    }

    public EntityRideableRocket(World world, float x, float y, float z, ItemStack stack) {
        super(world, x, y, z, (int)x + 10000, (int)z);
        RocketStruct rocket = ItemCustomRocket.get(stack);
        this.satFreq = ISatChip.getFreqS(stack);
        this.setRocket(rocket);
        this.func_70105_a(2.0f, (float)rocket.getHeight() + 1.0f);
    }

    public EntityRideableRocket withProgram(ItemStack stack) {
        this.navDrive = stack.func_77946_l();
        return this;
    }

    public EntityRideableRocket launchedBy(EntityLivingBase entity) {
        this.thrower = entity;
        return this;
    }

    public void beginLandingSequence(ItemVOTVdrive.Target from, ItemVOTVdrive.Target to) {
        boolean expendStage;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        RocketStruct rocket = this.getRocket();
        boolean bl = expendStage = rocket.stages.size() > 0;
        if (this.getState() == RocketState.UNDOCKING && from.body == to.body) {
            expendStage = false;
        }
        if (expendStage) {
            rocket.stages.remove(0);
            this.setRocket(rocket);
            this.func_70105_a(2.0f, (float)rocket.getHeight() + 1.0f);
        }
        this.setState(RocketState.LANDING);
        if (this.navDrive != null && this.navDrive.func_77973_b() instanceof ItemVOTVdrive) {
            ItemVOTVdrive.Destination destination = ItemVOTVdrive.getDestination(this.navDrive);
            int x = destination.x;
            int y = 800;
            int z = destination.z;
            int targetDimensionId = destination.body.getDimensionId();
            EntityPlayer rider = (EntityPlayer)this.field_70153_n;
            if (rider != null) {
                if (destination.body == SolarSystem.Body.ORBIT) {
                    this.setState(RocketState.DOCKING);
                    x = x * 1024 + 512;
                    y = 0;
                    z = z * 1024 + 512;
                }
                if (this.field_70170_p.field_73011_w.field_76574_g != targetDimensionId) {
                    CelestialTeleporter.teleport(rider, targetDimensionId, (double)x + 0.5, y, (double)z + 0.5, false);
                } else {
                    this.field_70165_t = (double)x + 0.5;
                    this.field_70163_u = y;
                    this.field_70161_v = (double)z + 0.5;
                }
                if (destination.body == SolarSystem.Body.ORBIT) {
                    WorldServer targetWorld = DimensionManager.getWorld((int)targetDimensionId);
                    OrbitalStation.spawn((World)targetWorld, x, z);
                }
            } else if (!this.canRide()) {
                if (rocket.capsule.part instanceof ISatChip && destination.body != SolarSystem.Body.ORBIT) {
                    WorldServer targetWorld = DimensionManager.getWorld((int)targetDimensionId);
                    if (targetWorld == null) {
                        DimensionManager.initDimension((int)targetDimensionId);
                        targetWorld = DimensionManager.getWorld((int)targetDimensionId);
                    }
                    if (targetWorld != null) {
                        Satellite.orbit((World)targetWorld, Satellite.getIDFromItem(rocket.capsule.part), this.satFreq, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    }
                } else if (rocket.capsule.part == ModItems.rp_station_core_20) {
                    OrbitalStation.addStation(x, z, CelestialBody.getBody(this.field_70170_p));
                    if (this.thrower != null && this.thrower instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)this.thrower;
                        if (!player.field_71075_bZ.field_75098_d && !ItemVOTVdrive.wasCopied(this.navDrive)) {
                            player.func_71029_a((StatBase)MainRegistry.achDriveFail);
                        }
                    }
                }
                this.func_70106_y();
            }
        }
    }

    public void beginCelestialTransfer(ItemVOTVdrive.Target from, ItemVOTVdrive.Target to) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.setState(RocketState.TRANSFER);
        RocketStruct rocket = this.getRocket();
        SolarSystemWorldSavedData data = SolarSystemWorldSavedData.get(this.field_70170_p);
        OrbitalStation station = data.addStation(from.body);
        int size = 10;
        double distance = SolarSystem.calculateDistanceBetweenTwoBodies(this.field_70170_p, from.body, to.body);
        float thrust = rocket.getThrust();
        station.setState(OrbitalStation.StationState.TRANSFER, OrbitalStation.calculateTransferTime(distance, size, thrust));
        station.orbiting = from.body;
        station.target = to.body;
        EntityPlayer rider = (EntityPlayer)this.field_70153_n;
        int x = station.dX * 1024 + 512;
        int y = 128;
        int z = station.dZ * 1024 + 512;
        if (rider != null) {
            if (this.field_70170_p.field_73011_w.field_76574_g != SpaceConfig.orbitDimension) {
                CelestialTeleporter.teleport(rider, SpaceConfig.orbitDimension, (double)x + 0.5, y, (double)z + 0.5, false);
            } else {
                this.field_70165_t = (double)x + 0.5;
                this.field_70163_u = y;
                this.field_70161_v = (double)z + 0.5;
            }
        }
    }

    public boolean canExitCapsule() {
        RocketState state = this.getState();
        return state != RocketState.LANDING && state != RocketState.LAUNCHING && state != RocketState.DOCKING && state != RocketState.UNDOCKING && state != RocketState.TRANSFER;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        RocketState state = this.getState();
        if (!this.sizeSet) {
            this.func_70105_a(2.0f, (float)this.getRocket().getHeight() + 1.0f);
            if (!(this.field_70170_p.field_72995_K || state != RocketState.LANDED && state != RocketState.AWAITING && state != RocketState.NEEDSFUEL)) {
                TileEntity te = CompatExternal.getCoreFromPos(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70131_O - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v));
                if (te instanceof TileEntityOrbitalStation) {
                    ((TileEntityOrbitalStation)te).dockRocket(this);
                } else if (te instanceof TileEntityOrbitalStationLauncher) {
                    ((TileEntityOrbitalStationLauncher)te).dockRocket(this);
                }
            }
        }
        EntityPlayer rider = (EntityPlayer)this.field_70153_n;
        if (!this.field_70170_p.field_72995_K) {
            ItemVOTVdrive.Target to;
            ItemVOTVdrive.Target from;
            this.field_70177_z = -90.0f;
            if (this.navDrive != null && this.navDrive.func_77973_b() instanceof ItemVOTVdrive) {
                ItemVOTVdrive.getTarget(this.navDrive, this.field_70170_p);
                this.setDrive(this.navDrive);
            }
            if (this.thrower == null && rider != null) {
                this.thrower = rider;
            }
            if (state == RocketState.AWAITING && (rider != null && rider.field_70703_bu || !this.canRide())) {
                from = CelestialBody.getTarget(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70161_v);
                to = this.getTarget();
                RocketState transitionTo = from.inOrbit ? RocketState.UNDOCKING : RocketState.LAUNCHING;
                this.targetX = (int)this.field_70165_t - 10000;
                this.targetZ = (int)this.field_70161_v;
                if (this.getRocket().hasSufficientFuel(from.body, to.body, from.inOrbit, to.inOrbit)) {
                    this.setState(transitionTo);
                }
                this.thrower = rider;
            }
            if (this.thrower != null && rider == null && !this.canExitCapsule() && this.forceExitTimer < 60) {
                this.thrower.func_70078_a((Entity)this);
            }
            if (state == RocketState.LAUNCHING) {
                if (this.isReusable()) {
                    this.field_70125_A = MathHelper.func_76131_a((float)((float)(this.stateTimer - 60) * 0.3f), (float)0.0f, (float)45.0f);
                    if (this.rocketVelocity < 4.0) {
                        this.rocketVelocity += MathHelper.func_151237_a((double)((double)this.stateTimer / 120.0 * 0.05), (double)0.0, (double)0.05);
                    }
                } else {
                    double acceleration = (double)this.stateTimer / 120.0;
                    this.field_70125_A = MathHelper.func_76131_a((float)((float)(this.stateTimer - 80) * 0.3f), (float)0.0f, (float)45.0f);
                    if (this.rocketVelocity < 4.0) {
                        this.rocketVelocity += MathHelper.func_151237_a((double)(acceleration * acceleration * 0.05), (double)0.0, (double)0.05);
                    }
                }
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().hasOptifine()) {
                    this.field_70125_A = 0.0f;
                }
            } else if (state == RocketState.LANDING) {
                double targetHeight = this.field_70170_p.func_72976_f((int)this.field_70165_t, (int)this.field_70161_v);
                this.field_70125_A = 0.0f;
                this.rocketVelocity = this.isReusable() ? MathHelper.func_151237_a((double)((targetHeight - this.field_70163_u) * 0.01), (double)-1.0, (double)-0.005) : MathHelper.func_151237_a((double)((targetHeight - this.field_70163_u) * 0.005), (double)-0.5, (double)-0.005);
                if (this.navDrive != null && this.navDrive.func_77973_b() instanceof ItemVOTVdrive) {
                    ItemVOTVdrive.Destination destination = ItemVOTVdrive.getDestination(this.navDrive);
                    AxisAlignedBB bb = this.field_70121_D.func_72329_c();
                    bb.field_72338_b = targetHeight;
                    if (!this.field_70170_p.func_94576_a((Entity)this, bb, entity -> entity instanceof EntityRideableRocket).isEmpty()) {
                        int distance;
                        int n = distance = this.field_70170_p.field_73012_v.nextBoolean() ? -5 : 5;
                        if (this.field_70170_p.field_73012_v.nextBoolean()) {
                            destination.x += distance;
                            this.navDrive.field_77990_d.func_74768_a("x", destination.x);
                        } else {
                            destination.z += distance;
                            this.navDrive.field_77990_d.func_74768_a("z", destination.z);
                        }
                    }
                    this.field_70165_t = (double)destination.x + 0.5;
                    this.field_70161_v = (double)destination.z + 0.5;
                }
            } else if (state == RocketState.TIPPING) {
                float tipTime = (float)this.stateTimer * 0.1f;
                this.field_70125_A = tipTime * tipTime;
                if (this.field_70125_A > 90.0f) {
                    this.field_70125_A = 90.0f;
                    if (this.willExplode) {
                        this.dropNDie(null);
                        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
                        ExplosionLarge.spawnShrapnelShower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 15, 0.075);
                        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "hbm:entity.pipefail", 10000.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    }
                }
                this.rocketVelocity = 0.0;
            } else if (state == RocketState.DOCKING) {
                if (this.stateTimer > 20) {
                    this.rocketVelocity = 0.1;
                    this.field_70125_A = 0.0f;
                    if (this.targetPort == null) {
                        this.targetPort = OrbitalStation.getPort((int)this.field_70165_t, (int)this.field_70161_v);
                    }
                    if (this.targetPort != null) {
                        this.field_70165_t = (double)this.targetPort.field_145851_c + 0.5;
                        this.field_70161_v = (double)this.targetPort.field_145849_e + 0.5;
                        this.targetPort.despawnRocket();
                        this.targetPort.reservePort();
                        if (this.field_70163_u + (double)this.field_70131_O > (double)this.targetPort.field_145848_d + 1.5) {
                            this.setState(this.isReusable() ? RocketState.NEEDSFUEL : RocketState.LANDED);
                            this.field_70163_u = (double)this.targetPort.field_145848_d + 1.5 - (double)this.field_70131_O;
                            this.targetPort.dockRocket(this);
                            this.targetPort = null;
                        }
                    } else {
                        this.rocketVelocity = 0.0;
                    }
                } else {
                    this.rocketVelocity = 0.0;
                    this.field_70125_A = 0.0f;
                }
            } else if (state == RocketState.UNDOCKING) {
                this.rocketVelocity = -0.1;
                this.field_70125_A = 0.0f;
            } else if (state == RocketState.TRANSFER) {
                this.rocketVelocity = 0.0;
                this.field_70125_A = 90.0f;
                this.forceExitTimer = 0;
                OrbitalStation station = OrbitalStation.getStationFromPosition((int)this.field_70165_t, (int)this.field_70161_v);
                station.update(this.field_70170_p);
                if (station.getUnscaledProgress(0.0f) > 0.99 || station.state == OrbitalStation.StationState.ARRIVING) {
                    ItemVOTVdrive.Target from2 = CelestialBody.getTarget(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70161_v);
                    ItemVOTVdrive.Target to2 = this.getTarget();
                    this.beginLandingSequence(from2, to2);
                    SolarSystemWorldSavedData data = SolarSystemWorldSavedData.get(this.field_70170_p);
                    data.removeStation(station);
                }
                PacketDispatcher.wrapper.sendTo(new EntityBufPacket(this.func_145782_y(), this), (EntityPlayerMP)rider);
            } else {
                this.rocketVelocity = 0.0;
                this.field_70125_A = 0.0f;
            }
            if (state == RocketState.LAUNCHING) {
                Vec3 motion = BobMathUtil.getDirectionFromAxisAngle(this.field_70125_A - 90.0f, 180.0f - this.field_70177_z, this.rocketVelocity);
                this.field_70159_w = motion.field_72450_a;
                this.field_70181_x = motion.field_72448_b;
                this.field_70179_y = motion.field_72449_c;
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = this.rocketVelocity;
                this.field_70179_y = 0.0;
            }
            if (state == RocketState.LANDING && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151586_h) {
                this.setState(RocketState.TIPPING);
            }
            if (state == RocketState.LAUNCHING && this.field_70163_u > 900.0 || state == RocketState.UNDOCKING && this.field_70163_u < 32.0) {
                from = CelestialBody.getTarget(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70161_v);
                to = this.getTarget();
                if (!this.canRide() || from.body == to.body) {
                    this.beginLandingSequence(from, to);
                } else {
                    this.beginCelestialTransfer(from, to);
                }
            }
            if (this.field_70131_O > 8.0f) {
                double offset = this.field_70131_O - 4.0f;
                if (this.capDummy == null || this.capDummy.field_70128_L) {
                    this.capDummy = new EntityRideableRocketDummy(this.field_70170_p, this);
                    this.capDummy.parent = this;
                    this.capDummy.func_70107_b(this.field_70165_t, this.field_70163_u + offset, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)this.capDummy);
                } else {
                    this.capDummy.func_70107_b(this.field_70165_t, this.field_70163_u + offset, this.field_70161_v);
                }
            } else if (this.capDummy != null) {
                this.capDummy.func_70106_y();
                this.capDummy = null;
            }
        } else {
            if (state != this.lastState) {
                if (state == RocketState.LAUNCHING) {
                    AudioWrapper ignition = MainRegistry.proxy.getLoopedSound("hbm:entity.rocketIgnition", (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 1.0f, 250.0f, 1.0f, 5);
                    ignition.setDoesRepeat(false);
                    ignition.startSound();
                }
                this.lastState = state;
                this.stateTimer = 0;
            } else if (state == RocketState.LAUNCHING || state == RocketState.LANDING && this.field_70181_x > -0.4 || state == RocketState.TRANSFER && OrbitalStation.clientStation.getUnscaledProgress(0.0f) <= 0.15) {
                if (this.audio == null || !this.audio.isPlaying()) {
                    String rocketAudio = this.getRocket().stages.size() <= 1 ? "hbm:entity.rocketFlyLight" : "hbm:entity.rocketFlyHeavy";
                    this.audio = MainRegistry.proxy.getLoopedSound(rocketAudio, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 1.0f, 250.0f, 1.0f, 5);
                    this.audio.startSound();
                }
                this.audio.updatePosition((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
                this.audio.keepAlive();
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            if (state == RocketState.TRANSFER) {
                OrbitalStation station = OrbitalStation.clientStation;
                station.update(this.field_70170_p);
                if (station.getUnscaledProgress(0.0f) > 0.2) {
                    AudioWrapper decouple;
                    if (this.decoupleTimer == 0) {
                        decouple = MainRegistry.proxy.getLoopedSound("hbm:entity.rocketStage", (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.5f, 250.0f, 0.9f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f, 40);
                        decouple.setDoesRepeat(false);
                        decouple.startSound();
                    }
                    if (this.decoupleTimer == 100 && this.getRocket().stages.size() > 1) {
                        decouple = MainRegistry.proxy.getLoopedSound("hbm:entity.rocketStage", (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.5f, 250.0f, 1.2f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f, 40);
                        decouple.setDoesRepeat(false);
                        decouple.startSound();
                    } else if (this.decoupleTimer > 100) {
                        ++this.shroudTimer;
                    }
                    ++this.decoupleTimer;
                }
            } else {
                this.decoupleTimer = 0;
                this.shroudTimer = 0;
            }
        }
        this.setStateTimer(++this.stateTimer);
    }

    public AxisAlignedBB func_70046_E() {
        if (this.motionMult() > 0.0) {
            return null;
        }
        return this.field_70121_D;
    }

    @Override
    protected double motionMult() {
        RocketState state = this.getState();
        if (state == RocketState.AWAITING || state == RocketState.LANDED || state == RocketState.NEEDSFUEL) {
            return 0.0;
        }
        return 4.0;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (!this.canRide()) {
            return false;
        }
        if (super.func_130002_c(player)) {
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != player)) {
            player.func_70078_a((Entity)this);
            return true;
        }
        return false;
    }

    public boolean canRide() {
        return this.getRocket().capsule.part.attributes[0] == ItemCustomMissilePart.WarheadType.APOLLO;
    }

    public boolean isReusable() {
        return this.getRocket().capsule.part == ModItems.rp_pod_20;
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        double length = this.func_70042_X() + this.field_70153_n.func_70033_W();
        Vec3 target = BobMathUtil.getDirectionFromAxisAngle(this.field_70125_A - 90.0f, 180.0f - this.field_70177_z, length);
        this.field_70153_n.func_70107_b(this.field_70165_t + target.field_72450_a, this.field_70163_u + target.field_72448_b, this.field_70161_v + target.field_72449_c);
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        RocketState state = this.getState();
        if (state != RocketState.LANDING && state != RocketState.DOCKING) {
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (state == RocketState.DOCKING) {
            return;
        }
        RocketStruct rocket = this.getRocket();
        if (rocket.stages.size() > 0 && rocket.stages.get((int)0).fins == null) {
            this.setState(RocketState.TIPPING);
            this.willExplode = true;
        } else {
            this.setState(RocketState.LANDED);
        }
        this.field_70163_u = this.field_70170_p.func_72976_f((int)this.field_70165_t, (int)this.field_70161_v);
    }

    @Override
    public void onMissileImpact(MovingObjectPosition mop) {
    }

    public double func_70042_X() {
        if (this.isReusable()) {
            return (double)this.field_70131_O - 2.5;
        }
        return (double)this.field_70131_O - 3.0;
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
        this.sizeSet = true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_85032_ar()) {
                return false;
            }
            if (this.field_70153_n == null && source.func_76346_g() instanceof EntityPlayer) {
                if (this.getRocket().stages.size() == 0 && this.getRocket().capsule.part != ModItems.rp_pod_20 || this.getState() == RocketState.TIPPING) {
                    this.dropNDie(source);
                } else {
                    ItemStack stack = ((EntityPlayer)source.func_76346_g()).func_70694_bm();
                    if (stack != null && stack.func_77973_b().canHarvestBlock(Blocks.field_150348_b, stack)) {
                        this.dropNDie(source);
                    }
                }
            }
            return true;
        }
        return true;
    }

    public void dropNDie(DamageSource source) {
        this.func_70106_y();
        RocketStruct rocket = this.getRocket();
        if (rocket.stages.size() == 0) {
            ItemStack stack = new ItemStack((Item)rocket.capsule.part);
            this.func_70099_a(stack, 0.0f);
        } else {
            ItemStack stack = ItemCustomRocket.build(rocket, true);
            this.func_70099_a(stack, 0.0f);
        }
        if (this.navDrive != null) {
            this.func_70099_a(this.navDrive, 0.0f);
        }
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.capDummy != null) {
            this.capDummy.func_70106_y();
        }
    }

    @Override
    protected void spawnContrail() {
        RocketState state = this.getState();
        if (state == RocketState.AWAITING || state == RocketState.LANDED || state == RocketState.LANDING && this.field_70181_x <= -0.4 || state == RocketState.DOCKING || state == RocketState.UNDOCKING || state == RocketState.NEEDSFUEL || state == RocketState.TRANSFER && OrbitalStation.clientStation.getUnscaledProgress(0.0f) > 0.15) {
            return;
        }
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        if (this.field_70181_x > 0.0) {
            x = this.field_70142_S;
            y = this.field_70137_T;
            z = this.field_70136_U;
        }
        RocketStruct rocket = this.getRocket();
        if (rocket.stages.size() == 0) {
            if (state == RocketState.TIPPING) {
                return;
            }
            if (this.isReusable()) {
                ParticleUtil.spawnGasFlame(this.field_70170_p, x + 0.5, y, z, 0.0, -1.0, 0.0);
                ParticleUtil.spawnGasFlame(this.field_70170_p, x - 0.5, y, z, 0.0, -1.0, 0.0);
                ParticleUtil.spawnGasFlame(this.field_70170_p, x, y, z + 0.5, 0.0, -1.0, 0.0);
                ParticleUtil.spawnGasFlame(this.field_70170_p, x, y, z - 0.5, 0.0, -1.0, 0.0);
            } else {
                double r = rocket.capsule.part.bottom.radius * 0.5;
                ParticleUtil.spawnGasFlame(this.field_70170_p, x + r, y, z + r, 0.25, -0.75, 0.25);
                ParticleUtil.spawnGasFlame(this.field_70170_p, x - r, y, z + r, -0.25, -0.75, 0.25);
                ParticleUtil.spawnGasFlame(this.field_70170_p, x + r, y, z - r, 0.25, -0.75, -0.25);
                ParticleUtil.spawnGasFlame(this.field_70170_p, x - r, y, z - r, -0.25, -0.75, -0.25);
            }
            double groundHeight = this.field_70170_p.func_72976_f((int)x, (int)z);
            double distanceToGround = y - groundHeight;
            if (distanceToGround < 10.0) {
                ExplosionLarge.spawnShock(this.field_70170_p, x, groundHeight + 0.5, z, 1 + this.field_70170_p.field_73012_v.nextInt(3), 1.0 + this.field_70170_p.field_73012_v.nextGaussian());
            }
            return;
        }
        RocketStruct.RocketStage stage = rocket.stages.get(0);
        if (state == RocketState.LANDING) {
            ParticleUtil.spawnGasFlame(this.field_70170_p, x, y, z, 0.0, -1.0, 0.0);
            double groundHeight = this.field_70170_p.func_72976_f((int)x, (int)z);
            double distanceToGround = y - groundHeight;
            if (distanceToGround < 10.0) {
                ExplosionLarge.spawnShock(this.field_70170_p, x, groundHeight + 0.5, z, 1 + this.field_70170_p.field_73012_v.nextInt(3), 1.0 + this.field_70170_p.field_73012_v.nextGaussian());
            }
        } else if (state == RocketState.LAUNCHING || this.getStateTimer() < 200) {
            this.spawnContraolWithOffset(0.0, 0.0, 0.0);
            int cluster = stage.getCluster();
            for (int c = 1; c < cluster; ++c) {
                float spin = (float)c / (float)(cluster - 1);
                double ox = Math.cos((double)spin * Math.PI * 2.0) * stage.fuselage.part.bottom.radius;
                double oz = Math.sin((double)spin * Math.PI * 2.0) * stage.fuselage.part.bottom.radius;
                this.spawnContraolWithOffset(ox, 0.0, oz);
            }
        }
    }

    public RocketStruct getRocket() {
        return RocketStruct.readFromDataWatcher(this.field_70180_af, 11);
    }

    public void setRocket(RocketStruct rocket) {
        rocket.writeToDataWatcher(this.field_70180_af, 11);
    }

    public RocketState getState() {
        return RocketState.values()[this.field_70180_af.func_75679_c(8)];
    }

    public void setState(RocketState state) {
        this.field_70180_af.func_75692_b(8, (Object)state.ordinal());
        this.field_70180_af.func_75692_b(10, (Object)0);
        this.stateTimer = 0;
    }

    public ItemVOTVdrive.Target getTarget() {
        ItemStack drive = this.field_70180_af.func_82710_f(9);
        return ItemVOTVdrive.getTarget(drive, this.field_70170_p);
    }

    public void setDrive(ItemStack drive) {
        this.field_70180_af.func_75692_b(9, (Object)drive);
    }

    public int getStateTimer() {
        return this.field_70180_af.func_75679_c(10);
    }

    public void setStateTimer(int timer) {
        this.field_70180_af.func_75692_b(10, (Object)timer);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(8, (Object)RocketState.AWAITING.ordinal());
        this.field_70180_af.func_82709_a(9, 5);
        this.field_70180_af.func_75682_a(10, (Object)0);
        RocketStruct.setupDataWatcher(this.field_70180_af, 11);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setStateTimer(nbt.func_74762_e("timer"));
        this.setState(RocketState.values()[nbt.func_74762_e("state")]);
        this.setRocket(RocketStruct.readFromNBT(nbt.func_74775_l("rocket")));
        this.navDrive = nbt.func_74764_b("drive") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("drive")) : null;
        this.satFreq = nbt.func_74762_e("freq");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("timer", this.getStateTimer());
        nbt.func_74768_a("state", this.getState().ordinal());
        NBTTagCompound rocketTag = new NBTTagCompound();
        this.getRocket().writeToNBT(rocketTag);
        nbt.func_74782_a("rocket", (NBTBase)rocketTag);
        if (this.navDrive != null) {
            NBTTagCompound driveData = new NBTTagCompound();
            this.navDrive.func_77955_b(driveData);
            nbt.func_74782_a("drive", (NBTBase)driveData);
        }
        nbt.func_74768_a("freq", this.satFreq);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        boolean canLaunch;
        RocketState state = this.getState();
        if (state == RocketState.LAUNCHING || state == RocketState.LANDING || state == RocketState.TIPPING || state == RocketState.DOCKING || state == RocketState.UNDOCKING) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (state == RocketState.TRANSFER) {
            OrbitalStation station = OrbitalStation.clientStation;
            double progress = station.getUnscaledProgress(0.0f);
            text.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey("station.travelling", new Object[0]) + ": " + EnumChatFormatting.RESET + I18nUtil.resolveKey("body." + station.target.name, new Object[0]));
            text.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey("station.progress", new Object[0]) + ": " + EnumChatFormatting.RESET + "" + Math.round(progress * 100.0) + "%");
            ILookOverlay.printGeneric(event, "Rocket", 0xFFFF00, 0x404000, text);
            return;
        }
        RocketStruct rocket = this.getRocket();
        if (rocket.stages.size() == 0 && this.field_70170_p.field_73011_w.field_76574_g != SpaceConfig.orbitDimension && !this.isReusable()) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemVOTVdrive.Target from = CelestialBody.getTarget(world, (int)this.field_70165_t, (int)this.field_70161_v);
        ItemVOTVdrive.Target to = this.getTarget();
        boolean bl = canLaunch = to.body != null && state == RocketState.AWAITING;
        if (state == RocketState.NEEDSFUEL) {
            text.add(EnumChatFormatting.RED + "Rocket has no fuel!");
        } else if (canLaunch && !rocket.hasSufficientFuel(from.body, to.body, from.inOrbit, to.inOrbit)) {
            text.add(EnumChatFormatting.RED + "Rocket can't reach destination!");
            canLaunch = false;
        }
        if (this.field_70153_n == null) {
            text.add("Interact to enter");
        } else if (this.field_70153_n != player) {
            text.add("OCCUPIED");
        } else {
            if (to.inOrbit) {
                text.add("Destination: ORBITAL STATION");
            } else if (to.body != null) {
                text.add("Destination: " + I18nUtil.resolveKey("body." + to.body.name, new Object[0]));
            } else {
                text.add("Destination: NO DRIVE INSTALLED");
            }
            if (canLaunch) {
                text.add("JUMP TO LAUNCH");
            } else if (state == RocketState.LANDED) {
                text.add("Insert next drive to continue");
            }
            ItemStack stack = player.func_70694_bm();
            if ((state == RocketState.LANDED || state == RocketState.AWAITING) && stack != null && stack.func_77973_b() instanceof ItemVOTVdrive && ItemVOTVdrive.getProcessed(stack)) {
                text.add("Interact to swap drive");
            }
        }
        ILookOverlay.printGeneric(event, "Rocket", 0xFFFF00, 0x404000, text);
    }

    public boolean func_70104_M() {
        return true;
    }

    @Override
    public ItemStack getMissileItemForInfo() {
        return new ItemStack(ModItems.rocket_custom);
    }

    @Override
    public List<ItemStack> getDebris() {
        return null;
    }

    @Override
    public ItemStack getDebrisRareDrop() {
        return null;
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        super.init(ticket);
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (this.canRide()) {
            return;
        }
        super.loadNeighboringChunks(newChunkX, newChunkZ);
    }

    @Override
    public void clearChunkLoader() {
        if (this.canRide()) {
            return;
        }
        super.clearChunkLoader();
    }

    @Override
    public void serialize(ByteBuf buf) {
        OrbitalStation.getStationFromPosition((int)this.field_70165_t, (int)this.field_70161_v).serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        OrbitalStation.clientStation = OrbitalStation.deserialize(buf);
    }

    public static class EntityRideableRocketDummy
    extends Entity
    implements ILookOverlay {
        public EntityRideableRocket parent;
        private static final int WATCHABLE_PARENT_ID = 3;

        public EntityRideableRocketDummy(World world) {
            super(world);
            this.func_70105_a(4.0f, 2.5f);
        }

        public EntityRideableRocketDummy(World world, EntityRideableRocket parent) {
            this(world);
            this.parent = parent;
            this.field_70180_af.func_75692_b(3, (Object)parent.func_145782_y());
        }

        protected void func_70088_a() {
            this.field_70180_af.func_75682_a(3, (Object)0);
        }

        public void func_70071_h_() {
            Entity entity;
            if (!this.field_70170_p.field_72995_K) {
                if (this.parent == null || this.parent.field_70128_L) {
                    this.func_70106_y();
                }
            } else if (this.parent == null && (entity = this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(3))) != null && entity instanceof EntityRideableRocket) {
                this.parent = (EntityRideableRocket)entity;
            }
        }

        protected void func_70014_b(NBTTagCompound nbt) {
        }

        public boolean func_70039_c(NBTTagCompound nbt) {
            return false;
        }

        public void func_70037_a(NBTTagCompound nbt) {
            this.func_70106_y();
        }

        @Override
        public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
            if (this.parent == null) {
                return;
            }
            this.parent.printHook(event, world, x, y, z);
        }

        public boolean func_130002_c(EntityPlayer player) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.func_130002_c(player);
        }

        public boolean func_70067_L() {
            return true;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.func_70097_a(source, amount);
        }
    }

    public static enum RocketState {
        AWAITING,
        LAUNCHING,
        LANDING,
        LANDED,
        TIPPING,
        DOCKING,
        UNDOCKING,
        NEEDSFUEL,
        TRANSFER;

    }
}

